/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public final class PolygonRenderUtils {
    public static void drawPolygon(DLGuiGraphics graphics, List<Vector2f> points, int z, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        PolygonRenderUtils.fillPolygon(graphics, points, z, fillColor);
        PolygonRenderUtils.drawPolygonOutline(graphics, points, outlineWidth, outlineColor);
    }

    public static void drawLine(DLGuiGraphics graphics, float x1, float y1, float x2, float y2, float width, DLColor color) {
        Vector2f p1 = new Vector2f(x1, y1);
        Vector2f p2 = new Vector2f(x2, y2);
        Vector2f dir = new Vector2f((Vector2fc)p2).sub((Vector2fc)p1).normalize();
        Vector2f normal = new Vector2f(-dir.y, dir.x).mul(width / 2.0f);
        List<Vector2f> quad = List.of(new Vector2f((Vector2fc)p1).add((Vector2fc)normal), new Vector2f((Vector2fc)p2).add((Vector2fc)normal), new Vector2f((Vector2fc)p2).sub((Vector2fc)normal), new Vector2f((Vector2fc)p1).sub((Vector2fc)normal));
        PolygonRenderUtils.fillPolygon(graphics, quad, 0, color);
    }

    public static void drawRectangle(DLGuiGraphics graphics, float x, float y, float width, float height, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        List<Vector2f> rect = List.of(new Vector2f(x, y), new Vector2f(x + width, y), new Vector2f(x + width, y + height), new Vector2f(x, y + height));
        PolygonRenderUtils.drawPolygon(graphics, rect, 0, fillColor, outlineColor, outlineWidth);
    }

    public static void drawTriangle(DLGuiGraphics graphics, float x1, float y1, float x2, float y2, float x3, float y3, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        List<Vector2f> tri = List.of(new Vector2f(x1, y1), new Vector2f(x2, y2), new Vector2f(x3, y3));
        PolygonRenderUtils.drawPolygon(graphics, tri, 0, fillColor, outlineColor, outlineWidth);
    }

    public static void drawCircle(DLGuiGraphics graphics, float cx, float cy, float radius, int segments, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        ArrayList<Vector2f> circle = new ArrayList<Vector2f>();
        for (int i = 0; i < segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = cx + (float)Math.cos(angle) * radius;
            float y = cy + (float)Math.sin(angle) * radius;
            circle.add(new Vector2f(x, y));
        }
        PolygonRenderUtils.drawPolygon(graphics, circle, 0, fillColor, outlineColor, outlineWidth);
    }

    public static void drawEllipse(DLGuiGraphics graphics, float cx, float cy, float rx, float ry, int segments, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        ArrayList<Vector2f> ellipse = new ArrayList<Vector2f>();
        for (int i = 0; i < segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = cx + (float)Math.cos(angle) * rx;
            float y = cy + (float)Math.sin(angle) * ry;
            ellipse.add(new Vector2f(x, y));
        }
        PolygonRenderUtils.drawPolygon(graphics, ellipse, 0, fillColor, outlineColor, outlineWidth);
    }

    public static void drawRegularPolygon(DLGuiGraphics graphics, float cx, float cy, float radius, int sides, DLColor fillColor, DLColor outlineColor, float outlineWidth) {
        ArrayList<Vector2f> poly = new ArrayList<Vector2f>();
        for (int i = 0; i < sides; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)sides;
            float x = cx + (float)Math.cos(angle) * radius;
            float y = cy + (float)Math.sin(angle) * radius;
            poly.add(new Vector2f(x, y));
        }
        PolygonRenderUtils.drawPolygon(graphics, poly, 0, fillColor, outlineColor, outlineWidth);
    }

    public static void drawPolygonOutline(DLGuiGraphics graphics, List<Vector2f> points, float lineWidth, DLColor color) {
        int i;
        if (points.size() < 2) {
            return;
        }
        Matrix4f matrix = graphics.poseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = graphics.graphics().m_280091_().m_6299_(RenderType.m_285907_());
        float alpha = color.getAlphaF();
        float red = color.getRedF();
        float green = color.getGreenF();
        float blue = color.getBlueF();
        int n = points.size();
        boolean ccw = PolygonRenderUtils.polygonArea(points) > 0.0f;
        Vector2f[] miters = new Vector2f[n];
        for (i = 0; i < n; ++i) {
            Vector2f pPrev = points.get((i - 1 + n) % n);
            Vector2f pCurr = points.get(i);
            Vector2f pNext = points.get((i + 1) % n);
            Vector2f dirPrev = new Vector2f((Vector2fc)pCurr).sub((Vector2fc)pPrev).normalize();
            Vector2f normalPrev = new Vector2f(ccw ? -dirPrev.y : dirPrev.y, ccw ? dirPrev.x : -dirPrev.x);
            Vector2f dirNext = new Vector2f((Vector2fc)pNext).sub((Vector2fc)pCurr).normalize();
            Vector2f normalNext = new Vector2f(ccw ? -dirNext.y : dirNext.y, ccw ? dirNext.x : -dirNext.x);
            Vector2f miter = new Vector2f((Vector2fc)normalPrev).add((Vector2fc)normalNext).normalize();
            float dot = miter.dot((Vector2fc)normalNext);
            float miterLength = dot != 0.0f ? lineWidth / dot : lineWidth;
            miters[i] = miter.mul(miterLength, new Vector2f());
        }
        for (i = 0; i < n; ++i) {
            Vector2f p0 = points.get(i);
            Vector2f p1 = points.get((i + 1) % n);
            Vector2f m0 = miters[i];
            Vector2f m1 = miters[(i + 1) % n];
            Vector2f v0 = new Vector2f((Vector2fc)p0).add((Vector2fc)m0);
            Vector2f v1 = new Vector2f((Vector2fc)p1).add((Vector2fc)m1);
            Vector2f v2 = new Vector2f((Vector2fc)p1);
            Vector2f v3 = new Vector2f((Vector2fc)p0);
            if (!PolygonRenderUtils.isCCW(v0, v1, v2)) {
                vertexConsumer.m_252986_(matrix, v0.x, v0.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
                vertexConsumer.m_252986_(matrix, v1.x, v1.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
                vertexConsumer.m_252986_(matrix, v2.x, v2.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
                vertexConsumer.m_252986_(matrix, v3.x, v3.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
                continue;
            }
            vertexConsumer.m_252986_(matrix, v0.x, v0.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix, v3.x, v3.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix, v2.x, v2.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            vertexConsumer.m_252986_(matrix, v1.x, v1.y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        graphics.graphics().m_280262_();
    }

    private static boolean isCCW(Vector2f a, Vector2f b, Vector2f c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0f;
    }

    public static void fillPolygon(DLGuiGraphics graphics, List<Vector2f> points, int z, DLColor color) {
        if (points.size() < 3) {
            return;
        }
        Matrix4f matrix = graphics.poseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = graphics.graphics().m_280091_().m_6299_(RenderType.m_285907_());
        float a = color.getAlphaF();
        float r = color.getRedF();
        float g = color.getGreenF();
        float b = color.getBlueF();
        ArrayList<Vector2f> poly = new ArrayList<Vector2f>(points);
        if (PolygonRenderUtils.polygonArea(poly) < 0.0f) {
            Collections.reverse(poly);
        }
        List<int[]> triangles = PolygonRenderUtils.earClipTriangulate(poly);
        for (int[] tri : triangles) {
            Vector2f v0 = (Vector2f)poly.get(tri[0]);
            Vector2f v1 = (Vector2f)poly.get(tri[1]);
            Vector2f v2 = (Vector2f)poly.get(tri[2]);
            float cross = (v1.x - v0.x) * (v2.y - v0.y) - (v1.y - v0.y) * (v2.x - v0.x);
            if (cross < 0.0f) {
                Vector2f tmp = v1;
                v1 = v2;
                v2 = tmp;
            }
            vertexConsumer.m_252986_(matrix, v2.x, v2.y, (float)z).m_85950_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, v2.x, v2.y, (float)z).m_85950_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, v1.x, v1.y, (float)z).m_85950_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, v0.x, v0.y, (float)z).m_85950_(r, g, b, a).m_5752_();
        }
        graphics.graphics().m_280262_();
    }

    private static float polygonArea(List<Vector2f> poly) {
        float sum = 0.0f;
        for (int i = 0; i < poly.size(); ++i) {
            Vector2f p1 = poly.get(i);
            Vector2f p2 = poly.get((i + 1) % poly.size());
            sum += p1.x * p2.y - p2.x * p1.y;
        }
        return sum * 0.5f;
    }

    private static List<int[]> earClipTriangulate(List<Vector2f> poly) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        ArrayList<Integer> V = new ArrayList<Integer>();
        for (int i = 0; i < poly.size(); ++i) {
            V.add(i);
        }
        while (V.size() > 3) {
            boolean earFound = false;
            for (int i = 0; i < V.size(); ++i) {
                Vector2f c;
                Vector2f b;
                int i0 = (Integer)V.get((i + V.size() - 1) % V.size());
                int i1 = (Integer)V.get(i);
                int i2 = (Integer)V.get((i + 1) % V.size());
                Vector2f a = poly.get(i0);
                if (!PolygonRenderUtils.isConvex(a, b = poly.get(i1), c = poly.get(i2))) continue;
                boolean contains = false;
                for (int j = 0; j < V.size(); ++j) {
                    int vi = (Integer)V.get(j);
                    if (vi == i0 || vi == i1 || vi == i2 || !PolygonRenderUtils.pointInTriangle(poly.get(vi), a, b, c)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                result.add(new int[]{i0, i1, i2});
                V.remove(i);
                earFound = true;
                break;
            }
            if (earFound) continue;
            break;
        }
        if (V.size() == 3) {
            result.add(new int[]{(Integer)V.get(0), (Integer)V.get(1), (Integer)V.get(2)});
        }
        return result;
    }

    private static boolean isConvex(Vector2f a, Vector2f b, Vector2f c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0f;
    }

    private static boolean pointInTriangle(Vector2f p, Vector2f a, Vector2f b, Vector2f c) {
        float area3;
        float area2;
        float area1;
        float area = Math.abs(PolygonRenderUtils.cross(a, b) + PolygonRenderUtils.cross(b, c) + PolygonRenderUtils.cross(c, a));
        return (double)Math.abs(area - ((area1 = Math.abs(PolygonRenderUtils.cross(p, a) + PolygonRenderUtils.cross(a, b) + PolygonRenderUtils.cross(b, p))) + (area2 = Math.abs(PolygonRenderUtils.cross(p, b) + PolygonRenderUtils.cross(b, c) + PolygonRenderUtils.cross(c, p))) + (area3 = Math.abs(PolygonRenderUtils.cross(p, c) + PolygonRenderUtils.cross(c, a) + PolygonRenderUtils.cross(a, p))))) < 0.001;
    }

    private static float cross(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }

    public static enum OutlineMode {
        INWARD,
        CENTER,
        OUTWARD;

    }
}

