/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.data;

import net.minecraft.nbt.CompoundTag;

public record DLStatus(byte flag, int code, String message) {
    private static final String NBT_FLAG = "Flag";
    private static final String NBT_CODE = "Code";
    private static final String NBT_MESSAGE = "Message";
    public static final byte CODE_UNKNOWN = -1;
    public static final byte FLAG_OK = 0;
    public static final byte FLAG_DONE = 1;
    public static final byte FLAG_CANCEL = 2;
    public static final byte FLAG_ERROR = -128;
    public static final DLStatus OK = new DLStatus(0, -1, "");
    public static final DLStatus DONE = new DLStatus(1, -1, "");
    public static final DLStatus CANCEL = new DLStatus(2, -1, "");
    public static final DLStatus EMPTY = new DLStatus(-128, -1, "Not initialized!");

    public static final DLStatus error(Throwable ex) {
        return DLStatus.error(ex, -1);
    }

    public static final DLStatus error(Throwable ex, int code) {
        return new DLStatus(-128, code, ex.getMessage());
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_(NBT_FLAG, this.flag);
        nbt.m_128405_(NBT_CODE, this.code);
        nbt.m_128359_(NBT_MESSAGE, this.message);
        return nbt;
    }

    public static DLStatus fromNbt(CompoundTag nbt) {
        return new DLStatus(nbt.m_128445_(NBT_FLAG), nbt.m_128451_(NBT_CODE), nbt.m_128461_(NBT_MESSAGE));
    }

    public boolean isDone() {
        return this.flag == 1;
    }

    public boolean isCancel() {
        return this.flag == 2;
    }

    public boolean isError() {
        return this.flag == -128;
    }

    public boolean isOK() {
        return this.flag == 0;
    }
}

