/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.data;

import de.mrjulsen.mcdragonlib.util.DLUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class WorldLocation {
    private static final String NBT_X = "x";
    private static final String NBT_Y = "y";
    private static final String NBT_Z = "z";
    private static final String NBT_DIM = "dimension";
    public final double x;
    public final double y;
    public final double z;
    public final ResourceLocation dimension;

    public WorldLocation(double x, double y, double z, ResourceLocation dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public WorldLocation(int x, int y, int z, Level level) {
        this((double)x, (double)y, (double)z, level);
    }

    public WorldLocation(double x, double y, double z, Level level) {
        this(x, y, z, level.m_46472_().m_135782_());
    }

    public WorldLocation(Vec3i vec, Level level) {
        this(vec.m_123341_(), vec.m_123342_(), vec.m_123343_(), level);
    }

    public WorldLocation(Vec3 vec, Level level) {
        this(vec.f_82479_, vec.f_82480_, vec.f_82481_, level);
    }

    public WorldLocation(Vector3fc vec, Level level) {
        this((double)vec.x(), (double)vec.y(), (double)vec.z(), level);
    }

    public WorldLocation(Vector3dc vec, Level level) {
        this(vec.x(), vec.y(), vec.z(), level);
    }

    public BlockPos getLocationBlockPos() {
        return new BlockPos(this.getLocationVec3i());
    }

    public Vec3i getLocationVec3i() {
        return new Vec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public Vec3 getLocationVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public Vector3f getLocationVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3i getLocationVector3i() {
        return new Vector3i((int)this.x, (int)this.y, (int)this.z);
    }

    public Vector3d getLocationVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(NBT_X, this.x);
        tag.m_128347_(NBT_Y, this.y);
        tag.m_128347_(NBT_Z, this.z);
        tag.m_128359_(NBT_DIM, this.dimension.toString());
        return tag;
    }

    public static WorldLocation loadFromNbt(CompoundTag tag) {
        return new WorldLocation(tag.m_128459_(NBT_X), tag.m_128459_(NBT_Y), tag.m_128459_(NBT_Z), DLUtils.resourceLocation(tag.m_128461_(NBT_DIM)));
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorldLocation) {
            WorldLocation other = (WorldLocation)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.dimension.equals((Object)other.dimension);
        }
        return false;
    }

    public String toString() {
        return String.format("x=%s, y=%s, z=%s, dim=%s", this.x, this.y, this.z, this.dimension);
    }
}

