/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.events;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.events.EventListenerId;
import de.mrjulsen.mcdragonlib.events.EventListenerWrapper;
import de.mrjulsen.mcdragonlib.events.EventNotSupportedException;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.events.IEventListener;
import java.util.Collections;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;

public interface IEventDispatcher<S extends IEventDispatcher<S>> {
    public Map<Class<? extends IEvent>, PriorityQueue<EventListenerWrapper<?>>> getEventListeners();

    default public <T extends IEvent> EventListenerId addEventListener(Class<T> aClass, IEventListener<S, T> iEventListener) throws EventNotSupportedException {
        return this.addEventListener(aClass, iEventListener, 0);
    }

    default public <T extends IEvent> EventListenerId addEventListener(Class<T> aClass, IEventListener<S, T> iEventListener, int priority) throws EventNotSupportedException {
        UUID id;
        if (!this.isEventSupported(aClass)) {
            throw new EventNotSupportedException(this.getClass(), aClass);
        }
        PriorityQueue queue = this.getEventListeners().computeIfAbsent(aClass, k -> new PriorityQueue(Collections.reverseOrder()));
        while (queue.contains(id = UUID.randomUUID())) {
        }
        EventListenerId listenerId = new EventListenerId(id);
        queue.add(new EventListenerWrapper<IEventListener<S, T>>(iEventListener, priority, listenerId));
        return listenerId;
    }

    default public <T extends IEvent> boolean invokeEvent(S src, T event) {
        return this.invokeEvent(src, event, true);
    }

    default public <T extends IEvent> boolean invokeEvent(S src, T event, boolean allowCancellation) {
        PriorityQueue<EventListenerWrapper<?>> l = this.getEventListeners().get(event.getClass());
        if (l != null) {
            PriorityQueue tempQueue = new PriorityQueue(l);
            while (!tempQueue.isEmpty()) {
                if (!tempQueue.poll().event().invoke(src, event) || !allowCancellation) continue;
                if (!event.isCancellable()) {
                    throw new IllegalStateException("The event " + String.valueOf(event) + " cannot be cancelled.");
                }
                return false;
            }
        }
        return true;
    }

    default public boolean isEventSupported(Class<? extends IEvent> eventType) {
        for (Class<?> currentClass = this.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            SupportsEvents annotation = currentClass.getAnnotation(SupportsEvents.class);
            if (annotation == null) continue;
            for (Class<? extends IEvent> supported : annotation.value()) {
                if (!supported.equals(eventType)) continue;
                return true;
            }
        }
        return false;
    }

    default public <T extends IEvent> boolean removeEventListener(Class<T> aClass, EventListenerId id) {
        if (this.getEventListeners().containsKey(aClass)) {
            return this.getEventListeners().get(aClass).removeIf(x -> x.equals(id));
        }
        return false;
    }
}

