/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.forge.client.model;

import de.mrjulsen.mcdragonlib.client.model.ICustomModelBlockEntity;
import de.mrjulsen.mcdragonlib.client.model.IDynamicBakedModel;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModel
implements BakedModel,
IDynamicBakedModel {
    private final ModelProperty<ModelContext> MODEL_CONTEXT_PROPERTY = new ModelProperty();
    private final BlockState defaultState;
    private final BakedModel src;
    private final DLModel newModel;

    public DynamicBakedModel(BakedModel src, BlockState defaultState, DLModel newModel) {
        Objects.requireNonNull(defaultState);
        this.src = src;
        this.defaultState = defaultState;
        this.newModel = newModel;
    }

    @Override
    public BakedModel getOriginalModel() {
        return this.src;
    }

    @Override
    public DLModel getModel() {
        return this.newModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        DLModel.ModelType type = DLModel.ModelType.isItem(state == null);
        return this.newModel.getQuads(type, this.src, state == null ? this.defaultState : state, rand, renderType, side, data.has(this.MODEL_CONTEXT_PROPERTY) ? (ModelContext)data.get(this.MODEL_CONTEXT_PROPERTY) : ModelContext.EMPTY);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ICustomModelBlockEntity) {
            ICustomModelBlockEntity be = (ICustomModelBlockEntity)blockEntity;
            return ModelData.builder().with(this.MODEL_CONTEXT_PROPERTY, (Object)be.getModelContext()).build();
        }
        return modelData;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of(this.newModel.getSupportedRenderTypes());
    }

    public ItemTransforms m_7442_() {
        return this.src.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.src.m_7343_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.src.m_6160_();
    }

    public boolean m_7521_() {
        return false;
    }

    public boolean m_7539_() {
        return this.src.m_7539_();
    }

    public boolean m_7541_() {
        return this.newModel.useAmbientOcclusion() == null ? this.src.m_7541_() : this.newModel.useAmbientOcclusion().booleanValue();
    }

    public boolean m_7547_() {
        return this.src.m_7547_();
    }

    public List<BakedQuad> m_213637_(BlockState state, Direction direction, RandomSource rand) {
        return this.getQuads(state, direction, rand, ModelData.EMPTY, null);
    }
}

