/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum CommunicationType {
    NONE(0),
    REQUEST(1),
    RESPONSE(2);

    private final byte id;
    private static final Map<Byte, CommunicationType> TYPES_BY_ID;

    private CommunicationType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static CommunicationType getById(byte id) {
        if (TYPES_BY_ID.containsKey(id)) {
            return TYPES_BY_ID.get(id);
        }
        return NONE;
    }

    static {
        TYPES_BY_ID = Arrays.stream(CommunicationType.values()).collect(Collectors.toMap(x -> x.getId(), x -> x));
    }
}

