/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network;

import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.CommunicationType;
import de.mrjulsen.mcdragonlib.network.DLNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.network.NetworkProcessor;
import de.mrjulsen.mcdragonlib.network.NetworkSide;
import de.mrjulsen.mcdragonlib.network.packet.NetworkPacker;
import de.mrjulsen.mcdragonlib.network.packet.PacketHeaderInfo;
import de.mrjulsen.mcdragonlib.network.packet.PacketType;
import de.mrjulsen.mcdragonlib.util.DLStatistics;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkPacketType<N extends NetworkDirection, I extends NetworkPacketData, O extends NetworkPacketData> {
    private final ResourceLocation channelId;
    private final String name;
    private final PacketType type;
    private final NetworkSide direction;
    private final Function<DLStatus, I> sendFactory;
    private final Function<DLStatus, O> responseFactory;

    public NetworkPacketType(ResourceLocation channelId, PacketType type, NetworkDirection direction, String name, Function<DLStatus, I> sendFactory, Function<DLStatus, O> responseFactory) {
        this.channelId = channelId;
        this.type = type;
        this.name = name;
        this.direction = direction.getDirection();
        this.sendFactory = sendFactory;
        this.responseFactory = responseFactory;
    }

    protected static void runSafe(Env environment, Supplier<Runnable> action) {
        if (environment == Env.CLIENT) {
            EnvExecutor.runInEnv((Env)environment, action);
        } else {
            action.get().run();
        }
    }

    abstract void receiveRequest(PacketHeaderInfo var1, NetworkPacketContext var2, I var3);

    abstract void receiveResponse(PacketHeaderInfo var1, NetworkPacketContext var2, O var3);

    public final ResourceLocation getChannelId() {
        return this.channelId;
    }

    public final String getName() {
        return this.name;
    }

    public final PacketType getType() {
        return this.type;
    }

    public final NetworkSide getDirection() {
        return this.direction;
    }

    public final PacketHeaderInfo getInfo(CommunicationType communication, long requestId) {
        return new PacketHeaderInfo(this.getType(), communication, requestId, this.getName());
    }

    protected void receive(PacketHeaderInfo info, NetworkPacketContext context, CompoundTag nbt, CommunicationType communication) {
        switch (communication) {
            case REQUEST: {
                this.receiveInternal(info, context, nbt);
                break;
            }
            case RESPONSE: {
                this.receiveResponseInternal(info, context, nbt);
                break;
            }
        }
    }

    protected I createEmptyInputData(DLStatus status) {
        return (I)((NetworkPacketData)this.sendFactory.apply(status));
    }

    protected O createEmptyOutputData(DLStatus status) {
        return (O)((NetworkPacketData)this.responseFactory.apply(status));
    }

    protected void sendInternal(long requestId, N sender, @Nullable CompoundTag nbt) {
        PacketHeaderInfo info = this.getInfo(CommunicationType.REQUEST, requestId);
        List<Packet<?>> mcPackets = NetworkPacker.pack(this.getChannelId(), info, sender.getDirection(), nbt);
        for (Packet<?> packet : mcPackets) {
            sender.send(packet);
        }
    }

    protected void receiveInternal(PacketHeaderInfo info, NetworkPacketContext context, CompoundTag nbt) {
        NetworkPacketData instance = (NetworkPacketData)this.sendFactory.apply(DLStatus.EMPTY);
        instance.deserializeNbt(nbt);
        this.receiveRequest(info, context, instance);
    }

    protected void respondInternal(PacketHeaderInfo header, NetworkPacketContext context, @Nullable CompoundTag nbt) {
        NetworkDirection.C2S sender = this.getDirection() == NetworkSide.C2S ? NetworkDirection.toPlayer((ServerPlayer)context.getPlayer()) : NetworkDirection.toServer();
        PacketHeaderInfo info = this.getInfo(CommunicationType.RESPONSE, header.requestId());
        List<Packet<?>> mcPackets = NetworkPacker.pack(this.getChannelId(), info, sender.getDirection(), nbt);
        for (Packet<?> packet : mcPackets) {
            sender.send(packet);
        }
    }

    protected void receiveResponseInternal(PacketHeaderInfo info, NetworkPacketContext context, CompoundTag nbt) {
        NetworkPacketData instance = (NetworkPacketData)this.responseFactory.apply(DLStatus.EMPTY);
        instance.deserializeNbt(nbt);
        this.receiveResponse(info, context, instance);
    }

    public static class Stream<N extends NetworkDirection, I extends NetworkPacketData, O extends NetworkPacketData>
    extends NetworkPacketType<N, I, O> {
        protected static final Map<Long, RequestData<?, ?>> callbacks = new ConcurrentHashMap();
        protected static final Map<Long, NetworkProcessor.StreamProvider<?, ?>> inputCache = new ConcurrentHashMap();
        protected static final Map<Long, NetworkProcessor.StreamReceiver<?, ?>> outputCache = new ConcurrentHashMap();
        private final Supplier<NetworkProcessor.StreamReceiver<I, O>> receiverFactory;

        public Stream(ResourceLocation channelId, String name, NetworkDirection direction, Supplier<NetworkProcessor.StreamReceiver<I, O>> receiverFactory, Function<DLStatus, I> inputFactory, Function<DLStatus, O> outputFactory) {
            super(channelId, PacketType.STREAM, direction, name, inputFactory, outputFactory);
            this.receiverFactory = receiverFactory;
        }

        public static DLStatistics debug_getStats() {
            DLStatistics.Group group = new DLStatistics.Group("callbacks", "Callbacks");
            DLStatistics stats = new DLStatistics("Network Stream Packets", List.of(new DLStatistics.Stat(group, "Result Callbacks", callbacks.size()), new DLStatistics.Stat(group, "Input Data Providers", inputCache.size()), new DLStatistics.Stat(group, "Output Data Providers", outputCache.size())));
            return stats;
        }

        @Override
        void receiveRequest(PacketHeaderInfo info, NetworkPacketContext context, I in) {
            context.queue(() -> Stream.runSafe(context.getEnvironment(), () -> () -> {
                try {
                    Object data = outputCache.computeIfAbsent(info.requestId(), l -> this.receiverFactory.get()).execute(in, context);
                    if (in.getStatus().isDone() || in.getStatus().isError() || in.getStatus().isCancel()) {
                        outputCache.remove(info.requestId());
                    }
                    this.respondInternal(info, context, ((NetworkPacketData)data).serializeNbt());
                }
                catch (Exception e) {
                    this.respondInternal(info, context, ((NetworkPacketData)this.createEmptyOutputData(DLStatus.error(e))).serializeNbt());
                    outputCache.remove(info.requestId());
                }
            }));
        }

        @Override
        void receiveResponse(PacketHeaderInfo info, NetworkPacketContext context, O in) {
            context.queue(() -> Stream.runSafe(context.getEnvironment(), () -> () -> {
                try {
                    Object data = inputCache.get(info.requestId()).execute(false, Optional.of(in), Optional.of(context));
                    RequestData<?, ?> requestData = callbacks.get(info.requestId());
                    if (!in.getStatus().isDone()) {
                        this.sendInternal(requestData.requestId(), NetworkDirection.forContext(requestData.sender(), context), ((NetworkPacketData)data).serializeNbt());
                    }
                    if (in.getStatus().isDone() || in.getStatus().isError() || in.getStatus().isCancel()) {
                        callbacks.remove(info.requestId()).callback().accept(((NetworkPacketData)data).getStatus());
                        inputCache.remove(info.requestId());
                    }
                }
                catch (Exception e) {
                    this.sendInternal(info.requestId(), context.buildDirection(), ((NetworkPacketData)this.createEmptyInputData(DLStatus.error(e))).serializeNbt());
                    callbacks.remove(info.requestId()).callback().accept(DLStatus.error(e));
                    inputCache.remove(info.requestId());
                }
            }));
        }

        public void send(N sender, NetworkProcessor.StreamProvider<I, O> handler, Consumer<DLStatus> finishCallback) {
            long requestId = System.nanoTime();
            callbacks.put(requestId, new RequestData(sender, requestId, finishCallback));
            inputCache.put(requestId, handler);
            this.sendInternal(requestId, sender, ((NetworkPacketData)handler.execute(true, Optional.empty(), Optional.empty())).serializeNbt());
        }

        private record RequestData<N extends NetworkDirection, O extends NetworkPacketData>(N sender, long requestId, Consumer<DLStatus> callback) {
        }
    }

    public static class SendAndReceive<N extends NetworkDirection, I extends NetworkPacketData, O extends NetworkPacketData>
    extends NetworkPacketType<N, I, O> {
        protected static final Map<Long, CompletableFuture<?>> callbacks = new ConcurrentHashMap();
        private final NetworkProcessor.SendAndReceive<I, O> handler;

        public SendAndReceive(ResourceLocation channelId, String name, NetworkDirection direction, NetworkProcessor.SendAndReceive<I, O> handler, Function<DLStatus, I> inputFactory, Function<DLStatus, O> outputFactory) {
            super(channelId, PacketType.SEND_AND_RECEIVE, direction, name, inputFactory, outputFactory);
            this.handler = handler;
        }

        public static DLStatistics debug_getStats() {
            DLStatistics.Group group = new DLStatistics.Group("callbacks", "Callbacks");
            DLStatistics stats = new DLStatistics("Network Send and Receive Packets", List.of(new DLStatistics.Stat(group, "Result Callbacks", callbacks.size())));
            return stats;
        }

        @Override
        void receiveRequest(PacketHeaderInfo info, NetworkPacketContext context, I in) {
            context.queue(() -> SendAndReceive.runSafe(context.getEnvironment(), () -> () -> {
                try {
                    O data = this.handler.execute((NetworkPacketData)in, context);
                    this.respondInternal(info, context, ((NetworkPacketData)data).serializeNbt());
                }
                catch (Exception e) {
                    this.respondInternal(info, context, ((NetworkPacketData)this.createEmptyOutputData(DLStatus.error(e))).serializeNbt());
                }
            }));
        }

        @Override
        void receiveResponse(PacketHeaderInfo info, NetworkPacketContext context, O in) {
            if (callbacks.containsKey(info.requestId())) {
                callbacks.remove(info.requestId()).complete(in);
            }
        }

        public void send(N sender, I data, Consumer<O> responseCallback, Runnable errorCallback) {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)((CompletableFuture)future.thenAccept(responseCallback)).exceptionally(ex -> {
                DLNetworkManager.LOGGER.error("Error while waiting for response.", ex);
                errorCallback.run();
                return null;
            })).orTimeout(60L, TimeUnit.SECONDS);
            this.send(sender, data, future);
        }

        public void send(N sender, I data, CompletableFuture<O> responseCallback) {
            long requestId = System.nanoTime();
            callbacks.put(requestId, responseCallback);
            this.sendInternal(requestId, sender, ((NetworkPacketData)data).serializeNbt());
        }
    }

    public static class Receive<N extends NetworkDirection, O extends NetworkPacketData>
    extends NetworkPacketType<N, NetworkPacketData.Empty, O> {
        protected static final Map<Long, CompletableFuture<?>> callbacks = new ConcurrentHashMap();
        private final NetworkProcessor.Receive<O> handler;

        public Receive(ResourceLocation channelId, String name, NetworkDirection direction, NetworkProcessor.Receive<O> handler, Function<DLStatus, O> factory) {
            super(channelId, PacketType.RECEIVE, direction, name, NetworkPacketData.Empty::new, factory);
            this.handler = handler;
        }

        public static DLStatistics debug_getStats() {
            DLStatistics.Group group = new DLStatistics.Group("callbacks", "Callbacks");
            DLStatistics stats = new DLStatistics("Network Receive Packets", List.of(new DLStatistics.Stat(group, "Result Callbacks", callbacks.size())));
            return stats;
        }

        @Override
        void receiveRequest(PacketHeaderInfo info, NetworkPacketContext context, NetworkPacketData.Empty in) {
            context.queue(() -> Receive.runSafe(context.getEnvironment(), () -> () -> {
                try {
                    O data = this.handler.execute(context);
                    this.respondInternal(info, context, ((NetworkPacketData)data).serializeNbt());
                }
                catch (Exception e) {
                    this.respondInternal(info, context, ((NetworkPacketData)this.createEmptyOutputData(DLStatus.error(e))).serializeNbt());
                }
            }));
        }

        @Override
        void receiveResponse(PacketHeaderInfo info, NetworkPacketContext context, O in) {
            if (callbacks.containsKey(info.requestId())) {
                callbacks.remove(info.requestId()).complete(in);
            }
        }

        public void send(N sender, Consumer<O> responseCallback, Runnable errorCallback) {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)((CompletableFuture)future.thenAccept(responseCallback)).exceptionally(ex -> {
                DLNetworkManager.LOGGER.error("Error while waiting for response.", ex);
                errorCallback.run();
                return null;
            })).orTimeout(60L, TimeUnit.SECONDS);
            this.send(sender, future);
        }

        public void send(N sender, CompletableFuture<O> responseCallback) {
            long requestId = System.nanoTime();
            callbacks.put(requestId, responseCallback);
            this.sendInternal(requestId, sender, new CompoundTag());
        }
    }

    public static class Send<N extends NetworkDirection, I extends NetworkPacketData>
    extends NetworkPacketType<N, I, NetworkPacketData.Empty> {
        protected final NetworkProcessor.Send<I> handler;

        public Send(ResourceLocation channelId, String name, NetworkDirection direction, NetworkProcessor.Send<I> handler, Function<DLStatus, I> factory) {
            super(channelId, PacketType.SEND, direction, name, factory, NetworkPacketData.Empty::new);
            this.handler = handler;
        }

        @Override
        void receiveRequest(PacketHeaderInfo info, NetworkPacketContext context, I in) {
            context.queue(() -> Send.runSafe(context.getEnvironment(), () -> () -> this.handler.execute((NetworkPacketData)in, context)));
        }

        @Override
        void receiveResponse(PacketHeaderInfo info, NetworkPacketContext context, NetworkPacketData.Empty in) {
        }

        public void send(N sender, I data) {
            long requestId = System.nanoTime();
            this.sendInternal(requestId, sender, ((NetworkPacketData)data).serializeNbt());
        }
    }
}

