/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network.builtin;

import de.mrjulsen.mcdragonlib.block.DLWritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.NbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WritableSignPacketData
extends NetworkPacketData {
    private static final String NBT_POS = "Pos";
    private static final String NBT_MESSAGES = "Messages";
    private String[] messages;
    private BlockPos pos;

    public WritableSignPacketData(DLStatus status) {
        super(status);
    }

    public WritableSignPacketData(BlockPos pos, String[] messages) {
        super(DLStatus.OK);
        this.pos = pos;
        this.messages = messages;
    }

    @Override
    protected void write(CompoundTag nbt) {
        NbtUtils.putNbtPos(nbt, NBT_POS, (Vec3i)this.pos);
        ListTag msgs = new ListTag();
        for (String msg : this.messages) {
            msgs.add((Object)StringTag.m_129297_((String)msg));
        }
        nbt.m_128365_(NBT_MESSAGES, (Tag)msgs);
    }

    @Override
    protected void read(CompoundTag nbt) {
        this.pos = NbtUtils.getNbtBlockPos(nbt, NBT_POS);
        this.messages = (String[])nbt.m_128437_(NBT_MESSAGES, 8).stream().map(x -> ((StringTag)x).m_7916_()).toArray(String[]::new);
    }

    public static void handler(WritableSignPacketData packet, NetworkPacketContext context) {
        context.queue(() -> {
            ServerPlayer sender = (ServerPlayer)context.getPlayer();
            BlockEntity patt0$temp = sender.m_9236_().m_7702_(packet.pos);
            if (patt0$temp instanceof DLWritableSignBlockEntity) {
                DLWritableSignBlockEntity blockEntity = (DLWritableSignBlockEntity)patt0$temp;
                blockEntity.setTexts(packet.messages);
            }
        });
    }
}

