/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network.forge;

import de.mrjulsen.mcdragonlib.network.DLNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkSide;
import de.mrjulsen.mcdragonlib.network.forge.ClientNetworkingManager;
import dev.architectury.utils.Env;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="dragonlib")
public class DLNetworkManagerImpl {
    public static void registerChannel(ResourceLocation channelId, String protocolVersion) {
        EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)channelId, () -> protocolVersion, version -> true, version -> true);
        channel.addListener(DLNetworkManagerImpl.createPacketHandler(NetworkEvent.ClientCustomPayloadEvent.class, channelId));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientNetworkingManager.initClient(channel, channelId));
    }

    static <T extends NetworkEvent> Consumer<T> createPacketHandler(Class<T> clazz, ResourceLocation channelId) {
        ResourceLocation id = channelId;
        return event -> {
            if (event.getClass() != clazz) {
                return;
            }
            final NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            if (context.getPacketHandled()) {
                return;
            }
            FriendlyByteBuf buffer = event.getPayload();
            if (buffer == null) {
                return;
            }
            NetworkSide side = context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? NetworkSide.C2S : NetworkSide.S2C;
            NetworkPacketContext packetContext = new NetworkPacketContext(){

                @Override
                public Player getPlayer() {
                    return this.getEnvironment() == Env.CLIENT ? this.getClientPlayer() : context.getSender();
                }

                @Override
                public void queue(Runnable runnable) {
                    context.enqueueWork(runnable);
                }

                @Override
                public Env getEnvironment() {
                    return context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? Env.CLIENT : Env.SERVER;
                }

                private Player getClientPlayer() {
                    return (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::getClientPlayer);
                }
            };
            DLNetworkManager.receiveData(id, buffer, side, packetContext);
            context.setPacketHandled(true);
        };
    }

    public static Packet<?> toPacket(ResourceLocation channelId, NetworkSide side, FriendlyByteBuf buffer) {
        return (side == NetworkSide.C2S ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).buildPacket(Pair.of((Object)buffer, (Object)0), channelId).getThis();
    }
}

