/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network.packet;

import de.mrjulsen.mcdragonlib.network.NetworkSide;
import de.mrjulsen.mcdragonlib.network.packet.PacketHeaderInfo;
import de.mrjulsen.mcdragonlib.network.packet.SegmentedPacketHeaderInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.PriorityBlockingQueue;
import net.minecraft.network.FriendlyByteBuf;

public class NetworkReceiverData {
    private final Key key;
    private final PriorityBlockingQueue<Chunk> chunks;

    public NetworkReceiverData(Key key, SegmentedPacketHeaderInfo info) {
        this.key = key;
        this.chunks = new PriorityBlockingQueue(info.expectedParts());
    }

    public final Key getKey() {
        return this.key;
    }

    public void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    public int chunksCount() {
        return this.chunks.size();
    }

    public FriendlyByteBuf mergeData() {
        ByteBuf[] buffers = new ByteBuf[this.chunksCount()];
        int i = 0;
        for (Chunk chunk : this.chunks) {
            buffers[i] = chunk.buffer;
            ++i;
        }
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((ByteBuf[])buffers));
    }

    public void close() {
        while (!this.chunks.isEmpty()) {
            Chunk chunk = this.chunks.poll();
            chunk.close();
        }
    }

    public record Key(PacketHeaderInfo info, NetworkSide side) {
    }

    public static class Chunk
    implements Comparable<Chunk> {
        private final int number;
        private final FriendlyByteBuf buffer;
        private boolean closed = false;

        public Chunk(int number, FriendlyByteBuf data) {
            this.number = number;
            this.buffer = data;
        }

        @Override
        public int compareTo(Chunk o) {
            return Integer.compare(this.number, o.number);
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.buffer.release();
            this.closed = true;
        }
    }
}

