/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network.packet;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SegmentType {
    SINGLE(0),
    START(1),
    PART(2),
    END(3);

    private final byte id;
    private static final Map<Byte, SegmentType> TYPES_BY_ID;

    private SegmentType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static SegmentType getById(byte id) {
        if (TYPES_BY_ID.containsKey(id)) {
            return TYPES_BY_ID.get(id);
        }
        return SINGLE;
    }

    static {
        TYPES_BY_ID = Arrays.stream(SegmentType.values()).collect(Collectors.toMap(x -> x.getId(), x -> x));
    }
}

