/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MapCache<T, S, I> {
    private final transient Map<Integer, T> cache = new ConcurrentHashMap<Integer, T>();
    private final transient Function<I, T> delegate;
    private final transient Function<S, Integer> hashFunction;
    private final transient ECachingPriority priority;

    public MapCache(Function<I, T> delegate, Function<S, Integer> hashFunction, ECachingPriority priority) {
        this.delegate = delegate;
        this.hashFunction = hashFunction;
        this.priority = priority;
    }

    public MapCache(Function<I, T> delegate, Function<S, Integer> hashFunction) {
        this(delegate, hashFunction, ECachingPriority.NORMAL);
    }

    public T get(I input, S hashInput) {
        if (!this.priority.shouldCache()) {
            this.clearAll();
            return this.delegate.apply(input);
        }
        return (T)this.cache.computeIfAbsent(this.hashFunction.apply(hashInput), x -> this.delegate.apply(input));
    }

    public void clearAll() {
        if (!this.cache.isEmpty()) {
            this.cache.clear();
        }
    }

    public void clear(S hashInput) {
        this.cache.remove(this.hashFunction.apply(hashInput));
    }

    public int getCachedDataCount() {
        return this.cache.size();
    }
}

