/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.collision;

import de.mrjulsen.mcdragonlib.util.collision.IRayTraceShape;
import java.util.Optional;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LineRayShape
implements IRayTraceShape {
    private final Vector3f pointA;
    private final Vector3f pointB;
    private final float radius;

    public LineRayShape(Vector3f a, Vector3f b, float radius) {
        this.pointA = new Vector3f((Vector3fc)a);
        this.pointB = new Vector3f((Vector3fc)b);
        this.radius = radius;
    }

    @Override
    public Optional<Vector3f> intersects(Vector3f rayOrigin, Vector3f rayDirection) {
        float t2;
        float c;
        Vector3f ba = new Vector3f((Vector3fc)this.pointB).sub((Vector3fc)this.pointA);
        Vector3f oa = new Vector3f((Vector3fc)rayOrigin).sub((Vector3fc)this.pointA);
        Vector3f d = new Vector3f((Vector3fc)rayDirection);
        Vector3f baNorm = new Vector3f((Vector3fc)ba).normalize();
        Vector3f dProj = this.projectOntoPlane(d, baNorm);
        Vector3f oaProj = this.projectOntoPlane(oa, baNorm);
        float a = dProj.dot((Vector3fc)dProj);
        float b = 2.0f * dProj.dot((Vector3fc)oaProj);
        float discriminant = b * b - 4.0f * a * (c = oaProj.dot((Vector3fc)oaProj) - this.radius * this.radius);
        if (discriminant < 0.0f) {
            return Optional.empty();
        }
        float sqrtDisc = (float)Math.sqrt(discriminant);
        float t1 = (-b - sqrtDisc) / (2.0f * a);
        float t = Math.min(t1, t2 = (-b + sqrtDisc) / (2.0f * a));
        if (t < 0.0f) {
            t = Math.max(t1, t2);
        }
        if (t < 0.0f) {
            return Optional.empty();
        }
        Vector3f hitPoint = new Vector3f((Vector3fc)rayOrigin).fma(t, (Vector3fc)d);
        float hitProj = new Vector3f((Vector3fc)hitPoint).sub((Vector3fc)this.pointA).dot((Vector3fc)baNorm);
        if (hitProj < 0.0f || hitProj > ba.length()) {
            return Optional.empty();
        }
        return Optional.of(hitPoint);
    }

    private Vector3f projectOntoPlane(Vector3f vec, Vector3f normal) {
        Vector3f proj = new Vector3f((Vector3fc)normal).mul(vec.dot((Vector3fc)normal));
        return new Vector3f((Vector3fc)vec).sub((Vector3fc)proj);
    }
}

