/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.math;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class MathUtils {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);
    public static final Vector3f CENTER_OF_ORIGIN2 = new Vector3f(0.5f, 0.5f, 0.5f);

    private MathUtils() {
    }

    public static double proportion(double val, double max) {
        return 1.0 / max * val;
    }

    public static double bounds(double value, double add, double min, double max) {
        if (add > 0.0 && value >= max - add || add < 0.0 && value <= min + add) {
            return value;
        }
        return value + add;
    }

    public static double round(double value, int decimals) {
        if (decimals < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, decimals);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static String printVector3f(Vector3fc vec) {
        return String.format("(%s, %s, %s)", Float.valueOf(vec.x()), Float.valueOf(vec.y()), Float.valueOf(vec.z()));
    }

    public static Vec3i blockPosToVec3i(BlockPos pos) {
        return new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vector3f blockPosToVector3f(BlockPos pos) {
        return new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
    }

    public static BlockPos vector3iToBlockPos(Vector3ic vec) {
        return new BlockPos(vec.x(), vec.y(), vec.z());
    }

    public static BlockPos vec3ToBlockPos(Vec3 vec) {
        return new BlockPos((int)vec.m_7096_(), (int)vec.m_7098_(), (int)vec.m_7094_());
    }

    public static BlockPos vec3iToBlockPos(Vec3i vec) {
        return new BlockPos(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public static Vector3i blockPosToVector3i(BlockPos pos) {
        return new Vector3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static double slope(Vector3f a, Vector3f b) {
        double heightDiff = Math.max(a.y, b.y) - Math.min(a.y, b.y);
        float dx = a.x - b.x;
        float dz = a.z - b.z;
        float horizontalDistance = (float)Math.sqrt(dx * dx + dz * dz);
        return (double)horizontalDistance / heightDiff;
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static byte clamp(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static double getVectorAngle(Vector3f vec) {
        return Math.round(Math.atan2(vec.x(), -vec.z()) * 57.29577951308232);
    }

    private static double calcScale(double minScale, double maxScale, double maxWidth, double fontWidth) {
        double scale = Math.min(maxWidth / fontWidth, 1.0);
        return Math.max(maxScale * scale, minScale);
    }

    public static double getScale(float fontWidth, float lineWidth, float min, float max) {
        return MathUtils.calcScale(min, max, lineWidth / max, fontWidth);
    }

    public static double calculateMedian(Queue<Double> database, double smoothingThreshold, Predicate<Double> filter) {
        if (database.isEmpty()) {
            return 0.0;
        }
        LinkedList<Double> values = new LinkedList<Double>();
        Iterator iterator = database.iterator();
        while (iterator.hasNext()) {
            double i = (Double)iterator.next();
            if (!filter.test(i)) continue;
            values.add(i);
        }
        Collections.sort(values);
        double median = 0.0;
        if (values.size() % 2 == 0) {
            median = ((Double)values.get(values.size() / 2) + (Double)values.get(values.size() / 2 + 1)) / 2.0;
        }
        double med = median = ((Double)values.get(values.size() / 2)).doubleValue();
        return database.stream().mapToDouble(x -> x).filter(x -> Math.abs(med - x) <= smoothingThreshold).average().orElse(0.0);
    }

    public static Vec3 rotate(Vec3 vec, Vec3 rotationVec) {
        return MathUtils.rotate(vec, rotationVec.f_82479_, rotationVec.f_82480_, rotationVec.f_82481_);
    }

    public static Vec3 rotate(Vec3 vec, double xRot, double yRot, double zRot) {
        return MathUtils.rotate(MathUtils.rotate(MathUtils.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3 rotateCentered(Vec3 vec, double deg, Direction.Axis axis) {
        Vec3 shift = MathUtils.getCenterOf((Vec3i)BlockPos.f_121853_);
        return MathUtils.rotate(vec.m_82546_(shift), deg, axis).m_82549_(shift);
    }

    public static Vec3 rotate(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public static boolean rectanglesIntersecting(double x1, double y1, double w1, double h1, double x2, double y2, double w2, double h2) {
        return x1 < x2 + w2 && y1 < y2 + h2 && x1 + w1 > x2 && y1 + h1 > y2;
    }

    public boolean isSectionInChunk(SectionPos section, ChunkPos chunk) {
        return section.m_123341_() == chunk.f_45578_ && section.m_123343_() == chunk.f_45579_;
    }

    public ChunkPos getChunkOfSection(SectionPos section) {
        return new ChunkPos(section.m_123341_(), section.m_123343_());
    }

    public static Vec2 rotateY(Vec2 vec, double deg) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec2.f_82462_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = vec.f_82470_;
        double y = vec.f_82471_;
        return new Vec2((float)(x * cos + y * sin), (float)(y * cos - x * sin));
    }

    public static VoxelShape moveShape(VoxelShape shape, Vec3 vec) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)MathUtils.moveAABB(aabbs[i], vec));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB moveAABB(AABB aabb, Vec3 vec) {
        return new AABB(aabb.f_82288_ + vec.f_82479_, aabb.f_82289_ + vec.f_82480_, aabb.f_82290_ + vec.f_82481_, aabb.f_82291_ + vec.f_82479_, aabb.f_82292_ + vec.f_82480_, aabb.f_82293_ + vec.f_82481_);
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction.Axis axis, int degrees) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)MathUtils.rotateAABB(aabbs[i], axis, degrees));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB rotateAABB(AABB aabb, Direction.Axis axis, int degrees) {
        int normalizedDegrees = (degrees % 360 + 360) % 360;
        if (normalizedDegrees == 0) {
            return aabb;
        }
        double minX = aabb.f_82288_;
        double minY = aabb.f_82289_;
        double minZ = aabb.f_82290_;
        double maxX = aabb.f_82291_;
        double maxY = aabb.f_82292_;
        double maxZ = aabb.f_82293_;
        switch (axis) {
            case X: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(minX, -maxZ, minY, maxX, -minZ, maxY);
                    }
                    case 180: {
                        return new AABB(minX, -maxY, -maxZ, maxX, -minY, -minZ);
                    }
                    case 270: {
                        return new AABB(minX, minZ, -maxY, maxX, maxZ, -minY);
                    }
                }
                break;
            }
            case Y: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                    }
                    case 180: {
                        return new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                    }
                    case 270: {
                        return new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                    }
                }
                break;
            }
            case Z: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(-maxY, minX, minZ, -minY, maxX, maxZ);
                    }
                    case 180: {
                        return new AABB(-maxX, -maxY, minZ, -minX, -minY, maxZ);
                    }
                    case 270: {
                        return new AABB(minY, -maxX, minZ, maxY, -minX, maxZ);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
            }
        }
        throw new IllegalArgumentException("Degrees must be 0, 90, 180, or 270");
    }

    public static VoxelShape scaleShape(VoxelShape shape, Direction.Axis axis, double factor, double pivot) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)MathUtils.scaleAABB(aabbs[i], axis, factor, pivot));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB scaleAABB(AABB aabb, Direction.Axis axis, double factor, double pivot) {
        double min;
        double max = switch (axis) {
            case Direction.Axis.X -> {
                min = aabb.f_82288_;
                yield aabb.f_82291_;
            }
            case Direction.Axis.Y -> {
                min = aabb.f_82289_;
                yield aabb.f_82292_;
            }
            case Direction.Axis.Z -> {
                min = aabb.f_82290_;
                yield aabb.f_82293_;
            }
            default -> throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
        };
        double minDiff = 0.5 - min;
        double maxDiff = max - 0.5;
        double newMin = 0.5 - factor * minDiff;
        double newMax = 0.5 + factor * maxDiff;
        return switch (axis) {
            case Direction.Axis.X -> new AABB(newMin, aabb.f_82289_, aabb.f_82290_, newMax, aabb.f_82292_, aabb.f_82293_);
            case Direction.Axis.Y -> new AABB(aabb.f_82288_, newMin, aabb.f_82290_, aabb.f_82291_, newMax, aabb.f_82293_);
            case Direction.Axis.Z -> new AABB(aabb.f_82288_, aabb.f_82289_, newMin, aabb.f_82291_, aabb.f_82292_, newMax);
            default -> aabb;
        };
    }

    public static VoxelShape scaleShapeOneSide(VoxelShape shape, Direction.Axis axis, double factor, Direction.AxisDirection direction) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)MathUtils.scaleAABBOneSide(aabbs[i], axis, factor, direction));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB scaleAABBOneSide(AABB aabb, Direction.Axis axis, double factor, Direction.AxisDirection direction) {
        double min;
        double max = switch (axis) {
            case Direction.Axis.X -> {
                min = aabb.f_82288_;
                yield aabb.f_82291_;
            }
            case Direction.Axis.Y -> {
                min = aabb.f_82289_;
                yield aabb.f_82292_;
            }
            case Direction.Axis.Z -> {
                min = aabb.f_82290_;
                yield aabb.f_82293_;
            }
            default -> throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
        };
        double minDiff = 0.5 - min;
        double maxDiff = max - 0.5;
        double newMin = direction == Direction.AxisDirection.NEGATIVE ? 0.5 - factor * minDiff : min;
        double newMax = direction == Direction.AxisDirection.POSITIVE ? 0.5 + factor * maxDiff : max;
        return switch (axis) {
            case Direction.Axis.X -> new AABB(newMin, aabb.f_82289_, aabb.f_82290_, newMax, aabb.f_82292_, aabb.f_82293_);
            case Direction.Axis.Y -> new AABB(aabb.f_82288_, newMin, aabb.f_82290_, aabb.f_82291_, newMax, aabb.f_82293_);
            case Direction.Axis.Z -> new AABB(aabb.f_82288_, aabb.f_82289_, newMin, aabb.f_82291_, aabb.f_82292_, newMax);
            default -> aabb;
        };
    }

    public static int checkPointPosition(Vec2 pointA, Vec2 pointB, Vec2 pointP) {
        return (int)Math.signum((pointB.f_82470_ - pointA.f_82470_) * (pointP.f_82471_ - pointA.f_82471_) - (pointB.f_82471_ - pointA.f_82471_) * (pointP.f_82470_ - pointA.f_82470_));
    }

    public static Vector3f rotateToDirection(Vector3f v, Vector3f dir) {
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f direction = new Vector3f((Vector3fc)dir).normalize();
        if (xAxis.equals((Vector3fc)direction, 1.0E-6f)) {
            return new Vector3f((Vector3fc)v);
        }
        if (xAxis.equals((Vector3fc)new Vector3f((Vector3fc)direction).negate(), 1.0E-6f)) {
            Quaternionf q180 = new Quaternionf().fromAxisAngleRad(0.0f, 0.0f, 1.0f, (float)Math.PI);
            return q180.transform(new Vector3f((Vector3fc)v));
        }
        Vector3f axis = xAxis.cross((Vector3fc)direction, new Vector3f()).normalize();
        float angle = (float)Math.acos(xAxis.dot((Vector3fc)direction));
        Quaternionf rotation = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, angle);
        return rotation.transform(new Vector3f((Vector3fc)v));
    }

    public static Vector3f rotate(Vector3f vec, Vector3f rotationVec) {
        return MathUtils.rotate(vec, (double)rotationVec.x, (double)rotationVec.y, (double)rotationVec.z);
    }

    public static Vector3f rotate(Vector3f vec, double xRot, double yRot, double zRot) {
        return MathUtils.rotate(MathUtils.rotate(MathUtils.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vector3f rotateCentered(Vector3f vec, double deg, Direction.Axis axis) {
        Vector3f shift = MathUtils.getCenterOf(new Vector3i());
        return MathUtils.rotate(new Vector3f((Vector3fc)vec).sub((Vector3fc)shift), deg, axis).add((Vector3fc)shift);
    }

    public static Vector3f rotate(Vector3f vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        float sin = Mth.m_14031_((float)angle);
        float cos = Mth.m_14089_((float)angle);
        float x = vec.x;
        float y = vec.y;
        float z = vec.z;
        if (axis == Direction.Axis.X) {
            return new Vector3f(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vector3f getCenterOf(Vector3i pos) {
        if (pos.equals((Object)new Vector3i())) {
            return CENTER_OF_ORIGIN2;
        }
        return new Vector3f((Vector3ic)pos).add(0.5f, 0.5f, 0.5f);
    }

    public static Vector3f centerOf(Vector3f ... points) {
        if (points == null || points.length == 0) {
            return null;
        }
        Vector3f sum = new Vector3f(0.0f, 0.0f, 0.0f);
        for (Vector3f v : points) {
            sum.add((Vector3fc)v);
        }
        sum.div((float)points.length);
        return sum;
    }

    public static double snap(double x, double a) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a must be > 0");
        }
        return Math.floor(x / a) * a;
    }

    public static double snapNearest(double x, double a) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a must be > 0");
        }
        return (double)Math.round(x / a) * a;
    }
}

