/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.math;

import java.util.Objects;

public class Point {
    protected double x;
    protected double y;

    protected Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Point of(double x, double y) {
        return new Point(x, y);
    }

    public static double distance(Point a, Point b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        double dX = Math.abs(a.x() - b.x());
        double dY = Math.abs(a.y() - b.y());
        return Math.sqrt(Math.pow(dX, 2.0) + Math.pow(dY, 2.0));
    }

    public static Point center(Point ... points) {
        Objects.requireNonNull(points);
        double sumX = 0.0;
        double sumY = 0.0;
        for (Point p : points) {
            sumX += p.x;
            sumY += p.y;
        }
        double mX = sumX / (double)points.length;
        double mY = sumY / (double)points.length;
        return new Point(mX, mY);
    }

    public Point add(Point p) {
        return new Point(this.x + p.x, this.y + p.y);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point o = (Point)obj;
            return this.x == o.x && this.y == o.y;
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.x, this.y);
    }

    public String toString() {
        return String.format("Point[x=%s,y=%s]", this.x, this.y);
    }
}

