/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.math;

import de.mrjulsen.mcdragonlib.util.math.Point;
import java.util.Collection;
import java.util.Objects;

public class Rectangle {
    public static final double MAX_DOUBLE = 8.988465674311579E307;
    public static final Rectangle INFINITE = new Rectangle(-8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307);
    public static final Rectangle EMPTY = new Rectangle(0.0, 0.0, 0.0, 0.0);
    protected double x1;
    protected double y1;
    protected double x2;
    protected double y2;

    protected Rectangle(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static Rectangle withPoints(double x1, double y1, double x2, double y2) {
        if (Double.isInfinite(x1) || Double.isInfinite(y1) || Double.isInfinite(x2) || Double.isInfinite(y2)) {
            throw new IllegalArgumentException("Rectangle does not support infinite values.");
        }
        return new Rectangle(x1, y1, x2, y2);
    }

    public static Rectangle withSize(double x, double y, double w, double h) {
        return Rectangle.withPoints(x, y, Math.max(x + w, 0.0), Math.max(y + h, 0.0));
    }

    public static Rectangle surrounding(Collection<Rectangle> rectangles) {
        return Rectangle.surrounding((Rectangle[])rectangles.toArray(Rectangle[]::new));
    }

    public Rectangle scale(double factor) {
        return new Rectangle(this.x() * factor, this.y() * factor, this.width() * factor, this.height() * factor);
    }

    public static Rectangle offset(Rectangle rect, double dx, double dy) {
        double overflow;
        double newX = rect.x() + dx;
        double newY = rect.y() + dy;
        double width = rect.width();
        double height = rect.height();
        if (newX < -8.988465674311579E307) {
            overflow = -8.988465674311579E307 - newX;
            newX = -8.988465674311579E307;
            width = Math.max(0.0, width - overflow);
        } else if (newX + width > 8.988465674311579E307) {
            overflow = newX + width - 8.988465674311579E307;
            width = Math.max(0.0, width - overflow);
        }
        if (newY < -8.988465674311579E307) {
            overflow = -8.988465674311579E307 - newY;
            newY = -8.988465674311579E307;
            height = Math.max(0.0, height - overflow);
        } else if (newY + height > 8.988465674311579E307) {
            overflow = newY + height - 8.988465674311579E307;
            height = Math.max(0.0, height - overflow);
        }
        return Rectangle.withSize(newX, newY, width, height);
    }

    public static Rectangle surroundingBase(Rectangle base, Rectangle ... rectangles) {
        Rectangle[] rects = new Rectangle[rectangles.length + 1];
        System.arraycopy(rectangles, 0, rects, 1, rectangles.length);
        rects[0] = base;
        return Rectangle.surrounding(rects);
    }

    public static Rectangle surrounding(Rectangle ... rectangles) {
        double x1 = 8.988465674311579E307;
        double y1 = 8.988465674311579E307;
        double x2 = -8.988465674311579E307;
        double y2 = -8.988465674311579E307;
        for (Rectangle rect : rectangles) {
            x1 = Math.min(x1, rect.x1);
            y1 = Math.min(y1, rect.y1);
            x2 = Math.max(x2, rect.x2);
            y2 = Math.max(y2, rect.y2);
        }
        return Rectangle.withPoints(x1, y1, x2, y2);
    }

    public static Rectangle intersection(Collection<Rectangle> rectangles) {
        return Rectangle.intersection((Rectangle[])rectangles.toArray(Rectangle[]::new));
    }

    public static Rectangle intersectionBase(Rectangle base, Rectangle ... rectangles) {
        Rectangle[] rects = new Rectangle[rectangles.length + 1];
        System.arraycopy(rectangles, 0, rects, 1, rectangles.length);
        rects[0] = base;
        return Rectangle.intersection(rects);
    }

    public static Rectangle intersection(Rectangle ... rectangles) {
        double x1 = -8.988465674311579E307;
        double y1 = -8.988465674311579E307;
        double x2 = 8.988465674311579E307;
        double y2 = 8.988465674311579E307;
        for (Rectangle rect : rectangles) {
            x1 = Math.max(x1, rect.x1);
            y1 = Math.max(y1, rect.y1);
            x2 = Math.min(x2, rect.x2);
            y2 = Math.min(y2, rect.y2);
        }
        if (x2 < x1 || y2 < y1) {
            return EMPTY;
        }
        return Rectangle.withPoints(x1, y1, x2, y2);
    }

    public boolean collision(Point point) {
        return this.collision(point.x(), point.y());
    }

    public boolean collision(double x, double y) {
        if (this == EMPTY) {
            return false;
        }
        return this.left() <= x && this.right() >= x && this.top() <= y && this.bottom() >= y;
    }

    public boolean collision(Rectangle rectangle) {
        if (this == EMPTY || rectangle == EMPTY) {
            return false;
        }
        return this.right() >= rectangle.left() && this.left() <= rectangle.right() && this.bottom() >= rectangle.top() && this.top() <= rectangle.bottom();
    }

    public double left() {
        return this.x1;
    }

    public double top() {
        return this.y1;
    }

    public double right() {
        return this.x2;
    }

    public double bottom() {
        return this.y2;
    }

    public double x() {
        return this.left();
    }

    public double y() {
        return this.top();
    }

    public double width() {
        return this.right() - this.left();
    }

    public double height() {
        return this.bottom() - this.top();
    }

    public String toString() {
        return String.format("Rectangle[x1=%s,y1=%s,x2=%s,y2=%s,w=%s,h=%s]", this.left(), this.top(), this.right(), this.bottom(), this.width(), this.height());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle o = (Rectangle)obj;
            return this.x1 == o.x1 && this.y1 == o.y1 && this.x2 == o.x2 && this.y2 == o.y2;
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.x1, this.y1, this.x2, this.y2);
    }
}

