/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.properties;

import de.mrjulsen.mcdragonlib.util.properties.IProperty;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractSerializableProperty<T, S>
implements IProperty<T> {
    private final S defaultValue;
    private Optional<IPropertyUpdateCallback<T>> onModify = Optional.empty();
    private Optional<IPropertyAfterUpdateCallback<T>> afterChanged = Optional.empty();
    private S value;

    public AbstractSerializableProperty(T defaultValue) {
        this.defaultValue = this.serialize(defaultValue);
        this.value = this.defaultValue;
    }

    @Override
    public <P extends IProperty<T>> P withModificationCallback(IPropertyUpdateCallback<T> callback) {
        this.onModify = Optional.ofNullable(callback);
        return (P)this;
    }

    @Override
    public <P extends IProperty<T>> P withAfterPropertyChangedCallback(IPropertyAfterUpdateCallback<T> callback) {
        this.afterChanged = Optional.ofNullable(callback);
        return (P)this;
    }

    protected abstract S serialize(T var1);

    protected abstract T deserialize(S var1);

    @Override
    public T get() {
        return this.deserialize(this.value);
    }

    @Override
    public T set(T t) {
        Object old = this.get();
        Object val = this.getModificationCallback().map(x -> x.update(old, t)).orElse(t);
        this.value = this.serialize(val);
        this.getAfterChangeCallback().ifPresent(x -> x.update(old, val));
        return t;
    }

    @Override
    public T getDefaultValue() {
        return this.deserialize(this.defaultValue);
    }

    @Override
    public T reset() {
        Object t = this.getDefaultValue();
        Object old = this.get();
        Object val = this.getModificationCallback().map(x -> x.update(old, t)).orElse(t);
        this.value = this.serialize(val);
        this.getAfterChangeCallback().ifPresent(x -> x.update(old, val));
        return t;
    }

    protected Optional<IPropertyUpdateCallback<T>> getModificationCallback() {
        return this.onModify;
    }

    protected Optional<IPropertyAfterUpdateCallback<T>> getAfterChangeCallback() {
        return this.afterChanged;
    }

    protected S getSerializedCurrentValue() {
        return this.getSerializedValue();
    }

    protected S getSerializedValue() {
        return this.value;
    }

    protected S getSerializedDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractSerializableProperty) {
            AbstractSerializableProperty o = (AbstractSerializableProperty)obj;
            return this.value != null && o.value != null && this.value.equals(o.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return String.format("%s[value=%s,defaultValue=%s]", this.getClass().getSimpleName(), this.value, this.defaultValue);
    }

    @FunctionalInterface
    public static interface IPropertyAfterUpdateCallback<T> {
        public void update(T var1, T var2);
    }

    @FunctionalInterface
    public static interface IPropertyUpdateCallback<T> {
        public T update(T var1, T var2);
    }
}

