/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.properties;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.mcdragonlib.util.properties.AbstractSerializableProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public class ListProperty<T>
extends Property<List<T>>
implements List<T> {
    private Optional<IListPropertyUpdateCallback<T>> onUpdate = Optional.empty();

    public ListProperty() {
        super(new ArrayList());
    }

    public ListProperty(List<T> defaultValue) {
        super(new ArrayList<T>(defaultValue));
    }

    public <P extends ListProperty<T>> P withUpdateCallback(IListPropertyUpdateCallback<T> callback) {
        this.onUpdate = Optional.ofNullable(callback);
        return (P)this;
    }

    protected Optional<IListPropertyUpdateCallback<T>> getOnUpdateCallback() {
        return this.onUpdate;
    }

    @Override
    public List<T> get() {
        return Collections.unmodifiableList((List)super.get());
    }

    @Override
    public List<T> getDefaultValue() {
        return Collections.unmodifiableList((List)super.getDefaultValue());
    }

    @Override
    public List<T> set(List<T> t) {
        this.clear();
        this.addAll((Collection<? extends T>)t);
        return this.get();
    }

    protected List<T> modifyInput(List<T> input) {
        return this.getModificationCallback().map(x -> x.update(this.get(), input)).orElse(input);
    }

    protected void runAfterChange(ListOperation operation) {
        Object old = this.get();
        this.getOnUpdateCallback().ifPresent(arg_0 -> ListProperty.lambda$runAfterChange$1((List)old, operation, arg_0));
        this.getAfterChangeCallback().ifPresent(arg_0 -> this.lambda$runAfterChange$2((List)old, arg_0));
    }

    protected List<T> getList() {
        return (List)super.get();
    }

    @Override
    public boolean add(T o) {
        return this.addAll((Collection<? extends T>)List.of(o));
    }

    @Override
    public void add(int index, T o) {
        this.addAll(index, (Collection<? extends T>)List.of(o));
    }

    public boolean addAll(T ... c) {
        boolean b = this.getList().addAll(this.modifyInput((List<T>)ImmutableList.copyOf((Object[])c)));
        this.runAfterChange(ListOperation.ADD);
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean b = this.getList().addAll(this.modifyInput((List<T>)ImmutableList.copyOf(c)));
        this.runAfterChange(ListOperation.ADD);
        return b;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean b = this.getList().addAll(index, this.modifyInput((List<T>)ImmutableList.copyOf(c)));
        this.runAfterChange(ListOperation.ADD);
        return b;
    }

    public void setAll(Collection<? extends T> c) {
        List<T> newValues = this.modifyInput((List<T>)ImmutableList.copyOf(c));
        this.getList().clear();
        this.getList().addAll(newValues);
        this.runAfterChange(ListOperation.REPLACE);
    }

    @Override
    public void clear() {
        this.getList().clear();
        Object currentState = this.get();
        List modifiedState = this.modifyInput(List.of());
        if (currentState != modifiedState) {
            this.getList().clear();
            this.getList().addAll(modifiedState);
        }
        this.runAfterChange(ListOperation.CLEAR);
    }

    @Override
    public boolean contains(Object o) {
        return this.getList().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getList().containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.getList().remove(o);
    }

    @Override
    public T remove(int index) {
        List<T> modifiedState;
        T o = this.getList().remove(index);
        Object currentState = this.get();
        if (currentState != (modifiedState = this.modifyInput((List<T>)currentState))) {
            this.getList().clear();
            this.getList().addAll(modifiedState);
        }
        this.runAfterChange(ListOperation.REMOVE);
        return o;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        List<T> modifiedState;
        boolean b = this.getList().removeAll(c);
        Object currentState = this.get();
        if (currentState != (modifiedState = this.modifyInput((List<T>)currentState))) {
            this.getList().clear();
            this.getList().addAll(modifiedState);
        }
        this.runAfterChange(ListOperation.REMOVE);
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<T> modifiedState;
        boolean b = this.getList().retainAll(c);
        Object currentState = this.get();
        if (currentState != (modifiedState = this.modifyInput((List<T>)currentState))) {
            this.getList().clear();
            this.getList().addAll(modifiedState);
        }
        this.runAfterChange(ListOperation.RETAIN);
        return b;
    }

    @Override
    public T set(int index, T o) {
        List<T> modifiedState;
        T t = this.getList().set(index, o);
        Object currentState = this.get();
        if (currentState != (modifiedState = this.modifyInput((List<T>)currentState))) {
            this.getList().clear();
            this.getList().addAll(modifiedState);
        }
        return t;
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.getList().toArray(arr);
    }

    private /* synthetic */ void lambda$runAfterChange$2(List old, AbstractSerializableProperty.IPropertyAfterUpdateCallback x) {
        x.update(old, this.get());
    }

    private static /* synthetic */ void lambda$runAfterChange$1(List old, ListOperation operation, IListPropertyUpdateCallback x) {
        x.update(old, operation);
    }

    public static enum ListOperation {
        ADD,
        REMOVE,
        RETAIN,
        CLEAR,
        REPLACE;

    }

    @FunctionalInterface
    public static interface IListPropertyUpdateCallback<T> {
        public void update(List<T> var1, ListOperation var2);
    }
}

