/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.registry;

import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public record DLRegistryObject<T extends INBTSerializable>(ResourceLocation id, Supplier<T> factory) {
    public static final String NBT_ID = "Id";
    public static final String NBT_DATA = "Content";

    public CompoundTag wrap(T data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(NBT_ID, this.id.toString());
        CompoundTag metaData = data.serializeNbt();
        if (metaData != null && !metaData.m_128456_()) {
            tag.m_128365_(NBT_DATA, (Tag)metaData);
        }
        return tag;
    }

    public T unwrap(CompoundTag tag) {
        T instance = this.create();
        instance.deserializeNbt(tag.m_128441_(NBT_DATA) ? tag.m_128469_(NBT_DATA) : new CompoundTag());
        return instance;
    }

    public static <T extends INBTSerializable> T load(CompoundTag tag, Function<ResourceLocation, DLRegistryObject<T>> registryGetter) {
        ResourceLocation typeId = new ResourceLocation(tag.m_128461_(NBT_ID));
        DLRegistryObject<T> type = registryGetter.apply(typeId);
        if (type == null) {
            return null;
        }
        return type.unwrap(tag);
    }

    public T create() {
        return (T)((INBTSerializable)this.factory.get());
    }
}

