/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.mrjulsen.mcdragonlib.util.registry.DLStaticRegistryObject;
import de.mrjulsen.mcdragonlib.util.registry.IStaticRegisterable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class DLStaticRegistry<T extends IStaticRegisterable<T>> {
    private final LinkedHashMap<ResourceLocation, DLStaticRegistryObject<? extends T>> TYPES = new LinkedHashMap();

    public <S extends T> DLStaticRegistryObject<S> register(ResourceLocation id, Supplier<S> factory) {
        DLStaticRegistryObject type = new DLStaticRegistryObject(id, Suppliers.memoize(factory));
        this.TYPES.put(id, type);
        return type;
    }

    private DLStaticRegistryObject<T> get(ResourceLocation id) {
        return this.TYPES.get(id);
    }

    public T load(CompoundTag tag) {
        return (T)((IStaticRegisterable)DLStaticRegistryObject.load(tag, this::get));
    }

    public List<T> getAll() {
        ArrayList<IStaticRegisterable> result = new ArrayList<IStaticRegisterable>(this.TYPES.size());
        for (DLStaticRegistryObject<T> v : this.TYPES.values()) {
            result.add((IStaticRegisterable)v.get());
        }
        return result;
    }
}

