/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.level.Level;

public final class DLTime
implements Comparable<DLTime> {
    private final double ticks;
    private final ITimeSystem provider;

    private DLTime(double ticks, ITimeSystem provider) {
        this.ticks = ticks;
        this.provider = Objects.requireNonNull(provider, "provider");
    }

    public static DLTime fromTicks(double ticks, ITimeSystem provider) {
        return new DLTime(ticks, provider);
    }

    public static DLTime fromIngame(long days, int hours, int minutes, int ticks, ITimeSystem provider) {
        long totalTicks = days * provider.getTicksPerDay() + (long)hours * provider.getTicksPerDay() / 24L + (long)minutes * provider.getTicksPerDay() / 1440L + (long)ticks;
        return new DLTime(totalTicks, provider);
    }

    public static DLTime fromReal(long days, int hours, int minutes, int seconds, int millis, ITimeSystem provider) {
        long totalMillis = (long)millis + TimeUnit.SECONDS.toMillis(seconds) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.DAYS.toMillis(days);
        double ticks = provider.getTicksFromRealMillis(totalMillis);
        return new DLTime(ticks, provider);
    }

    public static DLTime fromLevelTime(Level level, ITimeSystem provider) {
        return new DLTime(level.m_46468_(), provider);
    }

    public static DLTime now(ITimeSystem provider) {
        long millis = System.currentTimeMillis();
        double ticks = provider.getTicksFromRealMillis(millis);
        return new DLTime(ticks, provider);
    }

    public double getTicks() {
        return this.ticks;
    }

    public double toRealMillis() {
        return this.provider.getRealMillisFromTicks(this.ticks);
    }

    public double toRealSeconds() {
        return this.toRealMillis() / 1000.0;
    }

    public double toRealMinutes() {
        return this.toRealSeconds() / 60.0;
    }

    public double toRealHours() {
        return this.toRealMinutes() / 60.0;
    }

    public double toRealDays() {
        return this.toRealHours() / 24.0;
    }

    public double toGameDays() {
        return this.ticks / (double)this.provider.getTicksPerDay();
    }

    public double toGameHours() {
        return this.toGameDays() * 24.0;
    }

    public double toGameMinutes() {
        return this.toGameHours() * 60.0;
    }

    public double toGameSeconds() {
        return this.toGameMinutes() * 60.0;
    }

    public TimeSnapshot decomposeGameTime() {
        return new TimeSnapshot(this.getGameDaysComponent(), this.getGameHoursComponent(), this.getGameMinutesComponent(), this.getGameSecondsComponent(), this.getGameMillisComponent());
    }

    public TimeSnapshot decomposeRealTime() {
        return new TimeSnapshot(this.getRealDaysComponent(), this.getRealHoursComponent(), this.getRealMinutesComponent(), this.getRealSecondsComponent(), this.getRealMillisComponent());
    }

    public static DLTime fromSnapshotIngame(TimeSnapshot snapshot, ITimeSystem provider) {
        long totalTicks = snapshot.days() * provider.getTicksPerDay();
        double ticksPerHour = (double)provider.getTicksPerDay() / 24.0;
        double ticksPerMinute = ticksPerHour / 60.0;
        double ticksPerSecond = ticksPerMinute / 60.0;
        double ticksPerMillis = ticksPerSecond / 1000.0;
        double calculatedTicks = (double)totalTicks + (double)snapshot.hours() * ticksPerHour + (double)snapshot.minutes() * ticksPerMinute + (double)snapshot.seconds() * ticksPerSecond + (double)snapshot.millis() * ticksPerMillis;
        return new DLTime(calculatedTicks, provider);
    }

    public static DLTime fromSnapshotReal(TimeSnapshot snapshot, ITimeSystem provider) {
        return DLTime.fromReal(snapshot.days(), snapshot.hours(), snapshot.minutes(), snapshot.seconds(), snapshot.millis(), provider);
    }

    public long getGameDaysComponent() {
        return (long)this.toGameDays();
    }

    public int getGameHoursComponent() {
        return (int)(this.toGameHours() % 24.0);
    }

    public int getGameMinutesComponent() {
        return (int)(this.toGameMinutes() % 60.0);
    }

    public int getGameSecondsComponent() {
        return (int)(this.toGameSeconds() % 60.0);
    }

    public int getGameMillisComponent() {
        return (int)(this.toGameSeconds() * 1000.0 % 1000.0);
    }

    public long getRealDaysComponent() {
        return (long)this.toRealDays();
    }

    public int getRealHoursComponent() {
        return (int)(this.toRealHours() % 24.0);
    }

    public int getRealMinutesComponent() {
        return (int)(this.toRealMinutes() % 60.0);
    }

    public int getRealSecondsComponent() {
        return (int)(this.toRealSeconds() % 60.0);
    }

    public int getRealMillisComponent() {
        return (int)(this.toRealMillis() % 1000.0);
    }

    public DLTime addTicks(double ticks) {
        return new DLTime(this.ticks + ticks, this.provider);
    }

    public DLTime addGameDays(long days) {
        return this.addTicks(days * this.provider.getTicksPerDay());
    }

    public DLTime addGameHours(long hours) {
        double ticksPerHour = (double)this.provider.getTicksPerDay() / 24.0;
        return this.addTicks((double)hours * ticksPerHour);
    }

    public DLTime addGameMinutes(long minutes) {
        double ticksPerMinute = (double)this.provider.getTicksPerDay() / 1440.0;
        return this.addTicks((double)minutes * ticksPerMinute);
    }

    public DLTime addGameSeconds(long seconds) {
        double ticksPerSecond = (double)this.provider.getTicksPerDay() / 86400.0;
        return this.addTicks((double)seconds * ticksPerSecond);
    }

    public DLTime addRealMilliseconds(long ms) {
        double ticksToAdd = this.provider.getTicksFromRealMillis((double)ms, this.ticks);
        return this.addTicks(ticksToAdd);
    }

    public DLTime addRealSeconds(long seconds) {
        return this.addRealMilliseconds(seconds * 1000L);
    }

    public DLTime addRealMinutes(long minutes) {
        return this.addRealSeconds(minutes * 60L);
    }

    public DLTime addRealHours(long hours) {
        return this.addRealMinutes(hours * 60L);
    }

    public DLTime addRealDays(long days) {
        return this.addRealHours(days * 24L);
    }

    public DLTime addTime(DLTime other) {
        return this.addTicks(other.ticks, other.provider);
    }

    public DLTime subTime(DLTime other) {
        return this.addTicks(-other.ticks, other.provider);
    }

    public DLTime addTicks(double ticksToAdd, ITimeSystem fromProvider) {
        double realMillis = fromProvider.getRealMillisFromTicks(ticksToAdd);
        return this.addRealMilliseconds(Math.round(realMillis));
    }

    public DLTime addGameDays(long days, ITimeSystem fromProvider) {
        double ticksToAdd = fromProvider.getTicksPerDay() * days;
        return this.addTicks(ticksToAdd, fromProvider);
    }

    public DLTime addGameHours(long hours, ITimeSystem fromProvider) {
        double ticksPerHour = (double)fromProvider.getTicksPerDay() / 24.0;
        double ticksToAdd = ticksPerHour * (double)hours;
        return this.addTicks(ticksToAdd, fromProvider);
    }

    public DLTime addGameMinutes(long minutes, ITimeSystem fromProvider) {
        double ticksPerMinute = (double)fromProvider.getTicksPerDay() / 1440.0;
        double ticksToAdd = ticksPerMinute * (double)minutes;
        return this.addTicks(ticksToAdd, fromProvider);
    }

    public DLTime addGameSeconds(long seconds, ITimeSystem fromProvider) {
        double ticksPerSecond = (double)fromProvider.getTicksPerDay() / 86400.0;
        double ticksToAdd = ticksPerSecond * (double)seconds;
        return this.addTicks(ticksToAdd, fromProvider);
    }

    public DLTime addRealMilliseconds(long ms, ITimeSystem fromProvider) {
        double sourceTicks = fromProvider.getTicksFromRealMillis(ms);
        double converted = DLTime.convertTicks(sourceTicks, fromProvider, this.provider);
        return this.addTicks(converted);
    }

    public DLTime addRealSeconds(long seconds, ITimeSystem fromProvider) {
        return this.addRealMilliseconds(seconds * 1000L, fromProvider);
    }

    public DLTime addRealMinutes(long minutes, ITimeSystem fromProvider) {
        return this.addRealSeconds(minutes * 60L, fromProvider);
    }

    public DLTime addRealHours(long hours, ITimeSystem fromProvider) {
        return this.addRealMinutes(hours * 60L, fromProvider);
    }

    public DLTime addRealDays(long days, ITimeSystem fromProvider) {
        return this.addRealHours(days * 24L, fromProvider);
    }

    private static double convertTicks(double sourceTicks, ITimeSystem from, ITimeSystem to) {
        double realMillis = from.getRealMillisFromTicks(sourceTicks);
        return to.getTicksFromRealMillis(realMillis);
    }

    @Override
    public int compareTo(DLTime o) {
        return Double.compare(this.toRealMillis(), o.toRealMillis());
    }

    public boolean isBefore(DLTime other) {
        return this.toRealMillis() < other.toRealMillis();
    }

    public boolean isAfter(DLTime other) {
        return this.toRealMillis() > other.toRealMillis();
    }

    public boolean isBetween(DLTime start, DLTime end) {
        double endMillis;
        double thisMillis = this.toRealMillis();
        double startMillis = start.toRealMillis();
        if (startMillis > (endMillis = end.toRealMillis())) {
            return thisMillis >= endMillis && thisMillis <= startMillis;
        }
        return thisMillis >= startMillis && thisMillis <= endMillis;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DLTime)) {
            return false;
        }
        DLTime other = (DLTime)obj;
        return this.ticks == other.ticks && this.provider.equals(other.provider);
    }

    public int hashCode() {
        return Objects.hash(this.ticks, this.provider);
    }

    public String toString() {
        return "DLTime[" + this.ticks + " ticks, provider=" + String.valueOf(this.provider) + "]";
    }

    public ITimeSystem getTimeSystem() {
        return this.provider;
    }

    public String format(ITimeFormatter formatter, TimeContext context) {
        return formatter.format(this, context);
    }

    public record TimeSnapshot(long days, int hours, int minutes, int seconds, int millis) {
    }
}

