/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.TimeZone;
import java.util.List;

public interface ITimeSystem {
    public long getTicksPerDay();

    public List<TimeZone> getTimeZones();

    default public double getDaytimeOffset() {
        return this.getTicksPerDay() / 4L;
    }

    default public double getRealMillisFromTicks(double totalTicks) {
        return this.getRealMillisFromTicks(totalTicks, 0.0);
    }

    default public double getRealMillisFromTicks(double totalTicks, double startTick) {
        if (totalTicks == 0.0) {
            return 0.0;
        }
        List zones = this.getTimeZones().stream().sorted().toList();
        double remainingTicks = totalTicks;
        double realMillis = 0.0;
        long ticksPerDay = this.getTicksPerDay();
        double currentTick = startTick % (double)ticksPerDay;
        while (remainingTicks > 0.0) {
            for (TimeZone zone : zones) {
                double zoneStart = zone.startTick();
                double zoneEnd = zone.endTick();
                double zoneMillisPerTick = zone.getRealMillisPerTick();
                double effectiveStart = Math.max(zoneStart, currentTick);
                if (!(effectiveStart < zoneEnd)) continue;
                double ticksInZone = zoneEnd - effectiveStart;
                if (remainingTicks >= ticksInZone) {
                    realMillis += ticksInZone * zoneMillisPerTick;
                    remainingTicks -= ticksInZone;
                    currentTick = zoneEnd;
                    continue;
                }
                realMillis += remainingTicks * zoneMillisPerTick;
                remainingTicks = 0.0;
                break;
            }
            currentTick = 0.0;
        }
        return realMillis;
    }

    default public double getTicksFromRealMillis(double totalMillis) {
        return this.getTicksFromRealMillis(totalMillis, 0.0);
    }

    default public double getTicksFromRealMillis(double totalMillis, double startTick) {
        if (totalMillis == 0.0) {
            return 0.0;
        }
        double remainingMillis = totalMillis;
        double addedTicks = 0.0;
        long ticksPerDay = this.getTicksPerDay();
        List<TimeZone> zones = this.getTimeZones().stream().sorted().toList();
        double millisPerFullDay = this.getRealMillisFromTicks(ticksPerDay);
        double currentDayTick = startTick % (double)ticksPerDay;
        double millisUntilEndOfDay = this.getRealMillisFromTicks((double)ticksPerDay - currentDayTick, currentDayTick);
        if (remainingMillis < millisUntilEndOfDay) {
            addedTicks = this.getTicksInPartialDay(remainingMillis, currentDayTick, zones);
            return addedTicks;
        }
        addedTicks += (double)ticksPerDay - currentDayTick;
        long fullDays = (long)((remainingMillis -= millisUntilEndOfDay) / millisPerFullDay);
        addedTicks += (double)(fullDays * ticksPerDay);
        if ((remainingMillis -= (double)fullDays * millisPerFullDay) > 0.0) {
            addedTicks += this.getTicksInPartialDay(remainingMillis, 0.0, zones);
        }
        return addedTicks;
    }

    default public double getTicksFromRealMillis(double totalMillis, DLTime startTime) {
        return this.getTicksFromRealMillis(totalMillis, startTime.getTicks());
    }

    default public double getRealMillisFromTicks(double totalTicks, DLTime startTime) {
        return this.getRealMillisFromTicks(totalTicks, startTime.getTicks());
    }

    private double getTicksInPartialDay(double millis, double startTick, List<TimeZone> zones) {
        double remainingMillis = millis;
        double addedTicks = 0.0;
        long ticksPerDay = this.getTicksPerDay();
        double currentTick = startTick % (double)ticksPerDay;
        for (TimeZone zone : zones) {
            double zoneStart = zone.startTick();
            double zoneEnd = zone.endTick();
            double zoneMillisPerTick = zone.getRealMillisPerTick();
            double effectiveStart = Math.max(zoneStart, currentTick);
            if (!(effectiveStart < zoneEnd)) continue;
            double ticksInZoneUntilEnd = zoneEnd - effectiveStart;
            double millisInZoneUntilEnd = ticksInZoneUntilEnd * zoneMillisPerTick;
            if (!(remainingMillis > 0.0)) continue;
            if (remainingMillis >= millisInZoneUntilEnd) {
                addedTicks += ticksInZoneUntilEnd;
                remainingMillis -= millisInZoneUntilEnd;
                currentTick = zoneEnd;
                continue;
            }
            addedTicks += remainingMillis / zoneMillisPerTick;
            remainingMillis = 0.0;
            break;
        }
        return addedTicks;
    }
}

