/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;

public class TimeFormat12Hours
implements ITimeFormatter {
    public static final TimeFormat12Hours INSTANCE = new TimeFormat12Hours();

    @Override
    public String format(DLTime time, TimeContext context) {
        ITimeSystem provider = time.getTimeSystem();
        long hour = 0L;
        long minute = 0L;
        if (context == TimeContext.REAL) {
            long ticksPerDay = provider.getTicksPerDay();
            double midnightTicks = (double)ticksPerDay - provider.getDaytimeOffset();
            double totalDayMillis = provider.getRealMillisFromTicks(ticksPerDay);
            double currentMillis = time.toRealMillis();
            double midnightMillis = provider.getRealMillisFromTicks(midnightTicks);
            double millisSinceMidnight = (currentMillis - midnightMillis + totalDayMillis) % totalDayMillis;
            double totalSeconds = millisSinceMidnight / 1000.0;
            double totalMinutes = totalSeconds / 60.0;
            hour = (long)(totalMinutes / 60.0 % 24.0);
            minute = (long)(totalMinutes % 60.0);
        } else {
            double t = time.getTicks() + provider.getDaytimeOffset();
            double dayTicks = t % (double)provider.getTicksPerDay();
            long ticksPerDay = provider.getTicksPerDay();
            hour = Math.floorDiv((long)(dayTicks * 24.0), ticksPerDay);
            minute = Math.floorDiv((long)(dayTicks * 24.0 * 60.0 % (double)(ticksPerDay * 60L)), ticksPerDay);
        }
        String ampm = hour < 12L ? "AM" : "PM";
        hour = hour % 12L == 0L ? 12L : hour % 12L;
        return String.format("%d:%02d %s", hour, minute, ampm);
    }
}

