/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;

public class TimeFormatDigitalDuration
implements ITimeFormatter {
    private DLTime startTime;
    private boolean showMillis;
    private boolean showSeconds = true;
    private boolean showMinutes = true;
    private boolean showHours;
    private boolean showDays;

    public TimeFormatDigitalDuration() {
    }

    public TimeFormatDigitalDuration(DLTime startTicks) {
        this.startTime = startTicks;
    }

    public TimeFormatDigitalDuration(DLTime startTicks, boolean showMillis, boolean showSeconds, boolean showMinutes, boolean showHours, boolean showDays) {
        this.startTime = startTicks;
        this.showMillis = showMillis;
        this.showSeconds = showSeconds;
        this.showMinutes = showMinutes;
        this.showHours = showHours;
        this.showDays = showDays;
    }

    @Override
    public String format(DLTime time, TimeContext context) {
        boolean negative = false;
        ITimeSystem provider = time.getTimeSystem();
        double totalMillis = 0.0;
        if (context == TimeContext.REAL) {
            double totalMillisOrTicks;
            if (this.startTime != null) {
                deltaTicks = time.getTicks() - this.startTime.getTicks();
                totalMillisOrTicks = provider.getRealMillisFromTicks(deltaTicks, this.startTime.getTicks());
            } else {
                totalMillisOrTicks = time.toRealMillis();
            }
            if (Double.isNaN(totalMillisOrTicks) || Double.isInfinite(totalMillisOrTicks)) {
                return "NaN";
            }
            if (totalMillisOrTicks < 0.0) {
                negative = true;
            }
            totalMillis = Math.abs(totalMillisOrTicks);
        } else {
            deltaTicks = this.startTime != null ? time.getTicks() - this.startTime.getTicks() : time.getTicks();
            if (Double.isNaN(deltaTicks) || Double.isInfinite(deltaTicks)) {
                return "NaN";
            }
            if (deltaTicks < 0.0) {
                negative = true;
            }
            totalMillis = Math.abs(deltaTicks / ((double)provider.getTicksPerDay() / 8.64E7));
        }
        long millis = (long)(totalMillis % 1000.0);
        long totalSeconds = (long)(totalMillis / 1000.0);
        long seconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long minutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        long hours = totalHours % 24L;
        long days = totalHours / 24L;
        boolean showAnyMillis = this.showMillis;
        boolean showAnySeconds = this.showSeconds || showAnyMillis;
        boolean showAnyMinutes = this.showMinutes || showAnySeconds;
        boolean showAnyHours = this.showHours || showAnyMinutes;
        boolean showAnyDays = this.showDays || showAnyHours;
        boolean firstShownMillis = this.showMillis;
        boolean firstShownSeconds = !firstShownMillis && this.showSeconds;
        boolean firstShownMinutes = !firstShownMillis && !firstShownSeconds && this.showMinutes;
        StringBuilder sb = new StringBuilder();
        if (this.showDays && showAnyDays || !this.showDays && days > 0L) {
            sb.append(days).append("d ");
        }
        if (this.showHours && showAnyHours || !this.showHours && hours > 0L) {
            if (sb.length() > 0) {
                sb.append(String.format("%02d", hours));
            } else {
                sb.append(hours);
            }
        }
        if (showAnyMinutes && (firstShownMinutes || sb.length() > 0 || minutes > 0L || this.showMinutes)) {
            sb.append(sb.length() > 0 ? ":" : "").append(String.format("%02d", minutes));
        }
        if (showAnySeconds && (firstShownSeconds || sb.length() > 0 || seconds > 0L || this.showSeconds)) {
            sb.append(sb.length() > 0 ? ":" : "").append(String.format("%02d", seconds));
        }
        if (this.showMillis && (firstShownMillis || millis > 0L)) {
            sb.append(",").append(String.format("%03d", millis));
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        String result = sb.toString();
        return negative ? "-" + result : result;
    }
}

