/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;

public class TimeFormatRFC3339
implements ITimeFormatter {
    public static final TimeFormatRFC3339 INSTANCE = new TimeFormatRFC3339();

    @Override
    public String format(DLTime time, TimeContext context) {
        long millis;
        long second;
        long minute;
        long hour;
        long day;
        ITimeSystem provider = time.getTimeSystem();
        if (context == TimeContext.REAL) {
            double totalMillis = time.toRealMillis();
            double millisPerDay = provider.getRealMillisFromTicks(provider.getTicksPerDay());
            day = (long)Math.floor(totalMillis / millisPerDay);
            double millisOfDay = totalMillis % millisPerDay;
            double totalSeconds = millisOfDay / 1000.0;
            hour = (long)(totalSeconds / 3600.0 % 24.0);
            minute = (long)(totalSeconds / 60.0 % 60.0);
            second = (long)(totalSeconds % 60.0);
            millis = (long)(millisOfDay % 1000.0);
        } else {
            long ticks = (long)time.getTicks();
            long ticksPerDay = provider.getTicksPerDay();
            day = Math.floorDiv(ticks, ticksPerDay);
            long dayTicks = ticks % ticksPerDay;
            hour = Math.floorDiv(dayTicks * 24L, ticksPerDay);
            minute = Math.floorDiv(dayTicks * 24L * 60L % (ticksPerDay * 60L), ticksPerDay);
            second = Math.floorDiv(dayTicks * 24L * 60L * 60L % (ticksPerDay * 60L * 60L), ticksPerDay);
            millis = Math.floorDiv(dayTicks * 24L * 60L * 60L * 1000L % (ticksPerDay * 60L * 60L * 1000L), ticksPerDay);
        }
        return String.format("%02dT%02d:%02d:%02d.%03dZ", day + 1L, hour, minute, second, millis);
    }
}

