/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.screen.widget;

import dev.kosmx.playerAnim.core.util.MathHelper;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.Text;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.main.screen.widget.IWidgetLogic;

public abstract class AbstractFastChooseWidget<MATRIX, WIDGET>
implements IWidgetLogic<MATRIX, WIDGET> {
    private IChooseWheel<MATRIX> wheel;
    public final int x;
    public final int y;
    public final int size;

    protected AbstractFastChooseWidget(int x, int y, int size) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.wheel = IChooseWheel.getWheel(this);
    }

    protected void bind(IChooseWheel<MATRIX> wheel) {
        this.wheel = wheel;
    }

    public void render(MATRIX matrices, int mouseX, int mouseY, float delta) {
        this.wheel.render(matrices, mouseX, mouseY, delta);
    }

    public void drawCenteredText(MATRIX matrixStack, Text stringRenderable, float deg) {
        this.drawCenteredText(matrixStack, stringRenderable, (float)((double)(this.x + this.size / 2) + (double)this.size * 0.4 * Math.sin((double)deg * 0.0174533)), (float)((double)(this.y + this.size / 2) + (double)this.size * 0.4 * Math.cos((double)deg * 0.0174533)));
    }

    public void drawCenteredText(MATRIX matrices, Text stringRenderable, float x, float y) {
        int c = (Boolean)((ClientConfig)EmoteInstance.config).dark.get() != false ? 255 : 0;
        this.textDraw(matrices, stringRenderable, x - (float)this.textRendererGetWidth(stringRenderable) / 2.0f, y - 2.0f, MathHelper.colorHelper((int)c, (int)c, (int)c, (int)1));
    }

    protected abstract boolean doHoverPart(IChooseWheel.IChooseElement var1);

    protected abstract boolean isValidClickButton(int var1);

    protected abstract boolean EmotesOnClick(IChooseWheel.IChooseElement var1, int var2);

    protected abstract boolean doesShowInvalid();

    @Override
    public boolean emotes_mouseClicked(double mouseX, double mouseY, int button) {
        return this.wheel.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean emotes_mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.wheel.mouseScrolled(mouseX, mouseY, amount);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.wheel.isMouseOver(mouseX, mouseY);
    }
}

