/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.entris.game;

import com.matthewperiut.entris.game.DrawContextUtility;
import com.matthewperiut.entris.game.SoundHelper;
import com.matthewperiut.entris.game.Tetromino;
import com.matthewperiut.entris.network.ClientNetworkHelper;
import com.matthewperiut.entris.network.payload.FinishEntrisPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;

public class TetrisGame {
    public static ResourceLocation[] TILE_ID = new ResourceLocation[]{ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_blue.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_green.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_light_blue.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_orange.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_purple.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_red.png"), ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/enchanting_table/tile_yellow.png")};
    public Tile[][] screen = new Tile[10][24];
    private Tetromino currentTetromino;
    public Tetromino holdTetromino;
    public Tetromino holdTetrominoDisplay;
    private boolean holdUsed;
    private int currentX;
    private int currentY;
    public boolean gameOver;
    private boolean isDropping;
    private int dropTimer;
    private Queue<Tetromino.Shape> bag = new LinkedList<Tetromino.Shape>();
    public int score = 0;
    private int timeLeft;
    public boolean isStarted;
    private int countdown;
    private Random random = new Random();
    int buttonCooldown = 0;
    boolean flipper = false;
    boolean leftRelease = true;
    boolean rightRelease = true;
    boolean sentServerScore = false;

    public TetrisGame() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 24; ++j) {
                this.screen[i][j] = Tile.NONE;
            }
        }
        this.fillBag();
        this.score = 0;
        this.timeLeft = 0;
        this.isStarted = false;
        this.countdown = 0;
        this.spawnNewTetromino();
    }

    private int calculateDropPosition(Tetromino tetromino, int startX, int startY) {
        int landingY = startY;
        while (this.isValidPosition(tetromino, startX, landingY - 1)) {
            --landingY;
        }
        return landingY;
    }

    public void render(GuiGraphics context, int x, int y) {
        if (!this.isStarted) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 20; ++j) {
                int id = this.screen[i][j].ordinal();
                if (id <= 0) continue;
                context.m_280163_(TILE_ID[id - 1], x + i * 8, y - j * 8, 0.0f, 0.0f, 8, 8, 8, 8);
            }
        }
        if (this.gameOver) {
            return;
        }
        this.renderTetromino(context, this.currentTetromino, this.currentX, this.currentY, x, y);
        int landingY = this.calculateDropPosition(this.currentTetromino, this.currentX, this.currentY);
        this.renderTransparentTetromino(context, this.currentTetromino, this.currentX, landingY, x, y);
    }

    public void continuousInput(long handle) {
        if (this.gameOver || !this.isStarted) {
            return;
        }
        boolean bl = this.flipper = !this.flipper;
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        } else if (this.flipper) {
            if (GLFW.glfwGetKey((long)handle, (int)263) == 1) {
                this.leftRelease = false;
                if (this.moveTetromino(-1, 0)) {
                    SoundHelper.moveSound();
                }
            }
            if (GLFW.glfwGetKey((long)handle, (int)262) == 1) {
                this.rightRelease = false;
                if (this.moveTetromino(1, 0)) {
                    SoundHelper.moveSound();
                }
            }
        }
        if (GLFW.glfwGetKey((long)handle, (int)263) == 0) {
            this.leftRelease = true;
        }
        if (GLFW.glfwGetKey((long)handle, (int)262) == 0) {
            this.rightRelease = true;
        }
        this.isDropping = GLFW.glfwGetKey((long)handle, (int)264) == 1;
    }

    public boolean input(int keyCode, int scanCode, int modifiers) {
        if (this.gameOver || !this.isStarted) {
            return false;
        }
        switch (keyCode) {
            case 263: {
                if (!this.leftRelease) break;
                if (this.moveTetromino(-1, 0)) {
                    SoundHelper.moveSound();
                }
                this.buttonCooldown = 2;
                break;
            }
            case 262: {
                if (!this.rightRelease) break;
                if (this.moveTetromino(1, 0)) {
                    SoundHelper.moveSound();
                }
                this.buttonCooldown = 2;
                break;
            }
            case 264: {
                break;
            }
            case 32: {
                this.hardDrop();
                break;
            }
            case 90: {
                this.rotateTetromino(1);
                break;
            }
            case 88: 
            case 265: {
                this.rotateTetromino(-1);
                break;
            }
            case 67: {
                this.holdTetromino();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void tick() {
        if (!this.isStarted) {
            return;
        }
        if (this.countdown > 0) {
            --this.countdown;
            return;
        }
        if (this.gameOver && !this.sentServerScore) {
            ClientNetworkHelper.send(new FinishEntrisPayload(this.score));
            this.sentServerScore = true;
        }
        if (this.gameOver || this.timeLeft <= 0) {
            this.gameOver = true;
            return;
        }
        --this.timeLeft;
        ++this.dropTimer;
        if (this.dropTimer >= (this.isDropping ? 1 : 20)) {
            if (!this.moveTetromino(0, -1)) {
                this.placeTetromino(false);
                this.clearLines();
                this.spawnNewTetromino();
                this.holdUsed = false;
            } else {
                SoundHelper.tickSound();
            }
            this.dropTimer = 0;
        }
    }

    private void fillBag() {
        ArrayList<Tetromino.Shape> shapes = new ArrayList<Tetromino.Shape>();
        for (Tetromino.Shape shape : Tetromino.Shape.values()) {
            shapes.add(shape);
        }
        Collections.shuffle(shapes, this.random);
        this.bag.addAll(shapes);
    }

    private void spawnNewTetromino() {
        if (this.bag.isEmpty()) {
            this.fillBag();
        }
        this.currentTetromino = new Tetromino(this.bag.poll());
        this.currentX = 4;
        this.currentY = 18;
        if (!this.isValidPosition(this.currentTetromino, this.currentX, this.currentY)) {
            this.gameOver = true;
        }
    }

    private boolean moveTetromino(int dx, int dy) {
        if (this.isValidPosition(this.currentTetromino, this.currentX + dx, this.currentY + dy)) {
            this.currentX += dx;
            this.currentY += dy;
            return true;
        }
        return false;
    }

    public void rotateTetromino(int direction) {
        int[][] kickOffsets;
        Tetromino rotatedTetromino = this.currentTetromino.rotate(direction);
        for (int[] offset : kickOffsets = Tetromino.getKickOffsets(this.currentTetromino.getShape(), this.currentTetromino.getRotationState(), direction)) {
            int newX = this.currentX + offset[0];
            int newY = this.currentY + offset[1];
            if (!rotatedTetromino.isValidPosition(this.screen, newX, newY)) continue;
            this.currentTetromino = rotatedTetromino;
            this.currentX = newX;
            this.currentY = newY;
            SoundHelper.rotateSound();
            return;
        }
    }

    private void hardDrop() {
        while (this.moveTetromino(0, -1)) {
        }
        this.placeTetromino(true);
        SoundHelper.hardDropSound();
        this.clearLines();
        this.spawnNewTetromino();
        this.holdUsed = false;
    }

    private void holdTetromino() {
        if (this.holdUsed) {
            return;
        }
        if (this.holdTetromino == null) {
            this.holdTetromino = this.currentTetromino;
            this.spawnNewTetromino();
        } else {
            Tetromino temp = this.currentTetromino;
            this.currentTetromino = this.holdTetromino;
            this.holdTetromino = temp;
            this.currentX = 4;
            this.currentY = 18;
        }
        this.holdTetrominoDisplay = new Tetromino(this.holdTetromino.getShape());
        SoundHelper.swapSound();
        this.holdUsed = true;
    }

    private void placeTetromino(boolean soundHandled) {
        for (int y = 0; y < this.currentTetromino.getTiles().length; ++y) {
            for (int x = 0; x < this.currentTetromino.getTiles()[y].length; ++x) {
                if (this.currentTetromino.getTileAt(x, y) == Tile.NONE) continue;
                int worldX = this.currentX + x;
                int worldY = this.currentY + y;
                if (worldY >= 24 || worldY < 0 || worldX >= 10 || worldX < 0) continue;
                this.screen[worldX][worldY] = this.currentTetromino.getTileAt(x, y);
            }
        }
        if (!soundHandled) {
            SoundHelper.finalizeSound();
        }
    }

    private void clearLines() {
        int linesCleared = 0;
        for (int j = 0; j < 24; ++j) {
            boolean fullLine = true;
            for (int i = 0; i < 10; ++i) {
                if (this.screen[i][j] != Tile.NONE) continue;
                fullLine = false;
                break;
            }
            if (!fullLine) continue;
            ++linesCleared;
            for (int y = j; y < 23; ++y) {
                for (int x = 0; x < 10; ++x) {
                    this.screen[x][y] = this.screen[x][y + 1];
                }
            }
            for (int x = 0; x < 10; ++x) {
                this.screen[x][23] = Tile.NONE;
            }
            --j;
        }
        this.updateScore(linesCleared);
    }

    private void updateScore(int linesCleared) {
        switch (linesCleared) {
            case 1: {
                this.score += 100;
                break;
            }
            case 2: {
                this.score += 300;
                break;
            }
            case 3: {
                this.score += 500;
                break;
            }
            case 4: {
                this.score += 800;
            }
        }
    }

    private boolean isValidPosition(Tetromino tetromino, int x, int y) {
        return tetromino.isValidPosition(this.screen, x, y);
    }

    public void renderTetromino(GuiGraphics context, Tetromino tetromino, int x, int y, int offsetX, int offsetY) {
        for (int j = 0; j < tetromino.getTiles().length; ++j) {
            for (int i = 0; i < tetromino.getTiles()[j].length; ++i) {
                if (tetromino.getTileAt(i, j) == Tile.NONE) continue;
                int tileX = x + i;
                int tileY = y + j;
                if (tileY < 0 || tileY >= 20 || tileX < 0 || tileX >= 10) continue;
                int id = tetromino.getTileAt(i, j).ordinal();
                context.m_280163_(TILE_ID[id - 1], offsetX + tileX * 8, offsetY - tileY * 8, 0.0f, 0.0f, 8, 8, 8, 8);
            }
        }
    }

    private void renderTransparentTetromino(GuiGraphics context, Tetromino tetromino, int x, int y, int offsetX, int offsetY) {
        for (int j = 0; j < tetromino.getTiles().length; ++j) {
            for (int i = 0; i < tetromino.getTiles()[j].length; ++i) {
                if (tetromino.getTileAt(i, j) == Tile.NONE) continue;
                int tileX = x + i;
                int tileY = y + j;
                if (tileY < 0 || tileY >= 20 || tileX < 0 || tileX >= 10) continue;
                int id = tetromino.getTileAt(i, j).ordinal();
                DrawContextUtility.drawTransparentTexture(context, TILE_ID[id - 1], offsetX + tileX * 8, offsetY - tileY * 8, 8, 8, 0.3f);
            }
        }
    }

    public void startGame(int seconds) {
        this.isStarted = true;
        this.timeLeft = seconds * 20;
        this.countdown = 0;
        this.score = 0;
        this.gameOver = false;
        this.spawnNewTetromino();
    }

    public int getScore() {
        return this.score;
    }

    public int getMinutes() {
        return (int)Math.floor((float)this.timeLeft / 1200.0f);
    }

    public int getSeconds() {
        return this.timeLeft / 20 - this.getMinutes() * 60;
    }

    public static enum Tile {
        NONE,
        BLUE,
        GREEN,
        LIGHT_BLUE,
        ORANGE,
        PURPLE,
        RED,
        YELLOW;

    }
}

