/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.entris.game;

import com.matthewperiut.entris.game.TetrisGame;

public class Tetromino {
    private static final TetrisGame.Tile[][][] SHAPES = new TetrisGame.Tile[][][]{{{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.LIGHT_BLUE, TetrisGame.Tile.LIGHT_BLUE, TetrisGame.Tile.LIGHT_BLUE, TetrisGame.Tile.LIGHT_BLUE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.YELLOW, TetrisGame.Tile.YELLOW, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.YELLOW, TetrisGame.Tile.YELLOW, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.PURPLE, TetrisGame.Tile.PURPLE, TetrisGame.Tile.PURPLE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.PURPLE, TetrisGame.Tile.NONE}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.GREEN, TetrisGame.Tile.GREEN, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.GREEN, TetrisGame.Tile.GREEN}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.RED, TetrisGame.Tile.RED}, {TetrisGame.Tile.RED, TetrisGame.Tile.RED, TetrisGame.Tile.NONE}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.BLUE, TetrisGame.Tile.BLUE, TetrisGame.Tile.BLUE}, {TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.BLUE}}, {{TetrisGame.Tile.NONE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}, {TetrisGame.Tile.ORANGE, TetrisGame.Tile.ORANGE, TetrisGame.Tile.ORANGE}, {TetrisGame.Tile.ORANGE, TetrisGame.Tile.NONE, TetrisGame.Tile.NONE}}};
    private static final int[][][] KICK_OFFSETS = new int[][][]{new int[][]{{0, 0}, {-2, 0}, {1, 0}, {-2, -1}, {1, 2}, {0, 0}, {-1, 0}, {2, 0}, {-1, 2}, {2, -1}, {0, 0}, {2, 0}, {-1, 0}, {2, 1}, {-1, -2}, {0, 0}, {1, 0}, {-2, 0}, {1, -2}, {-2, 1}}, new int[][]{{0, 0}, {-1, 0}, {-1, 1}, {0, -2}, {-1, -2}, {0, 0}, {1, 0}, {1, -1}, {0, 2}, {1, 2}, {0, 0}, {1, 0}, {1, 1}, {0, -2}, {1, -2}, {0, 0}, {-1, 0}, {-1, -1}, {0, 2}, {-1, 2}}};
    private TetrisGame.Tile[][] tiles;
    private Shape shape;
    private int rotationState;

    public Tetromino(Shape shape) {
        this.shape = shape;
        this.tiles = SHAPES[shape.ordinal()];
        this.rotationState = 0;
    }

    public TetrisGame.Tile getTile() {
        return this.tiles[1][1];
    }

    public TetrisGame.Tile[][] getTiles() {
        return this.tiles;
    }

    public void setTiles(TetrisGame.Tile[][] tiles) {
        this.tiles = tiles;
    }

    public Tetromino rotate(int direction) {
        int size = this.tiles.length;
        TetrisGame.Tile[][] rotatedTiles = new TetrisGame.Tile[size][size];
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                rotatedTiles[y][x] = direction > 0 ? this.tiles[size - 1 - x][y] : this.tiles[x][size - 1 - y];
            }
        }
        return new Tetromino(this.shape, rotatedTiles, (this.rotationState + direction + 4) % 4);
    }

    private Tetromino(Shape shape, TetrisGame.Tile[][] tiles, int rotationState) {
        this.shape = shape;
        this.tiles = tiles;
        this.rotationState = rotationState;
    }

    public TetrisGame.Tile getTileAt(int x, int y) {
        if (x < 0 || x >= this.tiles.length || y < 0 || y >= this.tiles[0].length) {
            return TetrisGame.Tile.NONE;
        }
        return this.tiles[y][x];
    }

    public int getRotationState() {
        return this.rotationState;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isValidPosition(TetrisGame.Tile[][] screen, int x, int y) {
        for (int j = 0; j < this.tiles.length; ++j) {
            for (int i = 0; i < this.tiles[j].length; ++i) {
                if (this.tiles[j][i] == TetrisGame.Tile.NONE) continue;
                int newX = x + i;
                int newY = y + j;
                if (newX >= 0 && newX < screen.length && newY >= 0 && newY < screen[0].length && screen[newX][newY] == TetrisGame.Tile.NONE) continue;
                return false;
            }
        }
        return true;
    }

    public static int[][] getKickOffsets(Shape shape, int rotationState, int direction) {
        if (shape == Shape.I) {
            return KICK_OFFSETS[0];
        }
        if (shape != Shape.O) {
            return KICK_OFFSETS[1];
        }
        return new int[][]{{0, 0}};
    }

    public static enum Shape {
        I,
        O,
        T,
        S,
        Z,
        J,
        L;

    }
}

