/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.entris.mixin;

import com.matthewperiut.entris.BookShelvesUtil;
import com.matthewperiut.entris.Entris;
import com.matthewperiut.entris.client.ClientEntrisInterface;
import com.matthewperiut.entris.client.EnchantmentSelectButton;
import com.matthewperiut.entris.client.LevelInput;
import com.matthewperiut.entris.client.ShowInventoryButton;
import com.matthewperiut.entris.client.SlotEnabler;
import com.matthewperiut.entris.client.StartGameButton;
import com.matthewperiut.entris.client.SubmitEnchantmentsButton;
import com.matthewperiut.entris.enchantment.EnchantmentHelp;
import com.matthewperiut.entris.game.TetrisGame;
import com.matthewperiut.entris.network.ClientNetworkHelper;
import com.matthewperiut.entris.network.payload.RequestEntrisEnchantsPayload;
import com.matthewperiut.entris.network.payload.RequestStartEntrisPayload;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentScreen.class})
public abstract class EnchantmentScreenMixin
extends AbstractContainerScreen<EnchantmentMenu>
implements ClientEntrisInterface {
    private static final Component GO_BACK = Component.m_237113_((String)"Take Me Back!");
    PlainTextButton RegularEnchantingButton;
    ShowInventoryButton showInventoryButton;
    StartGameButton startGameButton;
    SubmitEnchantmentsButton submitEnchantmentButton;
    @Unique
    ArrayList<EnchantmentSelectButton> enchantmentSelectButtons = new ArrayList();
    boolean showInventory = false;
    int bookshelveMaxLevel = 4;
    private static final ResourceLocation ENTRIS = ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/entris.png");
    private static final ResourceLocation INVENTORY = ResourceLocation.m_214293_((String)"entris", (String)"textures/gui/container/inventory.png");
    @Unique
    protected int entrisBackgroundWidth = 176;
    @Unique
    protected int entrisBackgroundHeight = 166;
    @Unique
    TetrisGame tetrisGame = new TetrisGame();
    @Unique
    private boolean enableEntris = false;
    @Unique
    private boolean slotsDown = false;
    int blinkCounter = 0;
    @Unique
    LevelInput numberHolder = new LevelInput();
    private static long handle = -1L;

    @Shadow
    protected abstract void m_7286_(GuiGraphics var1, float var2, int var3, int var4);

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.setEntris(true);
        this.updateSlotDownStatus();
        this.bookshelveMaxLevel = (int)(4.0 + 1.74 * (double)BookShelvesUtil.countBookShelves((Player)Minecraft.m_91087_().f_91074_));
        int x = (this.f_96543_ - this.entrisBackgroundWidth) / 2;
        int y = (this.f_96544_ - this.entrisBackgroundHeight) / 2;
        int i = this.f_96547_.m_92852_((FormattedText)GO_BACK);
        int j = this.f_96543_ - i - 2;
        this.RegularEnchantingButton = (PlainTextButton)this.m_142416_((GuiEventListener)new PlainTextButton(x + 1, y - 10, i, 10, GO_BACK, button -> {
            this.setEntris(false);
            this.RegularEnchantingButton.f_93623_ = false;
            this.RegularEnchantingButton.f_93624_ = false;
            this.showInventoryButton.f_93624_ = false;
            this.showInventoryButton.f_93623_ = false;
            this.startGameButton.f_93624_ = false;
            this.startGameButton.f_93623_ = false;
            this.updateSlotDownStatus();
            Entris.disableRegularEnchanting = false;
            this.clearEnchantmentList();
        }, this.f_96547_));
        this.showInventoryButton = (ShowInventoryButton)this.m_142416_((GuiEventListener)new ShowInventoryButton(x + 54, y + 46, button -> {
            this.showInventoryButton.openChest = this.showInventory = !this.showInventory;
            this.startGameButton.f_93624_ = !this.showInventory;
            this.startGameButton.f_93623_ = !this.showInventory;
            this.updateSlotDownStatus();
        }));
        this.startGameButton = (StartGameButton)this.m_142416_((GuiEventListener)new StartGameButton(x + 15, y + 106, button -> {
            ClientNetworkHelper.send(new RequestStartEntrisPayload(this.numberHolder.getNumber()));
            this.clearEnchantmentList();
        }));
        this.submitEnchantmentButton = (SubmitEnchantmentsButton)this.m_142416_((GuiEventListener)new SubmitEnchantmentsButton(x + 92, y + 150, button -> {
            ArrayList<String> enchantments = new ArrayList<String>();
            for (EnchantmentSelectButton e : this.enchantmentSelectButtons) {
                if (e.number <= 0) continue;
                enchantments.add(EnchantmentHelp.getEnchantmentIdStr((Level)Minecraft.m_91087_().f_91073_, e.enchantment) + " " + e.number);
            }
            ClientNetworkHelper.send(new RequestEntrisEnchantsPayload(enchantments));
            this.clearEnchantmentList();
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
        }));
        this.submitEnchantmentButton.f_93624_ = false;
        this.submitEnchantmentButton.f_93623_ = false;
        this.startGameButton.f_93623_ = false;
        Entris.disableRegularEnchanting = true;
    }

    public void clearEnchantmentList() {
        for (EnchantmentSelectButton e : this.enchantmentSelectButtons) {
            this.m_169411_((GuiEventListener)e);
        }
        this.enchantmentSelectButtons.clear();
        this.submitEnchantmentButton.f_93624_ = false;
        this.submitEnchantmentButton.f_93623_ = false;
    }

    public void refreshEnchantmentList() {
        this.clearEnchantmentList();
        ItemStack itemStack = ((Slot)((EnchantmentMenu)this.f_97732_).f_38839_.get(0)).m_7993_();
        if (itemStack != null) {
            Enchantment[] enchantments = EnchantmentHelp.getPossibleEnchantments((Level)Minecraft.m_91087_().f_91073_, itemStack);
            int ct = 0;
            for (Enchantment enchantment : enchantments) {
                if (EnchantmentHelp.disallowedEnchanting(enchantment)) continue;
                EnchantmentSelectButton b = (EnchantmentSelectButton)this.m_142416_((GuiEventListener)new EnchantmentSelectButton(this.f_97735_ + 92, this.f_97736_ + 3 + 12 * ct, enchantment, button -> {
                    if (this.tetrisGame.getScore() >= 1000 && ((EnchantmentSelectButton)button).increment()) {
                        this.tetrisGame.score -= 1000;
                    }
                }));
                this.enchantmentSelectButtons.add(b);
                ++ct;
            }
            this.submitEnchantmentButton.f_93624_ = !this.enchantmentSelectButtons.isEmpty();
            this.submitEnchantmentButton.f_93623_ = !this.enchantmentSelectButtons.isEmpty();
        }
    }

    @Override
    public void beginGame() {
        if (!this.tetrisGame.isStarted && !this.tetrisGame.gameOver) {
            this.tetrisGame.startGame(this.numberHolder.getNumber() * 6);
        } else if (this.tetrisGame.gameOver) {
            this.tetrisGame = new TetrisGame();
            this.tetrisGame.startGame(this.numberHolder.getNumber() * 6);
        }
    }

    @Override
    public void errorHandling() {
        this.m_7379_();
    }

    @Override
    public void validifyScore(int score) {
        this.tetrisGame.score = score;
        this.refreshEnchantmentList();
    }

    public EnchantmentScreenMixin(EnchantmentMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, cancellable=true)
    protected void changeDrawBackground(GuiGraphics context, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        if (this.enableEntris) {
            int i = (this.f_96543_ - this.entrisBackgroundWidth) / 2;
            int j = (this.f_96544_ - this.entrisBackgroundHeight) / 2;
            context.m_280218_(ENTRIS, i, j, 0, 0, this.entrisBackgroundWidth, this.entrisBackgroundHeight);
            int x = (this.f_96543_ - this.entrisBackgroundWidth) / 2;
            int y = (this.f_96544_ - this.entrisBackgroundHeight) / 2;
            this.tetrisGame.render(context, x + 92, y + 155);
            if (this.tetrisGame.holdTetrominoDisplay != null) {
                this.tetrisGame.renderTetromino(context, this.tetrisGame.holdTetrominoDisplay, 0, 0, x + 45, y + 33);
            }
            if (this.showInventory) {
                context.m_280218_(INVENTORY, i, j, 0, 0, this.entrisBackgroundWidth, this.entrisBackgroundHeight);
            }
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/EnchantmentScreenHandler;getLapisCount()I")}, cancellable=true)
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.enableEntris) {
            ci.cancel();
        }
    }

    @Unique
    private void setEntris(boolean state) {
        this.enableEntris = state;
        this.updateSlotDownStatus();
    }

    @Unique
    private void updateSlotDownStatus() {
        for (int i = 2; i < ((EnchantmentMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((EnchantmentMenu)this.f_97732_).f_38839_.get(i);
            if (this.enableEntris) {
                if (this.showInventory) {
                    ((SlotEnabler)slot).setEnabled(true);
                    continue;
                }
                ((SlotEnabler)slot).setEnabled(false);
                continue;
            }
            ((SlotEnabler)slot).setEnabled(true);
        }
    }

    @Inject(method={"doTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void doTick(CallbackInfo ci) {
        if (this.enableEntris) {
            if (handle == -1L) {
                this.regenerateHandle();
            }
            ++this.blinkCounter;
            if (this.blinkCounter > 9) {
                this.blinkCounter = 0;
            }
            try {
                this.tetrisGame.tick();
                this.tetrisGame.continuousInput(handle);
            }
            catch (Exception e) {
                this.regenerateHandle();
            }
            ci.cancel();
        }
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        if (!this.enableEntris) {
            super.m_280003_(context, mouseX, mouseY);
        } else {
            context.m_280056_(this.f_96547_, "Entris", this.f_97728_ + 18, this.f_97729_, 0x404040, false);
            context.m_280056_(this.f_96547_, "HOLD:", this.f_97728_ + 5, this.f_97729_ + 17, 0x404040, false);
            if (!this.showInventory) {
                context.m_280056_(this.f_96547_, "How much XP?", this.f_97728_, this.f_97729_ + 70, 0x404040, false);
                if (this.numberHolder.getNumberStr().isEmpty() && this.blinkCounter > 5) {
                    context.m_280056_(this.f_96547_, "_", this.f_97728_, this.f_97729_ + 80, 0x55FFFF, false);
                } else {
                    context.m_280056_(this.f_96547_, this.numberHolder.getNumberStr(), this.f_97728_, this.f_97729_ + 80, 0x55FFFF, false);
                }
                int seconds = this.numberHolder.getNumber() % 10 * 6;
                context.m_280056_(this.f_96547_, "    LVL = " + (int)Math.floor((float)this.numberHolder.getNumber() / 10.0f) + ":" + String.format("%02d", seconds), this.f_97728_, this.f_97729_ + 80, 0x404040, false);
                int neededLapis = (int)Math.ceil((float)this.numberHolder.getNumber() / 10.0f);
                if (this.tetrisGame.isStarted && !this.tetrisGame.gameOver) {
                    this.startGameButton.f_93623_ = false;
                } else if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    if (Minecraft.m_91087_().f_91074_.f_36078_ < this.numberHolder.getNumber() && !Minecraft.m_91087_().f_91074_.m_7500_()) {
                        context.m_280056_(this.f_96547_, "NOT ENOUGH XP", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (this.numberHolder.getNumber() > this.bookshelveMaxLevel) {
                        context.m_280056_(this.f_96547_, "^XP MORE BOOKS", this.f_97728_ - 3, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (((EnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_()) {
                        context.m_280056_(this.f_96547_, "NEED ITEM", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (((EnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_().m_41793_()) {
                        context.m_280056_(this.f_96547_, "HAS ENCHANT", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (!((EnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_().m_41792_()) {
                        context.m_280056_(this.f_96547_, "CANT ENCHANT", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (((EnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_().m_41720_() == Items.f_42517_) {
                        context.m_280056_(this.f_96547_, "NO BOOKS", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else if (((EnchantmentMenu)this.f_97732_).m_39492_() < neededLapis) {
                        context.m_280056_(this.f_96547_, "NEEDS " + neededLapis + " LAPIS", this.f_97728_, this.f_97729_ + 91, 0xFF5555, false);
                    } else {
                        this.startGameButton.f_93623_ = this.numberHolder.getNumber() > 0;
                    }
                } else {
                    this.startGameButton.f_93623_ = true;
                }
                context.m_280056_(this.f_96547_, "TIME: " + this.tetrisGame.getMinutes() + ":" + String.format("%02d", this.tetrisGame.getSeconds()), this.f_97728_, this.f_97729_ + 130, 0x404040, false);
                context.m_280056_(this.f_96547_, "SCORE: " + this.tetrisGame.getScore(), this.f_97728_, this.f_97729_ + 139, 0x404040, false);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.enableEntris) {
            if (this.tetrisGame.input(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 32) {
                return true;
            }
            this.numberHolder.input(keyCode);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Unique
    void regenerateHandle() {
        Minecraft gameInstance = Minecraft.m_91087_();
        handle = gameInstance.m_91268_().m_85439_();
    }
}

