/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.entris.mixin;

import com.matthewperiut.entris.client.SlotEnabler;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slot.class})
public class SlotMixin
implements SlotEnabler {
    @Unique
    public boolean overriddenEnabled = false;
    @Unique
    public boolean enabled;
    @Unique
    boolean overriddenCanTake;
    @Unique
    boolean canTake;

    @Override
    public void setEnabled(boolean enabled) {
        this.overriddenEnabled = true;
        this.enabled = enabled;
    }

    @Override
    public void setCanTake(boolean canTake) {
        this.overriddenCanTake = true;
        this.canTake = canTake;
    }

    @Inject(method={"isEnabled"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEnabledModifier(CallbackInfoReturnable<Boolean> cir) {
        if (this.overriddenEnabled) {
            cir.setReturnValue((Object)this.enabled);
        }
    }

    @Inject(method={"canTakeItems"}, at={@At(value="HEAD")}, cancellable=true)
    public void canTakeItemsModifier(CallbackInfoReturnable<Boolean> cir) {
        if (this.overriddenCanTake) {
            cir.setReturnValue((Object)this.canTake);
        }
    }
}

