/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.entris.network.payload;

import com.matthewperiut.entris.network.EntrisNetworkingConstants;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record RequestEntrisEnchantsPayload(ArrayList<String> enchants) implements FabricPacket
{
    public static final PacketType<RequestEntrisEnchantsPayload> TYPE = PacketType.create((ResourceLocation)EntrisNetworkingConstants.REQUEST_ENTRIS_ENCHANTS_PACKET_ID, RequestEntrisEnchantsPayload::new);

    public RequestEntrisEnchantsPayload(FriendlyByteBuf byteBuf) {
        this(new ArrayList<String>());
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            int strLen = byteBuf.readInt();
            byte[] strBytes = new byte[strLen];
            byteBuf.readBytes(strBytes);
            this.enchants.add(new String(strBytes, StandardCharsets.UTF_8));
        }
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.enchants.size());
        for (String s : this.enchants) {
            byte[] strBytes = s.getBytes(StandardCharsets.UTF_8);
            byteBuf.writeInt(strBytes.length);
            byteBuf.writeBytes(strBytes);
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

