/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure_catalog.Register;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;

public class ExposureCatalog {
    public static final String ID = "exposure_catalog";
    public static final int EXPOSURES_PER_PAGE = 600;

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        Items.init();
        EntityTypes.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        static void init() {
        }
    }

    public static class BlockEntityTypes {
        static void init() {
        }
    }

    public static class Items {
        static void init() {
        }
    }

    public static class EntityTypes {
        static void init() {
        }
    }

    public static class MenuTypes {
        static void init() {
        }
    }

    public static class RecipeSerializers {
        static void init() {
        }
    }

    public static class SoundEvents {
        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.m_262824_((ResourceLocation)ExposureCatalog.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static void init() {
        }
    }

    public static class Tags {

        public static class Items {
        }
    }

    public static class Advancements {
        public static void register() {
        }
    }

    public static class Stats {
        private static final Map<ResourceLocation, StatFormatter> STATS = new HashMap<ResourceLocation, StatFormatter>();

        private static ResourceLocation create(ResourceLocation location, StatFormatter formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)location, (Object)location);
                net.minecraft.stats.Stats.f_12988_.m_12899_(location, formatter);
            });
        }
    }
}

