/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.ice_and_fire_spellbooks.config;

import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorValueConfig {
    private static final ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static ArmorValues dragonsteelArmorValue;
    public static ArmorValues dragonsteelMaskArmorValue;

    private static ArmorValues setupConfig(ForgeConfigSpec.Builder builder, String name, List<Integer> armorPoints) {
        builder.push(name);
        ArmorValues config = new ArmorValues((ForgeConfigSpec.ConfigValue<List<? extends Integer>>)builder.worldRestart().comment("Defines armor values for Dragon Priest armor. Default is [6, 9, 12, 6]").comment("[feet, legs, chest, head]").defineList("dragonsteel_armor_values", () -> armorPoints, p -> true));
        builder.pop();
        return config;
    }

    private static ArmorValues setupDragonPriestMaskConfig(ForgeConfigSpec.Builder builder, List<Integer> armorPoints) {
        ArmorValues config = new ArmorValues((ForgeConfigSpec.ConfigValue<List<? extends Integer>>)builder.worldRestart().comment("Defines armor values for Dragon Priest Masks [0, 0, 0, 5]").comment("[feet, legs, chest, head]").defineList("dragonsteel_mask_armor_values", () -> armorPoints, p -> true));
        return config;
    }

    static {
        configBuilder.push("ArmorConfig");
        dragonsteelArmorValue = ArmorValueConfig.setupConfig(configBuilder, "DragonPriestArmor", List.of(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(12), Integer.valueOf(6)));
        dragonsteelMaskArmorValue = ArmorValueConfig.setupConfig(configBuilder, "DragonPriestMasks", List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(5)));
        configBuilder.pop();
        SPEC = configBuilder.build();
    }

    public record ArmorValues(ForgeConfigSpec.ConfigValue<List<? extends Integer>> armor) {
        public int getProtectionValues(EquipmentSlot slot) {
            if (((List)this.armor.get()).size() != 4) {
                return (Integer)((List)this.armor.getDefault()).get(slot.m_20749_());
            }
            return (Integer)((List)this.armor.get()).get(slot.m_20749_());
        }
    }
}

