/*
 * Decompiled with CFR 0.152.
 */
package com.ethem00.idogmod.entity.ai.goal;

import com.ethem00.idogmod.entity.iDogEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.MinecartChest;
import org.jetbrains.annotations.Nullable;

public class iDogAlertsGoal
extends Goal {
    private final iDogEntity iDog;
    @Nullable
    private LivingEntity threat;
    private MinecartChest treasure;
    private final float range;
    private int timer;
    private int cooldown;
    private boolean foundTreasure;
    private final TargetingConditions detectionPredicate;

    public iDogAlertsGoal(iDogEntity iDog, float range) {
        this.iDog = iDog;
        this.range = range;
        this.detectionPredicate = TargetingConditions.m_148352_().m_26883_((double)range).m_148355_();
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.cooldown = 400;
    }

    public boolean m_8036_() {
        if (this.iDog.isAlerting()) {
            return false;
        }
        if (!this.iDog.getAlertBool()) {
            return false;
        }
        if (this.iDog.m_146764_() % 100 > 5) {
            return false;
        }
        this.treasure = this.findChestMinecart();
        this.threat = this.findThreat();
        if (this.treasure != null) {
            this.foundTreasure = true;
            return true;
        }
        if (this.threat != null) {
            this.foundTreasure = false;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.treasure != null && this.treasure.m_6084_() && this.iDog.m_20270_((Entity)this.treasure) <= this.range) {
            return true;
        }
        return this.threat != null && this.threat.m_6084_() && this.iDog.m_20270_((Entity)this.threat) <= this.range;
    }

    public void m_8037_() {
        if (this.foundTreasure) {
            this.iDog.m_21563_().m_24960_((Entity)this.treasure, 30.0f, 30.0f);
        } else {
            this.iDog.m_21563_().m_24960_((Entity)this.threat, 30.0f, 30.0f);
        }
        if (this.cooldown <= 0 && !this.iDog.isAlerting() && this.iDog.getAlertBool()) {
            this.iDog.setAlerting(true);
            this.iDog.playAlertSounds(this.switchThreatByType());
            this.cooldown = this.iDog.m_21827_() ? 400 : 200;
        } else if (!this.iDog.isAlerting() && this.iDog.getAlertBool()) {
            --this.cooldown;
        }
    }

    public void m_8056_() {
    }

    public void m_8041_() {
        this.threat = null;
    }

    private LivingEntity findThreat() {
        List nearby = this.iDog.m_9236_().m_6443_(Monster.class, this.iDog.m_20191_().m_82400_((double)this.range), entity -> entity.m_6084_() && !entity.m_213877_());
        if (!nearby.isEmpty()) {
            return (LivingEntity)nearby.get(0);
        }
        return null;
    }

    private MinecartChest findChestMinecart() {
        List nearby = this.iDog.m_9236_().m_6443_(MinecartChest.class, this.iDog.m_20191_().m_82400_((double)this.range), entity -> entity.m_6084_() && !entity.m_213877_());
        if (!nearby.isEmpty()) {
            return (MinecartChest)nearby.get(0);
        }
        return null;
    }

    private int switchThreatByType() {
        Object entity = this.foundTreasure ? this.treasure : this.threat;
        System.out.println("Entity is: " + entity.m_6095_().m_147048_());
        return switch (entity.m_6095_().m_147048_()) {
            case "chest_minecart" -> -1;
            case "zombie" -> 0;
            case "husk" -> 0;
            case "drowned" -> 0;
            case "skeleton" -> 1;
            case "stray" -> 1;
            case "spider" -> 2;
            case "cave_spider" -> 2;
            case "creeper" -> 3;
            case "enderman" -> 4;
            default -> -10;
        };
    }
}

