/*
 * Decompiled with CFR 0.152.
 */
package com.ethem00.idogmod.entity;

import com.ethem00.idogmod.entity.ai.goal.iDogAlertsGoal;
import com.ethem00.idogmod.entity.ai.goal.iDogAttackWithOwnerGoal;
import com.ethem00.idogmod.entity.ai.goal.iDogBegGoal;
import com.ethem00.idogmod.entity.client.render.entity.animation.iDogEasing;
import com.ethem00.idogmod.entity.client.render.entity.animation.iDogEyeVariants;
import com.ethem00.idogmod.network.ModPackets;
import com.ethem00.idogmod.network.iDogPlayAlertPacketS2C;
import com.ethem00.idogmod.network.iDogPlayDiscPacketS2C;
import com.ethem00.idogmod.screen.iDogScreenHandler;
import com.ethem00.idogmod.sound.ModSounds;
import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class iDogEntity
extends TamableAnimal
implements NeutralMob,
ContainerSingleItem,
iDogEasing,
iDogEyeVariants {
    private static final EntityDataAccessor<Boolean> BEGGING = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALERTING = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PLAYING = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> CURRENT_DISC = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<ItemStack> DISC_ITEMSTACK = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> EYE_VARIANT = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> SONG_END_TICK = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)120);
    private boolean wasBegging = false;
    private int cumulativeBegTick = 0;
    private SoundEvent currentSong;
    private int angerTime;
    @org.jetbrains.annotations.Nullable
    private UUID angryAt;
    public static final Predicate<LivingEntity> FOLLOW_TAMED_PREDICATE = entity -> {
        EntityType entityType = entity.m_6095_();
        return entityType == EntityType.f_20520_ || entityType == EntityType.f_20517_ || entityType == EntityType.f_20452_;
    };
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private int ticksThisSecond;
    private long tickCount;
    private static final EntityDataAccessor<Long> START_TICK = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Boolean> LOOP_BOOLEAN = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALERT_BOOLEAN = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SONG_VOLUME = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> EYE_COVER = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_BPM = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_PER_BEAT_CUMULATIVE = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> TICKS_PER_BEAT = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ANIMATION_SET = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STEP = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STEP_COUNT = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEAT_CUMULATIVE = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EASE_METHOD = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPEED_MOD = SynchedEntityData.m_135353_(iDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean forceFreshTick = false;
    private float eyeRedValue;
    private float eyeGreenValue;
    private float eyeBlueValue;
    private float eyeAlphaValue;
    private Color baseEyeRGBA = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public iDogEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new iDogEscapeDangerGoal(1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new iDogAlertsGoal(this, 16.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new iDogBegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new iDogAttackWithOwnerGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::shouldAngerAtTarget));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, Wolf.f_30357_));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22285_, 1.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEGGING, (Object)false);
        this.f_19804_.m_135372_(ALERTING, (Object)false);
        this.f_19804_.m_135372_(START_TICK, (Object)0L);
        this.f_19804_.m_135372_(SONG_VOLUME, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LOOP_BOOLEAN, (Object)false);
        this.f_19804_.m_135372_(ALERT_BOOLEAN, (Object)true);
        this.f_19804_.m_135372_(DISC_ITEMSTACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(IS_PLAYING, (Object)false);
        this.f_19804_.m_135372_(CURRENT_DISC, (Object)"none");
        this.f_19804_.m_135372_(EYE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SONG_END_TICK, (Object)0L);
        this.f_19804_.m_135372_(EYE_COVER, (Object)0);
        this.f_19804_.m_135372_(CURRENT_BPM, (Object)130);
        this.f_19804_.m_135372_(TICKS_PER_BEAT_CUMULATIVE, (Object)0);
        this.f_19804_.m_135372_(TICKS_PER_BEAT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANIMATION_SET, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_STEP, (Object)-1);
        this.f_19804_.m_135372_(ANIMATION_STEP_COUNT, (Object)0);
        this.f_19804_.m_135372_(BEAT_CUMULATIVE, (Object)0);
        this.f_19804_.m_135372_(EASE_METHOD, (Object)0);
        this.f_19804_.m_135372_(SPEED_MOD, (Object)Float.valueOf(1.0f));
    }

    public void m_142036_() {
        super.m_142036_();
        this.f_19804_.m_135381_(IS_PLAYING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            if (this.isPlayingRecord()) {
                ++this.ticksThisSecond;
                this.songDisplayLogic();
                if (this.hasSecondPassed()) {
                    this.ticksThisSecond = 0;
                }
            } else {
                this.setEyeCover(0);
                this.setEyeVariant();
                this.eyeAlphaValue = 1.0f;
            }
            if (this.isBegging()) {
                this.cumulativeBegTick += 4;
                this.wasBegging = true;
            } else if (!this.isBegging() && this.wasBegging()) {
                this.cumulativeBegTick -= 2;
                if (this.cumulativeBegTick <= 0) {
                    this.wasBegging = false;
                    this.cumulativeBegTick = 0;
                }
            }
            ++this.tickCount;
        }
    }

    public void songDisplayLogic() {
        if (this.isSongFinished()) {
            this.stopPlaying();
            if (this.getLoopBool()) {
                this.startPlaying(this.getDiscAsItem());
            }
        } else {
            float fadeDelta;
            int tickBeatCumulative = (Integer)this.f_19804_.m_135370_(TICKS_PER_BEAT_CUMULATIVE) + 1;
            float ticksPerBeat = ((Float)this.f_19804_.m_135370_(TICKS_PER_BEAT)).floatValue();
            int animationStep = (Integer)this.f_19804_.m_135370_(ANIMATION_STEP);
            float speedMod = ((Float)this.f_19804_.m_135370_(SPEED_MOD)).floatValue();
            this.f_19804_.m_135381_(TICKS_PER_BEAT_CUMULATIVE, (Object)tickBeatCumulative);
            this.eyeAlphaValue = fadeDelta = (switch ((Integer)this.f_19804_.m_135370_(EASE_METHOD)) {
                case 0 -> (float)tickBeatCumulative * speedMod / ticksPerBeat;
                default -> (float)tickBeatCumulative * speedMod / ticksPerBeat;
            });
            if ((float)tickBeatCumulative * speedMod >= ticksPerBeat) {
                this.f_19804_.m_135381_(BEAT_CUMULATIVE, (Object)((Integer)this.f_19804_.m_135370_(BEAT_CUMULATIVE) + 1));
                if (animationStep <= 0) {
                    this.setEyeCover(this.getFromAnimSet((Integer)this.f_19804_.m_135370_(ANIMATION_SET), (Integer)this.f_19804_.m_135370_(ANIMATION_STEP)));
                    if (!this.m_9236_().m_5776_()) {
                        this.setNextAnimSetNumber();
                        this.f_19804_.m_135381_(ANIMATION_STEP, (Object)this.getFromAnimSet((Integer)this.f_19804_.m_135370_(ANIMATION_SET), -1));
                        this.f_19804_.m_135381_(ANIMATION_STEP_COUNT, (Object)((Integer)this.f_19804_.m_135370_(ANIMATION_STEP) + 1));
                        this.setEyeVariant();
                        this.setEaseMethod();
                    }
                } else {
                    this.setEyeCover(this.getFromAnimSet((Integer)this.f_19804_.m_135370_(ANIMATION_SET), (Integer)this.f_19804_.m_135370_(ANIMATION_STEP)));
                    if (!this.m_9236_().m_5776_()) {
                        this.f_19804_.m_135381_(ANIMATION_STEP, (Object)(animationStep - 1));
                    }
                }
                this.f_19804_.m_135381_(TICKS_PER_BEAT_CUMULATIVE, (Object)0);
            }
        }
    }

    private void setEaseMethod() {
        this.f_19804_.m_135381_(EASE_METHOD, (Object)3);
        float speedMod = switch (this.f_19796_.m_188503_(5)) {
            case 0 -> 1.0f;
            case 1 -> 1.0f;
            case 2 -> 0.5f;
            case 3 -> 0.5f;
            case 4 -> {
                if (this.f_19796_.m_188503_(3) == 0) {
                    yield 0.25f;
                }
                yield 0.5f;
            }
            default -> 0.5f;
        };
        this.f_19804_.m_135381_(SPEED_MOD, (Object)Float.valueOf(speedMod));
    }

    private void setNextAnimSetNumber() {
        this.f_19804_.m_135381_(ANIMATION_SET, (Object)this.f_19796_.m_188503_(25));
    }

    private int getFromAnimSet(int set, int step) {
        int noneAnim = 0;
        int[] clockwiseAnim = new int[]{3, 4, 5, 6, 7, 8};
        int[] antiClockwiseAnim = new int[]{8, 7, 6, 5, 4, 3};
        int[] invertClockwiseAnim = new int[]{-3, -4, -5, -6, -7, -8};
        int[] invertAntiClockwiseAnim = new int[]{-8, -7, -6, -5, -4, -3};
        int[] stripeDownUpAnim = new int[]{-4, 40, 407, -7, 70, 407};
        int[] stripeUpDownAnim = new int[]{-7, 70, 407, -4, 40, 407};
        int[] stripeDownUpFullAnim = new int[]{407, 40, -4, -7, 70, 407};
        int[] stripeUpDownFullAnim = new int[]{407, 70, -7, -4, 40, 407};
        int[] invertClockwiseTrianglesAnim = new int[]{338, 337, 336, 335, 334, 333};
        int[] invertAntiClockwiseTrianglesAnim = new int[]{333, 334, 335, 336, 337, 338};
        int[] clockwiseTrianglesAnim = new int[]{-338, -337, -336, -335, -334, -333};
        int[] antiClockwiseTrianglesAnim = new int[]{-333, -334, -335, -336, -337, -338};
        int[] alternateTrianglesAnim = new int[]{-334, -337, -333, -336, -338, -335};
        int[] alternateTrianglesReverseAnim = new int[]{-335, -338, -336, -333, -337, -334};
        int[] sideSnakesAnim = new int[]{-3, -8, -1, -5, -6, 0, -6, -5, -1, -8, -3};
        int[] sideSnakesInvertedAnim = new int[]{3, 8, 1, 5, 6, 0, 6, 5, 1, 8, 3};
        int[] inAndOutAnim = new int[]{1, -1, 1, -1, 1, -1, 1, -1};
        int[] stripesInAndOutAnim = new int[]{407, -407, 407, -407, 407, 1, 407, 1, -407, -2, -407, -2};
        int[] stripesInAndOutReversedAnim = new int[]{-2, -407, -2, -407, 1, 407, 1, 407, -407, 407, -407, 407};
        int[] twistClockwiseAnim = new int[]{47, 58, 63, 74, 85, 36, 47};
        int[] twistClockwiseInvertedAnim = new int[]{-47, -58, -63, -74, -85, -36, -47};
        int[] alternatingCrossesAnim = new int[]{47, -47, 47, -47, 47, -47};
        int[] washingOverAnim = new int[]{-4, -345, 678, 7, 0};
        int[] washingOutAnim = new int[]{0, 4, 345, -678, -7};
        if (step <= -1) {
            return switch (set) {
                case 0 -> 3;
                case 1 -> clockwiseAnim.length - 1;
                case 2 -> antiClockwiseAnim.length - 1;
                case 3 -> invertClockwiseAnim.length - 1;
                case 4 -> invertAntiClockwiseAnim.length - 1;
                case 5 -> stripeDownUpAnim.length - 1;
                case 6 -> stripeUpDownAnim.length - 1;
                case 7 -> stripeDownUpFullAnim.length - 1;
                case 8 -> stripeUpDownFullAnim.length - 1;
                case 9 -> invertClockwiseTrianglesAnim.length - 1;
                case 10 -> invertAntiClockwiseTrianglesAnim.length - 1;
                case 11 -> clockwiseTrianglesAnim.length - 1;
                case 12 -> antiClockwiseTrianglesAnim.length - 1;
                case 13 -> alternateTrianglesAnim.length - 1;
                case 14 -> alternateTrianglesReverseAnim.length - 1;
                case 15 -> sideSnakesAnim.length - 1;
                case 16 -> sideSnakesInvertedAnim.length - 1;
                case 17 -> inAndOutAnim.length - 1;
                case 18 -> stripesInAndOutAnim.length - 1;
                case 19 -> stripesInAndOutReversedAnim.length - 1;
                case 20 -> twistClockwiseAnim.length - 1;
                case 21 -> twistClockwiseInvertedAnim.length - 1;
                case 22 -> alternatingCrossesAnim.length - 1;
                case 23 -> washingOverAnim.length - 1;
                case 24 -> washingOutAnim.length - 1;
                default -> 1;
            };
        }
        return switch (set) {
            case 0 -> noneAnim;
            case 1 -> clockwiseAnim[step];
            case 2 -> antiClockwiseAnim[step];
            case 3 -> invertClockwiseAnim[step];
            case 4 -> invertAntiClockwiseAnim[step];
            case 5 -> stripeDownUpAnim[step];
            case 6 -> stripeUpDownAnim[step];
            case 7 -> stripeDownUpFullAnim[step];
            case 8 -> stripeUpDownFullAnim[step];
            case 9 -> invertClockwiseTrianglesAnim[step];
            case 10 -> invertAntiClockwiseTrianglesAnim[step];
            case 11 -> clockwiseTrianglesAnim[step];
            case 12 -> antiClockwiseTrianglesAnim[step];
            case 13 -> alternateTrianglesAnim[step];
            case 14 -> alternateTrianglesReverseAnim[step];
            case 15 -> sideSnakesAnim[step];
            case 16 -> sideSnakesInvertedAnim[step];
            case 17 -> inAndOutAnim[step];
            case 18 -> stripesInAndOutAnim[step];
            case 19 -> stripesInAndOutReversedAnim[step];
            case 20 -> twistClockwiseAnim[step];
            case 21 -> twistClockwiseInvertedAnim[step];
            case 22 -> alternatingCrossesAnim[step];
            case 23 -> washingOverAnim[step];
            case 24 -> washingOutAnim[step];
            default -> noneAnim;
        };
    }

    private void setEyeVariant() {
        this.f_19804_.m_135381_(EYE_VARIANT, (Object)this.getEyeVariantFromDisc(this.getCurrentDisc()));
    }

    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYE_VARIANT);
    }

    private int getEyeVariantFromDisc(String disc) {
        if (!this.isPlayingRecord()) {
            return 0;
        }
        return switch (disc) {
            case "none" -> this.f_19796_.m_188503_(music_disc_default_variants.length - 1);
            case "music_disc_5" -> this.f_19796_.m_188503_(music_disc_5_variants.length - 1);
            case "music_disc_11" -> this.f_19796_.m_188503_(music_disc_11_variants.length - 1);
            case "music_disc_13" -> this.f_19796_.m_188503_(music_disc_13_variants.length - 1);
            case "music_disc_blocks" -> this.f_19796_.m_188503_(music_disc_blocks_variants.length - 1);
            case "music_disc_cat" -> this.f_19796_.m_188503_(music_disc_cat_variants.length - 1);
            case "music_disc_chirp" -> this.f_19796_.m_188503_(music_disc_chirp_variants.length - 1);
            case "music_disc_far" -> this.f_19796_.m_188503_(music_disc_far_variants.length - 1);
            case "music_disc_mall" -> this.f_19796_.m_188503_(music_disc_mall_variants.length - 1);
            case "music_disc_mellohi" -> this.f_19796_.m_188503_(music_disc_mellohi_variants.length - 1);
            case "music_disc_otherside" -> this.f_19796_.m_188503_(music_disc_otherside_variants.length - 1);
            case "music_disc_pigstep" -> this.f_19796_.m_188503_(music_disc_pigstep_variants.length - 1);
            case "music_disc_relic" -> this.f_19796_.m_188503_(music_disc_relic_variants.length - 1);
            case "music_disc_stal" -> this.f_19796_.m_188503_(music_disc_stal_variants.length - 1);
            case "music_disc_strad" -> this.f_19796_.m_188503_(music_disc_strad_variants.length - 1);
            case "music_disc_wait" -> this.f_19796_.m_188503_(music_disc_wait_variants.length - 1);
            case "music_disc_ward" -> this.f_19796_.m_188503_(music_disc_ward_variants.length - 1);
            case "music_disc_red" -> this.f_19796_.m_188503_(music_disc_randomRed_variants.length - 1);
            case "music_disc_green" -> this.f_19796_.m_188503_(music_disc_randomGreen_variants.length - 1);
            case "music_disc_blue" -> this.f_19796_.m_188503_(music_disc_randomBlue_variants.length - 1);
            case "music_disc_rainbow" -> this.f_19796_.m_188503_(music_disc_randomRainbow_variants.length - 1);
            case "music_disc_creeper" -> this.f_19796_.m_188503_(music_disc_randomCreeper_variants.length - 1);
            case "music_disc_ender" -> this.f_19796_.m_188503_(music_disc_randomEnder_variants.length - 1);
            case "music_disc_berries" -> this.f_19796_.m_188503_(music_disc_randomBerries_variants.length - 1);
            default -> {
                int rand = this.f_19796_.m_188503_(7);
                switch (rand) {
                    case 0: {
                        this.setCurrentDisc("music_disc_red");
                        break;
                    }
                    case 1: {
                        this.setCurrentDisc("music_disc_green");
                        break;
                    }
                    case 2: {
                        this.setCurrentDisc("music_disc_blue");
                        break;
                    }
                    case 3: {
                        this.setCurrentDisc("music_disc_rainbow");
                        break;
                    }
                    case 4: {
                        this.setCurrentDisc("music_disc_creeper");
                        break;
                    }
                    case 5: {
                        this.setCurrentDisc("music_disc_berries");
                        break;
                    }
                    case 6: {
                        this.setCurrentDisc("music_disc_ender");
                    }
                }
                yield this.getEyeVariantFromDisc(this.getCurrentDisc());
            }
        };
    }

    public float getEyeRedValue() {
        return this.eyeRedValue;
    }

    public float getEyeGreenValue() {
        return this.eyeGreenValue;
    }

    public float getEyeBlueValue() {
        return this.eyeBlueValue;
    }

    public float getEyeAlpha() {
        return this.eyeAlphaValue;
    }

    @Deprecated
    private void setEyeRGBAFromDisc(String disc) {
        this.baseEyeRGBA = switch (disc) {
            case "none" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_5" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_11" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_13" -> new Color(1.0f, 0.75f, 0.25f, 1.0f);
            case "music_disc_blocks" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_cat" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_chirp" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_far" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_mall" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_mellohi" -> new Color(1.0f, 0.0f, 1.0f, 1.0f);
            case "music_disc_otherside" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_pigstep" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_relic" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_stal" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_strad" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_wait" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            case "music_disc_ward" -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
            default -> new Color(1.0f, 1.0f, 1.0f, 1.0f);
        };
        this.eyeRedValue = this.baseEyeRGBA.getRed();
        this.eyeGreenValue = this.baseEyeRGBA.getGreen();
        this.eyeBlueValue = this.baseEyeRGBA.getBlue();
        this.eyeAlphaValue = this.baseEyeRGBA.getAlpha();
    }

    public int getEyeCover() {
        return (Integer)this.f_19804_.m_135370_(EYE_COVER);
    }

    private void setEyeCover(int passedInt) {
        this.f_19804_.m_135381_(EYE_COVER, (Object)passedInt);
    }

    private boolean hasSecondPassed() {
        return this.ticksThisSecond >= 20;
    }

    public int getCurrentBPM() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_BPM);
    }

    private void setCurrentBPM(String disc) {
        int currentBPM = switch (disc) {
            case "none" -> 130;
            case "music_disc_5" -> 74;
            case "music_disc_11" -> 79;
            case "music_disc_13" -> 71;
            case "music_disc_blocks" -> 85;
            case "music_disc_cat" -> 112;
            case "music_disc_chirp" -> 110;
            case "music_disc_creator" -> 81;
            case "music_disc_creator_music_box" -> 111;
            case "music_disc_far" -> 130;
            case "music_disc_mall" -> 115;
            case "music_disc_mellohi" -> 91;
            case "music_disc_otherside" -> 92;
            case "music_disc_pigstep" -> 113;
            case "music_disc_precipice" -> 136;
            case "music_disc_relic" -> 136;
            case "music_disc_stal" -> 105;
            case "music_disc_strad" -> 188;
            case "music_disc_wait" -> 114;
            case "music_disc_ward" -> 107;
            case "music_disc_calm4" -> 140;
            default -> 130;
        };
        this.f_19804_.m_135381_(CURRENT_BPM, (Object)currentBPM);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (!this.m_9236_().m_5776_()) {
            super.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        boolean bl = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (bl) {
            this.m_19970_((LivingEntity)this, target);
        }
        return bl;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(5.0);
            this.m_21051_(Attributes.f_22285_).m_22100_(2.0);
            this.m_21153_(30.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public int getBegDelta() {
        return Mth.m_14045_((int)this.cumulativeBegTick, (int)0, (int)60);
    }

    public int getInverseBegDelta() {
        --this.cumulativeBegTick;
        return Mth.m_14045_((int)this.cumulativeBegTick, (int)0, (int)60);
    }

    public boolean wasBegging() {
        return this.wasBegging;
    }

    public void setBegging(boolean begging) {
        this.f_19804_.m_135381_(BEGGING, (Object)begging);
    }

    public boolean isBegging() {
        return (Boolean)this.f_19804_.m_135370_(BEGGING);
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    @org.jetbrains.annotations.Nullable
    public UUID getAngryAt() {
        return this.angryAt;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("RecordItem", 10)) {
            this.inventory.set(0, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("RecordItem")));
            this.f_19804_.m_135381_(DISC_ITEMSTACK, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("RecordItem")));
        }
        this.f_19804_.m_135381_(LOOP_BOOLEAN, (Object)nbt.m_128471_("LoopSongs"));
        this.f_19804_.m_135381_(ALERT_BOOLEAN, (Object)nbt.m_128471_("AlertMe"));
        this.f_19804_.m_135381_(SONG_VOLUME, (Object)Float.valueOf(nbt.m_128457_("SongVolume")));
        this.f_19804_.m_135381_(START_TICK, (Object)nbt.m_128454_("RecordStartTick"));
        this.tickCount = nbt.m_128454_("TickCount");
        if (nbt.m_128441_("CurrentDisc")) {
            String disc = nbt.m_128461_("CurrentDisc");
            this.setCurrentDisc(disc);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (!this.getStack().m_41619_()) {
            nbt.m_128365_("RecordItem", (Tag)this.getStack().m_41739_(new CompoundTag()));
        }
        if (!this.m_21824_()) {
            nbt.m_128350_("SongVolume", 1.0f);
            nbt.m_128379_("LoopSongs", false);
            nbt.m_128379_("AlertMe", true);
        } else {
            nbt.m_128350_("SongVolume", ((Float)this.f_19804_.m_135370_(SONG_VOLUME)).floatValue());
            nbt.m_128379_("LoopSongs", ((Boolean)this.f_19804_.m_135370_(LOOP_BOOLEAN)).booleanValue());
            nbt.m_128379_("AlertMe", ((Boolean)this.f_19804_.m_135370_(ALERT_BOOLEAN)).booleanValue());
        }
        nbt.m_128356_("RecordStartTick", ((Long)this.f_19804_.m_135370_(START_TICK)).longValue());
        nbt.m_128356_("TickCount", this.tickCount);
        nbt.m_128359_("CurrentDisc", this.getCurrentDisc());
    }

    public ItemStack getCurrentDiscItemStack() {
        return (ItemStack)this.inventory.get(0);
    }

    public String getCurrentDisc() {
        return (String)this.f_19804_.m_135370_(CURRENT_DISC);
    }

    private void setCurrentDisc(String discName) {
        this.f_19804_.m_135381_(CURRENT_DISC, (Object)discName);
    }

    private void setLoopBool(boolean passedBool) {
        this.f_19804_.m_135381_(LOOP_BOOLEAN, (Object)passedBool);
    }

    public boolean getLoopBool() {
        return (Boolean)this.f_19804_.m_135370_(LOOP_BOOLEAN);
    }

    private void setAlertBool(boolean passedBool) {
        if (!passedBool) {
            this.setAlerting(false);
        }
        this.f_19804_.m_135381_(ALERT_BOOLEAN, (Object)passedBool);
    }

    public boolean getAlertBool() {
        return (Boolean)this.f_19804_.m_135370_(ALERT_BOOLEAN);
    }

    public void setSongVolume(int passedVolume) {
        this.f_19804_.m_135381_(SONG_VOLUME, (Object)Float.valueOf((float)Mth.m_14045_((int)passedVolume, (int)0, (int)100) / 100.0f));
    }

    public float getSongVolume(boolean override) {
        if (override) {
            return ((Float)this.f_19804_.m_135370_(SONG_VOLUME)).floatValue();
        }
        if (this.isAlerting()) {
            return 0.01f;
        }
        return ((Float)this.f_19804_.m_135370_(SONG_VOLUME)).floatValue();
    }

    public boolean isPlayingRecord() {
        return (Boolean)this.f_19804_.m_135370_(IS_PLAYING);
    }

    public boolean isAlerting() {
        return (Boolean)this.f_19804_.m_135370_(ALERTING);
    }

    public void setAlerting(boolean bool) {
        this.f_19804_.m_135381_(ALERTING, (Object)bool);
    }

    public void stopPlayingRecord() {
        this.f_19804_.m_135381_(IS_PLAYING, (Object)false);
    }

    public void soundInstanceFinishedAlert() {
        this.stopPlaying();
        this.startPlaying(this.getDiscAsItem());
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13158_) && this.getStack(slot).m_41619_();
    }

    public void startPlaying(RecordItem musicDisc) {
        if (!this.forceFreshTick) {
            this.forceFreshTick = true;
            this.f_19804_.m_135381_(START_TICK, (Object)this.tickCount);
            if (!this.m_9236_().m_5776_()) {
                this.f_19804_.m_135381_(IS_PLAYING, (Object)true);
                this.setSongEndTick(musicDisc);
                this.setCurrentBPM(musicDisc.toString());
                this.setTicksPerBeat();
                this.setEaseMethod();
                this.setNextAnimSetNumber();
                this.f_19804_.m_135381_(ANIMATION_STEP, (Object)this.getFromAnimSet((Integer)this.f_19804_.m_135370_(ANIMATION_SET), -1));
                this.f_19804_.m_135381_(ANIMATION_STEP_COUNT, (Object)((Integer)this.f_19804_.m_135370_(ANIMATION_STEP) + 1));
                this.setEyeVariant();
            }
            if (!this.m_9236_().m_5776_()) {
                ModPackets.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new iDogPlayDiscPacketS2C(this.m_19879_(), BuiltInRegistries.f_257033_.m_7981_((Object)musicDisc), (String)this.f_19804_.m_135370_(CURRENT_DISC)));
            }
            this.currentSong = musicDisc.m_43051_();
            this.markDirty();
        }
    }

    private void stopPlaying() {
        if (!this.m_9236_().m_5776_() && this.isPlayingRecord()) {
            this.f_19804_.m_135381_(IS_PLAYING, (Object)false);
            this.f_19804_.m_135381_(SONG_END_TICK, (Object)0L);
            this.f_19804_.m_135381_(IS_PLAYING, (Object)false);
            this.f_19804_.m_135381_(SONG_END_TICK, (Object)0L);
            this.f_19804_.m_135381_(EYE_COVER, (Object)0);
            this.f_19804_.m_135381_(CURRENT_BPM, (Object)130);
            this.f_19804_.m_135381_(TICKS_PER_BEAT_CUMULATIVE, (Object)0);
            this.f_19804_.m_135381_(TICKS_PER_BEAT, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(ANIMATION_SET, (Object)0);
            this.f_19804_.m_135381_(ANIMATION_STEP, (Object)-1);
            this.f_19804_.m_135381_(ANIMATION_STEP_COUNT, (Object)0);
            this.f_19804_.m_135381_(BEAT_CUMULATIVE, (Object)0);
            this.f_19804_.m_135381_(SPEED_MOD, (Object)Float.valueOf(1.0f));
        }
        this.forceFreshTick = false;
        this.markDirty();
    }

    private boolean isSongFinished() {
        return this.tickCount >= (Long)this.f_19804_.m_135370_(SONG_END_TICK);
    }

    private void setSongEndTick(RecordItem musicDisc) {
        this.f_19804_.m_135381_(SONG_END_TICK, (Object)((Long)this.f_19804_.m_135370_(START_TICK) + (long)musicDisc.m_43036_() + 20L));
    }

    public long getSongEndTick() {
        return (Long)this.f_19804_.m_135370_(SONG_END_TICK);
    }

    private void setTicksPerBeat() {
        this.f_19804_.m_135381_(TICKS_PER_BEAT, (Object)Float.valueOf(60.0f / (float)this.getCurrentBPM() * 20.0f));
    }

    public int getMaxCountPerStack() {
        return 1;
    }

    public ItemStack getStack(int slot) {
        return (ItemStack)this.inventory.get(0);
    }

    public ItemStack getStack() {
        return (ItemStack)this.inventory.get(0);
    }

    public RecordItem getDiscAsItem() {
        if (((ItemStack)this.f_19804_.m_135370_(DISC_ITEMSTACK)).m_41720_() instanceof RecordItem) {
            return (RecordItem)((ItemStack)this.f_19804_.m_135370_(DISC_ITEMSTACK)).m_41720_();
        }
        return null;
    }

    public void setStack(int slot, ItemStack stack) {
        if (stack.m_204117_(ItemTags.f_13158_)) {
            this.inventory.set(0, (Object)stack);
            this.f_19804_.m_135381_(DISC_ITEMSTACK, (Object)stack);
            this.setCurrentDisc(stack.m_41720_().toString());
            this.startPlaying((RecordItem)stack.m_41720_());
            this.setSongEndTick((RecordItem)stack.m_41720_());
            this.m_5496_(SoundEvents.f_12017_, 2.0f, 0.25f);
            this.m_5496_(SoundEvents.f_11771_, 2.0f, 0.5f);
        }
    }

    public ItemStack removeStack(int slot, int amount) {
        this.dropRecord();
        ItemStack itemStack = Objects.requireNonNullElse((ItemStack)this.inventory.get(0), ItemStack.f_41583_);
        this.m_5496_(SoundEvents.f_12016_, 2.0f, 2.0f);
        this.inventory.set(0, (Object)ItemStack.f_41583_);
        if (!itemStack.m_41619_()) {
            this.setCurrentDisc("none");
            this.f_19804_.m_135381_(DISC_ITEMSTACK, (Object)ItemStack.f_41583_);
            this.stopPlaying();
        }
        return itemStack;
    }

    public ItemStack removeStack() {
        return this.removeStack(0, 64);
    }

    public void dropRecord() {
        ItemStack itemStack = this.getStack();
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        this.m_19983_(itemStack);
    }

    public void markDirty() {
    }

    public ItemStack m_8020_(int pSlot) {
        return this.getStack();
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.removeStack();
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.setStack(pSlot, pStack);
    }

    public void m_6596_() {
        this.markDirty();
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void handleReceivedPacket(int type) {
        switch (type) {
            case -100: {
                this.setAlerting(false);
                break;
            }
            case -10: {
                this.setSongVolume((int)(this.getSongVolume(true) * 100.0f - 10.0f));
                break;
            }
            case -5: {
                this.setSongVolume((int)(this.getSongVolume(true) * 100.0f - 5.0f));
                break;
            }
            case 5: {
                this.setSongVolume((int)(this.getSongVolume(true) * 100.0f + 5.0f));
                break;
            }
            case 10: {
                this.setSongVolume((int)(this.getSongVolume(true) * 100.0f + 10.0f));
                break;
            }
            case 1: {
                this.setSongVolume(100);
                break;
            }
            case -1: {
                this.setSongVolume(0);
                break;
            }
            case 2: {
                this.setLoopBool(true);
                break;
            }
            case -2: {
                this.setLoopBool(false);
                break;
            }
            case 3: {
                this.setAlertBool(true);
                break;
            }
            case -3: {
                this.setAlertBool(false);
                break;
            }
            case 4: {
                this.removeStack();
                break;
            }
            default: {
                System.out.println("Non-compliant type attempt of: " + type);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.m_21830_((LivingEntity)player) && !this.m_21824_() && itemStack.m_150930_(Items.f_42500_) && !this.m_21660_()) {
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                itemStack.m_41774_(1);
                if (!this.m_9236_().m_5776_()) {
                    super.m_21839_(true);
                    this.f_19804_.m_135381_(SONG_VOLUME, (Object)Float.valueOf(1.0f));
                    this.f_19804_.m_135381_(LOOP_BOOLEAN, (Object)false);
                    this.f_19804_.m_135381_(ALERT_BOOLEAN, (Object)true);
                }
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                return InteractionResult.SUCCESS;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        if (this.m_21830_((LivingEntity)player) && this.m_21824_()) {
            Boolean canHeal = itemStack.m_150930_(Items.f_42749_) || itemStack.m_150930_(Items.f_42416_) || itemStack.m_150930_(Items.f_151052_) && this.m_21223_() != this.m_21233_();
            if (!canHeal.booleanValue() && !itemStack.m_204117_(ItemTags.f_13158_)) {
                if (player.m_6047_()) {
                    if (!player.m_9236_().m_5776_()) {
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, inv, ply) -> new iDogScreenHandler(windowId, inv, null, this), (Component)Component.m_237113_((String)"iDog")), buf -> buf.writeInt(this.m_19879_()));
                    }
                    return InteractionResult.SUCCESS;
                }
                InteractionResult actionResult = super.m_6071_(player, hand);
                if ((!actionResult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    if (!this.m_9236_().m_5776_()) {
                        super.m_21839_(!this.m_21827_());
                    }
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
            }
            if (!itemStack.m_204117_(ItemTags.f_13158_)) {
                float f = this.m_21223_();
                if (itemStack.m_150930_(Items.f_42749_) || itemStack.m_150930_(Items.f_151052_)) {
                    this.m_5634_(2.5f);
                }
                if (itemStack.m_150930_(Items.f_42416_)) {
                    this.m_5634_(25.0f);
                }
                if (this.m_21223_() == f) {
                    return InteractionResult.PASS;
                }
                float g = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
                this.m_5496_(SoundEvents.f_12321_, 1.0f, g);
                this.m_5496_(SoundEvents.f_12009_, 0.5f, g);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_204117_(ItemTags.f_13158_)) {
                ItemStack discCopy = itemStack.m_41777_();
                if (this.getCurrentDiscItemStack().m_41720_() instanceof RecordItem) {
                    this.removeStack();
                } else {
                    this.setStack(0, discCopy);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_21827_() {
        return super.m_21827_();
    }

    public void m_21839_(boolean sitting) {
        super.m_21839_(sitting);
        this.m_21837_(sitting);
    }

    boolean shouldAngerAtTarget(LivingEntity entity) {
        if (!this.m_6779_(entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal) {
            if (((TamableAnimal)entity).m_269323_() == this.m_269323_()) {
                return false;
            }
            return entity.m_6095_() == EntityType.f_20532_ && this.m_21670_(entity.m_9236_()) ? true : entity.m_20148_().equals(this.getAngryAt());
        }
        return entity.m_6095_() == EntityType.f_20532_ && this.m_21670_(entity.m_9236_()) ? true : entity.m_20148_().equals(this.getAngryAt());
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.SOUNDS;
    }

    protected int m_7302_(int air) {
        return air;
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)ModSounds.ENTITY_IDOG_GROWL.get();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? (SoundEvent)ModSounds.ENTITY_IDOG_WHINE.get() : (SoundEvent)ModSounds.ENTITY_IDOG_PANT.get();
        }
        return (SoundEvent)ModSounds.ENTITY_IDOG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.ENTITY_IDOG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENTITY_IDOG_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12010_, 0.5f, 2.0f);
    }

    public void playAlertSounds(int alertType) {
        if (!this.m_9236_().m_5776_()) {
            ModPackets.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new iDogPlayAlertPacketS2C(this.m_19879_(), alertType));
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.65f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.675f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    protected void m_267689_(float posDelta) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public Component m_5446_() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return Component.m_237113_((String)"iDog");
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.m_19983_((ItemStack)this.f_19804_.m_135370_(DISC_ITEMSTACK));
        this.m_19983_(new ItemStack((ItemLike)Items.f_42416_, 1 + this.f_19796_.m_188503_(3)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void forceSync(ItemStack itemStack, String currentDisc) {
        if (this.m_9236_().f_46443_) {
            RecordItem musicDisc = (RecordItem)itemStack.m_41720_();
            this.f_19804_.m_135381_(START_TICK, (Object)this.tickCount);
            this.f_19804_.m_135381_(DISC_ITEMSTACK, (Object)itemStack);
            this.f_19804_.m_135381_(CURRENT_DISC, (Object)currentDisc);
            this.f_19804_.m_135381_(IS_PLAYING, (Object)true);
            this.setSongEndTick(musicDisc);
            this.currentSong = musicDisc.m_43051_();
        }
    }

    public void debugPrintDataTrackedValues() {
        System.out.println("--DEBUG VALUES START HERE--");
        if (this.m_9236_().m_5776_()) {
            System.out.println("On client:");
        } else {
            System.out.println("On server:");
        }
        System.out.println("Start tick: " + String.valueOf(this.f_19804_.m_135370_(START_TICK)));
        System.out.println("End tick: " + String.valueOf(this.f_19804_.m_135370_(SONG_END_TICK)));
        System.out.println("Current disc: " + (String)this.f_19804_.m_135370_(CURRENT_DISC));
        System.out.println("Disc itemstack: " + String.valueOf(this.f_19804_.m_135370_(DISC_ITEMSTACK)));
        System.out.println("Is playing?: " + String.valueOf(this.f_19804_.m_135370_(IS_PLAYING)));
        if (this.m_9236_().m_5776_()) {
            System.out.println("On client.");
        } else {
            System.out.println("On server.");
        }
        System.out.println("--DEBUG VALUES END HERE--");
    }

    class iDogEscapeDangerGoal
    extends PanicGoal {
        public iDogEscapeDangerGoal(double speed) {
            super((PathfinderMob)iDogEntity.this, speed);
        }
    }
}

