/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.network.BulkTransferAllMessage;
import net.blay09.mods.inventoryessentials.network.BulkTransferSingleMessage;
import net.blay09.mods.inventoryessentials.network.SingleTransferMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class ServerSupportedInventoryControls
extends ClientOnlyInventoryControls {
    @Override
    public boolean singleTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (clickedSlot.m_8010_((Player)player)) {
            Balm.getNetworking().sendToServer((Object)new SingleTransferMessage(clickedSlot.f_40219_));
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferSingle(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.m_6657_() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        if (clickedSlot.m_8010_((Player)player)) {
            Balm.getNetworking().sendToServer((Object)new BulkTransferSingleMessage(clickedSlot.f_40219_));
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferAll(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.m_6657_() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        if (clickedSlot.m_8010_((Player)player)) {
            Balm.getNetworking().sendToServer((Object)new BulkTransferAllMessage(clickedSlot.f_40219_));
            return true;
        }
        return false;
    }
}

