/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;

public class BulkTransferAllMessage {
    private final int slotNumber;

    public BulkTransferAllMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static BulkTransferAllMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new BulkTransferAllMessage(slotNumber);
    }

    public static void encode(BulkTransferAllMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, BulkTransferAllMessage message) {
        block13: {
            Equipable equipable;
            Object object;
            AbstractContainerMenu menu = player.f_36096_;
            if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.f_38839_.size()) break block13;
            Slot clickedSlot = (Slot)menu.f_38839_.get(message.slotNumber);
            boolean isProbablyMovingToPlayerInventory = false;
            if (!(clickedSlot.f_40218_ instanceof Inventory)) {
                isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
            }
            boolean clickedAnArmorItem = (object = clickedSlot.m_7993_().m_41720_()) instanceof Equipable && (equipable = (Equipable)object).m_40402_().m_254934_();
            boolean isInsideInventory = menu instanceof InventoryMenu;
            if (isProbablyMovingToPlayerInventory) {
                ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
                ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
                for (Slot slot : menu.f_38839_) {
                    if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.f_40218_ instanceof Inventory)) continue;
                    if (slot.m_6657_()) {
                        nonEmptySlots.add(slot);
                        continue;
                    }
                    if (Inventory.m_36045_((int)slot.m_150661_())) continue;
                    emptySlots.add(slot);
                }
                for (Slot slot : menu.f_38839_) {
                    if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    BulkTransferAllMessage.bulkTransferPreferInventory((Player)player, menu, emptySlots, nonEmptySlots, slot);
                }
            } else if (clickedAnArmorItem && isInsideInventory) {
                if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                    return;
                }
                if (clickedSlot.f_40219_ >= 5 && clickedSlot.f_40219_ < 9) {
                    for (int i = 5; i < 9; ++i) {
                        menu.m_150399_(i, 0, ClickType.QUICK_MOVE, (Player)player);
                    }
                    return;
                }
                Map<EquipmentSlot, Slot> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
                List<EquipmentSlot> equipmentSlots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
                for (int i = 5; i < 9; ++i) {
                    EquipmentSlot equipmentSlot = equipmentSlots.get(i - 5);
                    Slot swapSlot = armorSlots.get(equipmentSlot);
                    if (swapSlot == null) continue;
                    menu.m_150399_(i, 0, ClickType.PICKUP, (Player)player);
                    menu.m_150399_(swapSlot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                    menu.m_150399_(i, 0, ClickType.PICKUP, (Player)player);
                }
            } else {
                for (Slot slot : menu.f_38839_) {
                    if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    menu.m_150399_(slot.f_40219_, 0, ClickType.QUICK_MOVE, (Player)player);
                }
            }
        }
    }

    private static boolean bulkTransferPreferInventory(Player player, AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.m_7993_().m_41777_();
        if (targetStack.m_41619_()) {
            return false;
        }
        menu.m_150399_(slot.f_40219_, 0, ClickType.PICKUP, player);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.m_41613_() < Math.min(nonEmptySlot.m_6641_(), nonEmptySlot.m_5866_(stack));
            if (!hasSpaceLeft) continue;
            menu.m_150399_(nonEmptySlot.f_40219_, 0, ClickType.PICKUP, player);
            ItemStack mouseItem = menu.m_142621_();
            if (!mouseItem.m_41619_()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            menu.m_150399_(emptySlot.f_40219_, 0, ClickType.PICKUP, player);
            if (emptySlot.m_6657_()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.m_142621_()).m_41619_()) continue;
            return true;
        }
        ItemStack mouseItem = menu.m_142621_();
        if (!mouseItem.m_41619_()) {
            menu.m_150399_(slot.f_40219_, 0, ClickType.PICKUP, player);
        }
        return false;
    }
}

