/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.api.backwards_compat.CodecHelper;
import io.redspace.ironsspellbooks.api.backwards_compat.UpgradeTypeCache;
import io.redspace.ironsspellbooks.item.armor.UpgradeOrbType;
import io.redspace.ironsspellbooks.registries.UpgradeOrbTypeRegistry;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public record UpgradeData(Map<Holder<UpgradeOrbType>, Integer> upgrades, String upgradedSlot) {
    public static final String NBT = "irons_spellbooks:upgrade_data";
    public static final String LEGACY_NBT = "ISBUpgrades";
    public static final String UPGRADE_TYPE = "id";
    public static final String SLOT = "slot";
    public static final String COUNT = "count";
    public static final String UPGRADES = "upgrades";
    public static final UpgradeData NONE = new UpgradeData((Map<Holder<UpgradeOrbType>, Integer>)ImmutableMap.of(), EquipmentSlot.MAINHAND.m_20751_());
    @Deprecated(forRemoval=true)
    private static final Codec<ObjectObjectImmutablePair<String, Integer>> ELEMENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf(UPGRADE_TYPE).forGetter(it.unimi.dsi.fastutil.Pair::left), (App)Codec.INT.fieldOf(COUNT).forGetter(it.unimi.dsi.fastutil.Pair::right)).apply((Applicative)builder, ObjectObjectImmutablePair::new));
    public static final Codec<Holder<UpgradeOrbType>> I_LOVE_ONE_POINT_TWENTY = ResourceKey.m_195966_(UpgradeOrbTypeRegistry.UPGRADE_ORB_REGISTRY_KEY).xmap(UpgradeTypeCache.CACHE::get, holder -> (ResourceKey)holder.m_203543_().get());
    public static final Codec<UpgradeData> LEGACY_CODEC = Codec.of((Encoder)Encoder.error((String)"Legacy codec should never write!"), (Decoder)new Decoder<UpgradeData>(){

        public <T> DataResult<Pair<UpgradeData, T>> decode(DynamicOps<T> ops, T input) {
            try {
                ListTag inputTag = (ListTag)input;
                HashMap<Holder<UpgradeOrbType>, Integer> map = new HashMap<Holder<UpgradeOrbType>, Integer>();
                String upgradedSlot = null;
                for (Tag tag : inputTag) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag compoundTag = (CompoundTag)tag;
                    if (upgradedSlot == null) {
                        upgradedSlot = compoundTag.m_128461_(UpgradeData.SLOT);
                    }
                    ResourceLocation upgradeId = ResourceLocation.parse((String)compoundTag.m_128461_(UpgradeData.UPGRADE_TYPE));
                    Holder<UpgradeOrbType> holder = UpgradeTypeCache.CACHE.get(ResourceKey.m_135785_(UpgradeOrbTypeRegistry.UPGRADE_ORB_REGISTRY_KEY, (ResourceLocation)upgradeId));
                    int count = compoundTag.m_128451_(UpgradeData.UPGRADES);
                    map.put(holder, count);
                }
                return DataResult.success((Object)Pair.of((Object)new UpgradeData(map, upgradedSlot), input));
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
        }
    });
    public static final Codec<UpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf(SLOT).forGetter(UpgradeData::getUpgradedSlot), (App)Codec.unboundedMap(I_LOVE_ONE_POINT_TWENTY, (Codec)Codec.INT).fieldOf(UPGRADES).forGetter(UpgradeData::upgrades)).apply((Applicative)builder, (slot, list) -> new UpgradeData((Map<Holder<UpgradeOrbType>, Integer>)list, (String)slot)));

    public static UpgradeData getUpgradeData(ItemStack itemStack) {
        return CodecHelper.getOrElseWithLegacy(itemStack, NBT, CODEC, NONE, LEGACY_NBT, LEGACY_CODEC);
    }

    public static boolean hasUpgradeData(ItemStack stack) {
        return CodecHelper.hasWithLegacy(stack, NBT, LEGACY_NBT);
    }

    public static void removeUpgradeData(ItemStack itemstack) {
        itemstack.m_41784_().m_128473_(NBT);
    }

    public UpgradeData addUpgrade(ItemStack stack, Holder<UpgradeOrbType> upgradeType, String slot) {
        if (this == NONE) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put(upgradeType, (Object)1);
            UpgradeData upgrade = new UpgradeData((Map<Holder<UpgradeOrbType>, Integer>)map.build(), slot);
            UpgradeData.set(stack, upgrade);
            return upgrade;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (this.upgrades.containsKey(upgradeType)) {
            map.put(upgradeType, (Object)(this.upgrades.get(upgradeType) + 1));
            map.putAll(this.upgrades.entrySet().stream().filter(entry -> entry.getKey() != upgradeType).toList());
        } else {
            map.put(upgradeType, (Object)1);
            map.putAll(this.upgrades);
        }
        UpgradeData upgrade = new UpgradeData((Map<Holder<UpgradeOrbType>, Integer>)map.build(), this.upgradedSlot);
        UpgradeData.set(stack, upgrade);
        return upgrade;
    }

    public static void set(ItemStack stack, UpgradeData data) {
        CodecHelper.set(stack, NBT, CODEC, data);
    }

    public int getTotalUpgrades() {
        int count = 0;
        for (Map.Entry<Holder<UpgradeOrbType>, Integer> upgradeInstance : this.upgrades.entrySet()) {
            count += upgradeInstance.getValue().intValue();
        }
        return count;
    }

    public String getUpgradedSlot() {
        return this.upgradedSlot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof UpgradeData)) return false;
        UpgradeData upgradeData = (UpgradeData)obj;
        if (!this.upgradedSlot.equals(upgradeData.upgradedSlot)) return false;
        if (!this.upgrades.equals(upgradeData.upgrades)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.upgradedSlot.hashCode() * 31 + this.upgrades.hashCode();
    }
}

