/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.command.LegacyConfigConverter;
import io.redspace.ironsspellbooks.gui.inscription_table.InscriptionTableMenu;
import io.redspace.ironsspellbooks.item.armor.UpgradeOrbType;
import io.redspace.ironsspellbooks.registries.UpgradeOrbTypeRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IronsSpellbooksCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"ironsSpellbooks").requires(p -> p.m_6761_(3));
        IronsSpellbooksCommand.registerSummonCommandChain((LiteralArgumentBuilder<CommandSourceStack>)command);
        IronsSpellbooksCommand.registerUpgradeChain((LiteralArgumentBuilder<CommandSourceStack>)command);
        IronsSpellbooksCommand.registerInscriptionTableCommand((LiteralArgumentBuilder<CommandSourceStack>)command);
        IronsSpellbooksCommand.registerCameraShakeCommand((LiteralArgumentBuilder<CommandSourceStack>)command);
        IronsSpellbooksCommand.registerConfigConverter((LiteralArgumentBuilder<CommandSourceStack>)command);
        dispatcher.register(command);
    }

    public static void registerSummonCommandChain(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"summons").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82127_((String)"setOwner").then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91449_()).executes(IronsSpellbooksCommand::summonSetOwner)))));
    }

    public static void registerUpgradeChain(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"upgrade").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)ResourceKeyArgument.m_212386_(UpgradeOrbTypeRegistry.UPGRADE_ORB_REGISTRY_KEY)).executes(IronsSpellbooksCommand::upgradeHeldItem)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(IronsSpellbooksCommand::upgradeHeldItem))));
    }

    public static void registerInscriptionTableCommand(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"it").executes(source -> ((CommandSourceStack)source.getSource()).m_230896_().m_5893_((MenuProvider)new SimpleMenuProvider((i, inventory, player) -> new InscriptionTableMenu(i, inventory, ContainerLevelAccess.f_39287_), (Component)Component.m_237115_((String)"block.irons_spellbooks.inscription_table"))).orElse(0)));
    }

    public static void registerCameraShakeCommand(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"camera_shake").then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(IronsSpellbooksCommand::createCameraShake)))));
    }

    private static int upgradeHeldItem(CommandContext<CommandSourceStack> commandSourceStackCommandContext) {
        int amount = 1;
        try {
            amount = IntegerArgumentType.getInteger(commandSourceStackCommandContext, (String)"amount");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack stack = ((CommandSourceStack)commandSourceStackCommandContext.getSource()).m_230896_().m_21205_();
        if (stack.m_41619_()) {
            throw new RuntimeException("empty item");
        }
        ResourceKey resourcekey = (ResourceKey)commandSourceStackCommandContext.getArgument("type", ResourceKey.class);
        String slot = UpgradeUtils.getRelevantEquipmentSlot(stack);
        for (int i = 0; i < amount; ++i) {
            UpgradeData.set(stack, UpgradeData.getUpgradeData(stack).addUpgrade(stack, (Holder<UpgradeOrbType>)((Holder)UpgradeOrbTypeRegistry.upgradeTypeRegistry(((CommandSourceStack)commandSourceStackCommandContext.getSource()).m_5894_()).m_203636_(resourcekey).get()), slot));
        }
        return amount;
    }

    private static int summonSetOwner(CommandContext<CommandSourceStack> source) throws CommandSyntaxException {
        Entity owner = EntityArgument.m_91452_(source, (String)"owner");
        Collection targets = EntityArgument.m_91461_(source, (String)"target");
        for (Entity entity : targets) {
            SummonManager.setOwner(entity, owner);
        }
        ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Set %s as owner for %s entities", owner.m_7755_().getString(), targets.size())), true);
        return targets.size();
    }

    private static int createCameraShake(CommandContext<CommandSourceStack> source) throws CommandSyntaxException {
        Vec3 pos = Vec3Argument.m_120844_(source, (String)"pos");
        double radius = DoubleArgumentType.getDouble(source, (String)"radius");
        int ticks = IntegerArgumentType.getInteger(source, (String)"ticks");
        CameraShakeManager.addCameraShake(new CameraShakeData((Level)((CommandSourceStack)source.getSource()).m_81372_(), ticks, pos, (float)radius));
        return ticks;
    }

    public static void registerConfigConverter(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"convert_legacy_config").executes(LegacyConfigConverter::runCommand));
    }
}

