/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.item.armor.IArmorCapeProvider;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorCapeLayer
extends RenderLayer<LivingEntity, HumanoidModel<LivingEntity>> {
    private ModelPart cape = Minecraft.m_91087_().m_167973_().m_171103_(ARMOR_CAPE_LAYER).m_171324_("cape");
    private Consumer<PoseStack> bodyTransformer = poseStack -> ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
    public static ModelLayerLocation ARMOR_CAPE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"armor_cape"), "main");

    public ArmorCapeLayer(RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>> pRenderer) {
        super(pRenderer);
    }

    public ArmorCapeLayer(RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>> pRenderer, Consumer<PoseStack> bodyTransformer) {
        this(pRenderer);
        this.bodyTransformer = bodyTransformer;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, CubeDeformation.f_171458_, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, LivingEntity livingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (this.shouldRender(livingEntity)) {
            ResourceLocation texture = ((IArmorCapeProvider)livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_()).getCapeResourceLocation();
            IArmorCapeProvider.CapeData capeData = ((MagicData.IExtendedEntity)livingEntity).irons_spellbooks$getCapData();
            int lastTick = capeData.lastTick;
            if (lastTick != livingEntity.f_19797_) {
                capeData.moveCloak(livingEntity);
                capeData.lastTick = livingEntity.f_19797_;
            }
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.0f, 0.0f, 0.125f);
            double d0 = Mth.m_14139_((double)pPartialTicks, (double)capeData.xCloakO, (double)capeData.xCloak) - Mth.m_14139_((double)pPartialTicks, (double)livingEntity.f_19854_, (double)livingEntity.m_20185_());
            double d1 = Mth.m_14139_((double)pPartialTicks, (double)capeData.yCloakO, (double)capeData.yCloak) - Mth.m_14139_((double)pPartialTicks, (double)livingEntity.f_19855_, (double)livingEntity.m_20186_());
            double d2 = Mth.m_14139_((double)pPartialTicks, (double)capeData.zCloakO, (double)capeData.zCloak) - Mth.m_14139_((double)pPartialTicks, (double)livingEntity.f_19856_, (double)livingEntity.m_20189_());
            float f = Mth.m_14189_((float)pPartialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
            double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.m_14179_((float)pPartialTicks, (float)capeData.oBob, (float)capeData.bob);
            f1 += Mth.m_14031_((float)(Mth.m_14179_((float)pPartialTicks, (float)livingEntity.f_19867_, (float)livingEntity.f_19787_) * 6.0f)) * 32.0f * f4;
            if (livingEntity.m_6047_()) {
                f1 += 25.0f;
                this.cape.f_104202_ = 1.4f;
                this.cape.f_104201_ = 1.85f;
            } else {
                this.cape.f_104202_ = 0.0f;
                this.cape.f_104201_ = 0.0f;
            }
            this.bodyTransformer.accept(pPoseStack);
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(6.0f + f2 / 2.0f + f1));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f3 / 2.0f));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f3 / 2.0f));
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
            this.cape.m_104301_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_);
            pPoseStack.m_85849_();
        }
    }

    private boolean shouldRender(LivingEntity livingEntity) {
        ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        return !itemstack.m_150930_(Items.f_42741_) && itemstack.m_41720_() instanceof IArmorCapeProvider && !this.hasPlayerCape(livingEntity) && !livingEntity.m_21023_((MobEffect)MobEffectRegistry.ANGEL_WINGS.get());
    }

    private boolean hasPlayerCape(LivingEntity livingEntity) {
        AbstractClientPlayer player;
        return livingEntity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)livingEntity).m_108561_() != null;
    }
}

