/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.integration.moonlight.MoonlightCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.recipe.AntiqueAtlasRecipe;
import pepjebs.mapatlases.recipe.MapAtlasCreateRecipe;
import pepjebs.mapatlases.recipe.MapAtlasesAddRecipe;
import pepjebs.mapatlases.recipe.MapAtlasesCutExistingRecipe;
import pepjebs.mapatlases.utils.TriState;

public class MapAtlasesMod {
    public static final String MOD_ID = "map_atlases";
    public static final Logger LOGGER = LogManager.getLogger((String)"Map Atlases");
    public static final Supplier<MapAtlasItem> MAP_ATLAS;
    public static final Supplier<RecipeSerializer<MapAtlasCreateRecipe>> MAP_ATLAS_CREATE_RECIPE;
    public static final Supplier<RecipeSerializer<MapAtlasesAddRecipe>> MAP_ATLAS_ADD_RECIPE;
    public static final Supplier<RecipeSerializer<MapAtlasesCutExistingRecipe>> MAP_ATLAS_CUT_RECIPE;
    public static final Supplier<RecipeSerializer<AntiqueAtlasRecipe>> MAP_ANTIQUE_RECIPE;
    public static final Supplier<SoundEvent> ATLAS_OPEN_SOUND_EVENT;
    public static final Supplier<SoundEvent> ATLAS_PAGE_TURN_SOUND_EVENT;
    public static final Supplier<SoundEvent> ATLAS_CREATE_MAP_SOUND_EVENT;
    public static final TagKey<Item> STICKY_ITEMS;
    public static final boolean CURIOS;
    public static final boolean TRINKETS;
    public static final boolean SUPPLEMENTARIES;
    public static final boolean MOONLIGHT;
    public static final boolean TWILIGHTFOREST;
    public static final boolean IMMEDIATELY_FAST;
    private static TriState hack;

    public static void init() {
        MapAtlasesNetworking.init();
        MapAtlasesConfig.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            MapAtlasesClientConfig.init();
            MapAtlasesClient.init();
        }
        RegHelper.addItemsToTabsRegistration(MapAtlasesMod::addItemsToTabs);
        if (MOONLIGHT) {
            MoonlightCompat.init();
        }
        if (SUPPLEMENTARIES) {
            SupplementariesCompat.init();
        }
    }

    public static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addAfter(CreativeModeTabs.f_256869_, i -> i.m_150930_(Items.f_42676_), new ItemLike[]{(ItemLike)MAP_ATLAS.get()});
    }

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static TriState containsHack() {
        return hack;
    }

    public static void setMapInInventoryHack(TriState value) {
        hack = value;
    }

    public static boolean rangeCheck(int distance, int range, int scale) {
        return distance <= (range + 1 + scale) * (range + 1 + scale);
    }

    static {
        ATLAS_OPEN_SOUND_EVENT = RegHelper.registerSound((ResourceLocation)MapAtlasesMod.res("atlas_open"));
        ATLAS_PAGE_TURN_SOUND_EVENT = RegHelper.registerSound((ResourceLocation)MapAtlasesMod.res("atlas_page_turn"));
        ATLAS_CREATE_MAP_SOUND_EVENT = RegHelper.registerSound((ResourceLocation)MapAtlasesMod.res("atlas_create_map"));
        STICKY_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)MapAtlasesMod.res("sticky_crafting_items"));
        CURIOS = PlatHelper.isModLoaded((String)"curios");
        TRINKETS = PlatHelper.isModLoaded((String)"trinkets");
        SUPPLEMENTARIES = PlatHelper.isModLoaded((String)"supplementaries");
        MOONLIGHT = PlatHelper.isModLoaded((String)"moonlight");
        TWILIGHTFOREST = PlatHelper.isModLoaded((String)"twilightforest");
        IMMEDIATELY_FAST = PlatHelper.isModLoaded((String)"immediatelyfast");
        MAP_ATLAS_CREATE_RECIPE = RegHelper.registerRecipeSerializer((ResourceLocation)MapAtlasesMod.res("crafting_atlas"), MapAtlasCreateRecipe.Serializer::new);
        MAP_ATLAS_ADD_RECIPE = RegHelper.registerRecipeSerializer((ResourceLocation)MapAtlasesMod.res("adding_atlas"), () -> new SimpleCraftingRecipeSerializer(MapAtlasesAddRecipe::new));
        MAP_ATLAS_CUT_RECIPE = RegHelper.registerRecipeSerializer((ResourceLocation)MapAtlasesMod.res("cutting_atlas"), () -> new SimpleCraftingRecipeSerializer(MapAtlasesCutExistingRecipe::new));
        MAP_ANTIQUE_RECIPE = RegHelper.registerRecipeSerializer((ResourceLocation)MapAtlasesMod.res("antique_atlas"), () -> new SimpleCraftingRecipeSerializer(AntiqueAtlasRecipe::new));
        MAP_ATLAS = RegHelper.registerItem((ResourceLocation)MapAtlasesMod.res("atlas"), () -> new MapAtlasItem(new Item.Properties().m_41487_(16)));
        hack = TriState.PASS;
    }
}

