/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.moonlight.ClientMarkers;
import pepjebs.mapatlases.utils.MapDataHolder;

public class XaeroMinimapCompat {
    private static final Map<String, List<Waypoint>> WAYPOINTS_MAP = new HashMap<String, List<Waypoint>>();

    public static void parseXaeroWaypoints(String worldFolderName) {
        WAYPOINTS_MAP.clear();
        Path path = PlatHelper.getGamePath().resolve("XaeroWaypoints/" + worldFolderName + "/");
        try (DirectoryStream<Path> directories = Files.newDirectoryStream(path, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path directory : directories) {
                Path waypointsFile = Paths.get(directory.toString(), "waypoints.txt");
                if (!Files.exists(waypointsFile, new LinkOption[0])) continue;
                MapAtlasesMod.LOGGER.info("Loaded XaeroMinimap waypoint data for world {}", (Object)worldFolderName);
                List<String> lines = Files.readAllLines(waypointsFile);
                for (String line : lines) {
                    String[] parts;
                    if (!line.startsWith("waypoint:") || (parts = line.split(":")).length < 8) continue;
                    String name = parts[1];
                    int x = Integer.parseInt(parts[3]);
                    int y = Integer.parseInt(parts[4]);
                    int z = Integer.parseInt(parts[5]);
                    int color = Integer.parseInt(parts[6]);
                    Waypoint waypoint = new Waypoint(name, x, y, z, color);
                    String dim = directory.getFileName().toString();
                    WAYPOINTS_MAP.computeIfAbsent(dim, j -> new ArrayList()).add(waypoint);
                }
            }
        }
        catch (IOException e) {
            MapAtlasesMod.LOGGER.error("Failed to parse Xero waypoints: ", (Throwable)e);
        }
    }

    public static void loadXaeroWaypoints(String pMapName, MapItemSavedData data) {
        if (!WAYPOINTS_MAP.isEmpty()) {
            ResourceKey dim = data.f_77887_;
            String dimKey = XaeroMinimapCompat.getDimensionDirectoryName((ResourceKey<Level>)dim);
            List<Waypoint> waypoints = WAYPOINTS_MAP.get(dimKey);
            ArrayList toRemove = new ArrayList();
            if (waypoints != null) {
                MapDataHolder holder = new MapDataHolder(pMapName, data);
                for (Waypoint w : waypoints) {
                    if (w.y > holder.slice.heightOrTop()) continue;
                    MapBlockMarker marker = MapDataRegistry.getDefaultType().createEmptyMarker();
                    marker.setPos(new BlockPos(w.x, w.y, w.z));
                    if (marker.createDecorationFromMarker(data) == null) continue;
                    ClientMarkers.addMarker(holder, new ColumnPos(w.x, w.z), w.name, w.color);
                }
                waypoints.removeAll(toRemove);
            }
        }
    }

    private static ResourceKey<Level> findDimensionKey(String validatedName) {
        Minecraft minecraft = Minecraft.m_91087_();
        Set allDimensions = minecraft.f_91074_.f_108617_.m_105151_();
        for (ResourceKey dimensionKey : allDimensions) {
            String dimensionPath = dimensionKey.m_135782_().m_135815_().replaceAll("\\W+", "");
            if (!validatedName.equals(dimensionPath)) continue;
            return dimensionKey;
        }
        return null;
    }

    private static String getDimensionDirectoryName(ResourceKey<Level> dimKey) {
        if (dimKey == Level.f_46428_) {
            return "dim%0";
        }
        if (dimKey == Level.f_46429_) {
            return "dim%-1";
        }
        if (dimKey == Level.f_46430_) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.m_135782_();
        String var10000 = identifier.m_135827_();
        return "dim%" + var10000 + "$" + identifier.m_135815_().replace('/', '%');
    }

    public record Waypoint(String name, int x, int y, int z, int color) {
    }
}

