/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.moonlight.AtlasOnlyDecorationRenderer;
import pepjebs.mapatlases.integration.moonlight.EntityPinDecoration;

public class EntityPinDecorationRenderer
extends AtlasOnlyDecorationRenderer<EntityPinDecoration> {
    public EntityPinDecorationRenderer(ResourceLocation texture) {
        super(texture);
    }

    @Override
    public boolean render(EntityPinDecoration decoration, PoseStack matrixStack, VertexConsumer vertexBuilder, MultiBufferSource buffer, @Nullable MapItemSavedData data, boolean isOnFrame, int light, int index, boolean rendersText) {
        Entity entity = decoration.getEntity();
        if (entity == null || data == null || entity.m_213877_()) {
            return false;
        }
        double worldX = entity.m_20185_();
        double worldZ = entity.m_20189_();
        double rotation = entity.m_146908_();
        int scaleFactor = 1 << data.f_77890_;
        float f = (float)(worldX - (double)data.f_256718_) / (float)scaleFactor;
        float f1 = (float)(worldZ - (double)data.f_256789_) / (float)scaleFactor;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            if (MapAtlasesClientConfig.radarRotation.get().booleanValue()) {
                byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
                decoration.setRot(rot);
            }
            decoration.setX(mapX);
            decoration.setY(mapY);
            return super.render(decoration, matrixStack, vertexBuilder, buffer, data, isOnFrame, light, index, rendersText);
        }
        return false;
    }

    public int getAlpha(EntityPinDecoration decoration) {
        double y = Minecraft.m_91087_().f_91074_.m_20186_();
        double diff = Math.abs(decoration.getEntity().m_20186_() - y) / 15.0;
        double i = diff * diff * diff;
        return (int)Math.max(0.0, 255.0 * (1.0 - i));
    }
}

