/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.item;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.map_collection.MapKey;
import pepjebs.mapatlases.networking.C2S2COpenAtlasScreenPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.AtlasLectern;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;
import pepjebs.mapatlases.utils.TriState;

public class MapAtlasItem
extends Item {
    protected static final String EMPTY_MAPS_NBT = "empty";
    protected static final String LOCKED_NBT = "locked";
    protected static final String SELECTED_NBT = "selected";
    public static final String HEIGHT_NBT = "height";
    public static final String TYPE_NBT = "type";

    public MapAtlasItem(Item.Properties settings) {
        super(settings);
    }

    public static void removeMap(ItemStack atlas, int mapId, ServerPlayer player) {
        MapDataHolder holder;
        IMapCollection data = IMapCollection.get(atlas, player.m_9236_());
        boolean removed = data.remove(holder = MapDataHolder.findFromId(player.m_9236_(), mapId));
        if (removed) {
            ItemStack item = holder.createExistingMapItem();
            if (!player.m_150109_().m_36054_(item)) {
                player.m_36176_(item, false);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        if (level != null) {
            MapType type;
            Slice selected;
            Integer slice;
            IMapCollection maps = MapAtlasItem.getMaps(stack, level);
            int mapSize = maps.getCount();
            int empties = MapAtlasItem.getEmptyMaps(stack);
            if (MapAtlasItem.getMaxMapCount() != -1 && mapSize + empties >= MapAtlasItem.getMaxMapCount()) {
                tooltip.add((Component)Component.m_237110_((String)"item.map_atlases.atlas.tooltip_full", (Object[])new Object[]{"", null}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237110_((String)"item.map_atlases.atlas.tooltip_maps", (Object[])new Object[]{mapSize}).m_130940_(ChatFormatting.GRAY));
            if (MapAtlasesConfig.requireEmptyMapsToExpand.get().booleanValue() && MapAtlasesConfig.enableEmptyMapEntryAndFill.get().booleanValue()) {
                if (mapSize + empties == 0) {
                    empties = MapAtlasesConfig.pityActivationMapCount.get();
                }
                tooltip.add((Component)Component.m_237110_((String)"item.map_atlases.atlas.tooltip_empty", (Object[])new Object[]{empties}).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237110_((String)"filled_map.scale", (Object[])new Object[]{1 << maps.getScale()}).m_130940_(ChatFormatting.GRAY));
            if (MapAtlasItem.isLocked(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"item.map_atlases.atlas.tooltip_locked").m_130940_(ChatFormatting.GRAY));
            }
            if ((slice = (selected = MapAtlasItem.getSelectedSlice(stack, (ResourceKey<Level>)level.m_46472_())).height()) != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.map_atlases.atlas.tooltip_slice", (Object[])new Object[]{slice}).m_130940_(ChatFormatting.GRAY));
            }
            if ((type = selected.type()) != MapType.VANILLA) {
                tooltip.add((Component)Component.m_237110_((String)"item.map_atlases.atlas.tooltip_type", (Object[])new Object[]{type.getName()}).m_130940_(ChatFormatting.GRAY));
            }
            if (MapAtlasesMod.SUPPLEMENTARIES && SupplementariesCompat.hasAntiqueInk(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"item.map_atlases.atlas.supplementaries_antique").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        MapAtlasItem.convertOldAtlas(level, stack);
        if (player.m_36341_()) {
            boolean locked = !tag.m_128471_(LOCKED_NBT);
            tag.m_128379_(LOCKED_NBT, locked);
            if (player.m_9236_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)(locked ? "message.map_atlases.locked" : "message.map_atlases.unlocked")), true);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            MapAtlasItem.syncAndOpenGui(sp, stack, null, false);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    private static void convertOldAtlas(Level level, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("maps")) {
            IMapCollection maps = MapAtlasItem.getMaps(stack, level);
            for (int i : tag.m_128465_("maps")) {
                maps.add(i, level);
            }
            tag.m_128473_("maps");
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack stack = context.m_43722_();
        if (blockState.m_60713_(Blocks.f_50624_)) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof AtlasLectern) {
                AtlasLectern ah = (AtlasLectern)blockEntity;
                ah.mapatlases$setAtlas(player, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (blockState.m_204336_(BlockTags.f_13028_)) {
            if (!level.f_46443_) {
                IMapCollection maps = MapAtlasItem.getMaps(stack, level);
                MapDataHolder mapState = maps.select(MapKey.at(maps.getScale(), player, MapAtlasItem.getSelectedSlice(stack, (ResourceKey<Level>)level.m_46472_())));
                if (mapState == null) {
                    return InteractionResult.FAIL;
                }
                boolean didAdd = mapState.data.m_77934_((LevelAccessor)level, blockPos);
                if (!didAdd) {
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(context);
    }

    public static void syncAndOpenGui(ServerPlayer player, ItemStack atlas, @Nullable BlockPos lecternPos, boolean pinOnly) {
        if (atlas.m_41619_()) {
            return;
        }
        IMapCollection maps = MapAtlasItem.getMaps(atlas, player.m_9236_());
        for (MapDataHolder info : maps.getAll()) {
            MapAtlasesAccessUtils.updateMapDataAndSync(info, player, atlas, TriState.PASS);
        }
        MapAtlasesNetworking.CHANNEL.sendToClientPlayer(player, (Message)new C2S2COpenAtlasScreenPacket(lecternPos, pinOnly));
    }

    public static void setSelectedSlice(ItemStack stack, Slice slice) {
        MapType t = slice.type();
        Integer h = slice.height();
        ResourceKey<Level> dimension = slice.dimension();
        if (h == null && t == MapType.VANILLA) {
            CompoundTag tag = stack.m_41737_(SELECTED_NBT);
            if (tag != null) {
                tag.m_128473_(dimension.m_135782_().toString());
            }
        } else {
            CompoundTag tag = stack.m_41698_(SELECTED_NBT);
            tag.m_128365_(dimension.m_135782_().toString(), (Tag)slice.save());
        }
    }

    public static IMapCollection getMaps(ItemStack stack, Level level) {
        return IMapCollection.get(stack, level);
    }

    public static int getMaxMapCount() {
        return MapAtlasesConfig.maxMapCount.get();
    }

    public static int getEmptyMaps(ItemStack atlas) {
        CompoundTag tag = atlas.m_41783_();
        return tag != null && tag.m_128441_(EMPTY_MAPS_NBT) ? tag.m_128451_(EMPTY_MAPS_NBT) : 0;
    }

    public static void setEmptyMaps(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(EMPTY_MAPS_NBT, count);
    }

    public static void increaseEmptyMaps(ItemStack stack, int count) {
        MapAtlasItem.setEmptyMaps(stack, MapAtlasItem.getEmptyMaps(stack) + count);
    }

    public static boolean isLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(LOCKED_NBT);
    }

    @NotNull
    public static Slice getSelectedSlice(ItemStack stack, ResourceKey<Level> dimension) {
        String string;
        CompoundTag tag = stack.m_41737_(SELECTED_NBT);
        if (tag != null && tag.m_128441_(string = dimension.m_135782_().toString())) {
            CompoundTag t = tag.m_128469_(string);
            return Slice.parse(t, dimension);
        }
        return Slice.of(MapType.VANILLA, null, dimension);
    }

    public void m_7836_(ItemStack stack, Level level, Player pPlayer) {
        super.m_7836_(stack, level, pPlayer);
        MapAtlasItem.validateSelectedSlices(stack, level);
        MapAtlasItem.convertOldAtlas(level, stack);
    }

    private static void validateSelectedSlices(ItemStack pStack, Level level) {
        IMapCollection maps = MapAtlasItem.getMaps(pStack, level);
        Collection<ResourceKey<Level>> dim = maps.getAvailableDimensions();
        for (ResourceKey<Level> d : dim) {
            for (MapType k : maps.getAvailableTypes(d)) {
                TreeSet<Integer> av = maps.getHeightTree(d, k);
                if (av.contains(MapAtlasItem.getSelectedSlice(pStack, d).heightOrTop())) continue;
                MapAtlasItem.setSelectedSlice(pStack, Slice.of(k, av.first(), d));
            }
        }
    }
}

