/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.lifecycle;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.integration.moonlight.EntityRadar;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.map_collection.MapKey;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.networking.S2CWorldHashPacket;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;
import pepjebs.mapatlases.utils.TriState;

public class MapAtlasesServerEvents {
    private static final ReentrantLock mutex = new ReentrantLock();
    private static final WeakHashMap<Player, Tuple<Float, HashMap<String, MapUpdateTicket>>> updateQueue = new WeakHashMap();
    private static final WeakHashMap<Player, MapDataHolder> lastMapData = new WeakHashMap();

    public static void onPlayerTick(Player p) {
        ServerPlayer player = (ServerPlayer)p;
        MinecraftServer server = player.f_8924_;
        ItemStack atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player);
        if (atlas.m_41619_()) {
            return;
        }
        Level level = player.m_9236_();
        ResourceKey dimension = level.m_46472_();
        IMapCollection maps = MapAtlasItem.getMaps(atlas, level);
        Slice slice = MapAtlasItem.getSelectedSlice(atlas, (ResourceKey<Level>)dimension);
        MapKey activeKey = MapKey.at(maps.getScale(), (Player)player, slice);
        if ((level.m_46467_() + 13L) % 40L == 0L) {
            MapAtlasesServerEvents.sendSlicesAboveAndBelow(player, atlas, maps, activeKey);
        }
        int playX = player.m_20183_().m_123341_();
        int playZ = player.m_20183_().m_123343_();
        byte scale = maps.getScale();
        int scaleWidth = (1 << scale) * 128;
        Set<Vector2i> discoveringEdges = MapAtlasesServerEvents.getPlayerDiscoveringMapEdges(activeKey.mapX(), activeKey.mapZ(), scaleWidth, playX, playZ, slice.getDiscoveryReach());
        List<MapDataHolder> nearbyExistentMaps = maps.filterSection(slice, e -> discoveringEdges.stream().anyMatch(edge -> edge.x == e.f_256718_ && edge.y == e.f_256789_));
        MapDataHolder activeInfo = maps.select(activeKey);
        if (activeInfo == null && !MapAtlasItem.isLocked(atlas)) {
            MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20189_()));
            activeInfo = maps.select(activeKey);
        }
        if (activeInfo != null) {
            nearbyExistentMaps.add(activeInfo);
        }
        if (!nearbyExistentMaps.isEmpty()) {
            if (MapAtlasesConfig.roundRobinUpdate.get().booleanValue()) {
                selected = nearbyExistentMaps.get(server.m_129921_() % nearbyExistentMaps.size());
                ((MapDataHolder)selected).updateMap(player);
            } else {
                for (int j = 0; j < MapAtlasesConfig.mapUpdatePerTick.get(); ++j) {
                    selected = MapAtlasesServerEvents.getMapToUpdate(nearbyExistentMaps, player);
                    if (selected == null) continue;
                    ((MapDataHolder)selected).updateMap(player);
                }
            }
        }
        for (MapDataHolder mapInfo : nearbyExistentMaps) {
            MapAtlasesAccessUtils.updateMapDataAndSync(mapInfo, player, atlas, TriState.SET_TRUE);
        }
        MapDataHolder lastData = lastMapData.get(player);
        if (lastData != null && !nearbyExistentMaps.contains(lastData)) {
            MapAtlasesAccessUtils.updateMapDataAndSync(lastData, player, atlas, TriState.SET_FALSE);
        }
        lastMapData.put((Player)player, activeInfo);
        if (!MapAtlasesConfig.enableEmptyMapEntryAndFill.get().booleanValue() || MapAtlasItem.isLocked(atlas)) {
            return;
        }
        if (MapAtlasesServerEvents.isPlayerTooFarAway(activeKey, (Player)player, scaleWidth)) {
            MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20189_()));
        }
        discoveringEdges.removeIf(e -> nearbyExistentMaps.stream().anyMatch(d -> d.data.f_256718_ == e.x && d.data.f_256789_ == e.y));
        for (Vector2i edge : discoveringEdges) {
            MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, edge.x, edge.y);
        }
    }

    private static void sendSlicesAboveAndBelow(ServerPlayer player, ItemStack atlas, IMapCollection maps, MapKey activeKey) {
        Slice slice = activeKey.slice();
        ResourceKey<Level> dimension = activeKey.slice().dimension();
        TreeSet<Integer> tree = maps.getHeightTree(dimension, slice.type());
        for (Integer hh : tree) {
            MapDataHolder below;
            if (hh.intValue() == slice.heightOrTop() || (below = maps.select(activeKey.mapX(), activeKey.mapZ(), Slice.of(slice.type(), hh, dimension))) == null) continue;
            MapAtlasesAccessUtils.updateMapDataAndSync(below, player, atlas, TriState.SET_TRUE);
        }
    }

    private static boolean isTimeToUpdate(MapItemSavedData data, Player player, Slice slice, int min, int max) {
        int i = 1 << data.f_77890_;
        int range = slice != null && MapAtlasesMod.SUPPLEMENTARIES ? SupplementariesCompat.getSliceReach() / i : 128 / i;
        Level level = player.m_9236_();
        int rx = level.f_46441_.m_216332_(-range, range);
        int rz = level.f_46441_.m_216332_(-range, range);
        int x = (int)Mth.m_14008_((double)((player.m_20185_() + (double)rx - (double)data.f_256718_) / (double)i + 64.0), (double)0.0, (double)127.0);
        int z = (int)Mth.m_14008_((double)((player.m_20189_() + (double)rz - (double)data.f_256789_) / (double)i + 64.0), (double)0.0, (double)127.0);
        boolean filled = data.f_77891_[x + z * 128] != 0;
        int interval = filled ? max : min;
        return level.m_46467_() % (long)interval == 0L;
    }

    @Nullable
    private static MapDataHolder getMapToUpdate(List<MapDataHolder> nearbyExistentMaps, ServerPlayer player) {
        Tuple tup = updateQueue.computeIfAbsent((Player)player, a -> new Tuple((Object)Float.valueOf(0.0f), new HashMap()));
        HashMap mapsToUpdate = (HashMap)tup.m_14419_();
        HashSet<String> nearbyIds = new HashSet<String>();
        for (MapDataHolder holder : nearbyExistentMaps) {
            nearbyIds.add(holder.stringId);
            mapsToUpdate.computeIfAbsent(holder.stringId, a -> new MapUpdateTicket(holder));
        }
        int px = player.m_146903_();
        int pz = player.m_146907_();
        Iterator iterator = mapsToUpdate.entrySet().iterator();
        float totalWeight = 0.0f;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!nearbyIds.contains(entry.getKey())) {
                iterator.remove();
                continue;
            }
            MapUpdateTicket ticket = (MapUpdateTicket)entry.getValue();
            ticket.updatePriority(px, pz);
            totalWeight += ticket.getUpdateFrequencyWeight();
        }
        float callsPerTick = totalWeight / (float)nearbyExistentMaps.size();
        float counter = ((Float)tup.m_14418_()).floatValue() + callsPerTick;
        boolean shouldUpdate = false;
        if (counter >= 1.0f) {
            shouldUpdate = true;
            counter -= 1.0f;
        }
        tup.m_145023_((Object)Float.valueOf(counter));
        if (shouldUpdate) {
            MapUpdateTicket selected = mapsToUpdate.values().stream().max(MapUpdateTicket.COMPARATOR).orElseThrow();
            selected.waitTime = 0;
            selected.updateHasBlankPixels();
            return selected.holder;
        }
        return null;
    }

    public static boolean isPlayerTooFarAway(MapKey key, Player player, int width) {
        return Mth.m_144952_((double)((double)key.mapX() - player.m_20185_())) + Mth.m_144952_((double)((double)key.mapZ() - player.m_20189_())) > (double)(width * width);
    }

    private static void maybeCreateNewMapEntry(ServerPlayer player, ItemStack atlas, IMapCollection maps, Slice slice, int destX, int destZ) {
        Level level = player.m_9236_();
        if (atlas.m_41783_() == null) {
            MapAtlasItem.setEmptyMaps(atlas, MapAtlasesConfig.pityActivationMapCount.get());
        }
        int emptyCount = MapAtlasItem.getEmptyMaps(atlas);
        boolean bypassEmptyMaps = MapAtlasesConfig.requireEmptyMapsToExpand.get() == false;
        boolean addedMap = false;
        if (!mutex.isLocked() && (emptyCount > 0 || player.m_7500_() || bypassEmptyMaps)) {
            byte scale;
            ItemStack newMap;
            Integer mapId;
            Integer height;
            mutex.lock();
            if (!player.m_7500_() && !bypassEmptyMaps) {
                MapAtlasItem.increaseEmptyMaps(atlas, -1);
            }
            if ((height = slice.height()) != null && !maps.getHeightTree((ResourceKey<Level>)player.m_9236_().m_46472_(), slice.type()).contains(height)) {
                boolean bl = true;
            }
            if ((mapId = MapItem.m_151131_((ItemStack)(newMap = slice.createNewMap(destX, destZ, scale = maps.getScale(), player.m_9236_(), atlas)))) != null) {
                MapDataHolder newData = MapDataHolder.findFromId(level, mapId);
                if (newData != null) {
                    MapAtlasesAccessUtils.updateMapDataAndSync(newData, player, newMap, TriState.SET_TRUE);
                }
                addedMap = maps.add(mapId, level);
            }
            mutex.unlock();
        }
        if (addedMap) {
            player.m_9236_().m_5594_(null, player.m_20183_(), MapAtlasesMod.ATLAS_CREATE_MAP_SOUND_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static Set<Vector2i> getPlayerDiscoveringMapEdges(int xCenter, int zCenter, int width, int xPlayer, int zPlayer, int reach) {
        int halfWidth = width / 2;
        HashSet<Vector2i> results = new HashSet<Vector2i>();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                int qI = xCenter;
                int qJ = zCenter;
                if (i == -1 && xPlayer - reach <= xCenter - halfWidth) {
                    qI -= width;
                } else if (i == 1 && xPlayer + reach >= xCenter + halfWidth) {
                    qI += width;
                }
                if (j == -1 && zPlayer - reach <= zCenter - halfWidth) {
                    qJ -= width;
                } else if (j == 1 && zPlayer + reach >= zCenter + halfWidth) {
                    qJ += width;
                }
                if (qI == xCenter && qJ == zCenter) continue;
                results.add(new Vector2i(qI, qJ));
            }
        }
        return results;
    }

    public static void onPlayerJoin(ServerPlayer player) {
        ItemStack atlas;
        if (MapAtlasesMod.MOONLIGHT) {
            MapAtlasesNetworking.CHANNEL.sendToClientPlayer(player, (Message)new S2CWorldHashPacket(player));
        }
        if ((atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player)).m_41619_()) {
            return;
        }
        Level level = player.m_9236_();
        ResourceKey dimension = level.m_46472_();
        IMapCollection maps = MapAtlasItem.getMaps(atlas, level);
        Slice slice = MapAtlasItem.getSelectedSlice(atlas, (ResourceKey<Level>)dimension);
        MapKey activeKey = MapKey.at(maps.getScale(), (Player)player, slice);
        MapAtlasesServerEvents.sendSlicesAboveAndBelow(player, atlas, maps, activeKey);
        if (PlatHelper.getPlatform().isFabric()) {
            for (MapDataHolder mapDataHolder : maps.getAll()) {
            }
        }
    }

    public static void onDimensionUnload() {
        if (MapAtlasesMod.MOONLIGHT) {
            EntityRadar.unloadLevel();
        }
    }

    private static class MapUpdateTicket {
        private static final Comparator<MapUpdateTicket> COMPARATOR = Comparator.comparingDouble(MapUpdateTicket::getPriority);
        private final MapDataHolder holder;
        private int waitTime = 20;
        private double lastDistance = 1000000.0;
        private double currentPriority;
        private boolean hasBlankPixels = true;
        private int lastI = 0;
        private final float lowUpdateWeight;

        private MapUpdateTicket(MapDataHolder data) {
            this.holder = data;
            this.updateHasBlankPixels();
            if (data.type == MapType.VANILLA && data.slice.height() != null) {
                this.hasBlankPixels = false;
                this.lowUpdateWeight = 0.6f;
            } else {
                this.lowUpdateWeight = 0.15f;
            }
        }

        public double getPriority() {
            return this.hasBlankPixels ? this.currentPriority : this.currentPriority * (double)0.15f;
        }

        public void updatePriority(int px, int pz) {
            ++this.waitTime;
            double distSquared = Mth.m_211589_((double)(px - this.holder.data.f_256718_), (double)(pz - this.holder.data.f_256789_));
            double movingDistanceWeight = 1.0;
            double staticDistanceWeight = 5000.0;
            double waitTimeWeight = 1.0;
            double deltaDist = this.lastDistance - distSquared;
            this.currentPriority = movingDistanceWeight * deltaDist + waitTimeWeight * (double)this.waitTime * (double)this.waitTime + staticDistanceWeight * Mth.m_14193_((double)distSquared);
            this.lastDistance = distSquared;
        }

        public void updateHasBlankPixels() {
            if (this.hasBlankPixels) {
                while (this.lastI < this.holder.data.f_77891_.length) {
                    if (this.holder.data.f_77891_[this.lastI] == 0) {
                        return;
                    }
                    ++this.lastI;
                }
                this.hasBlankPixels = false;
            }
        }

        public float getUpdateFrequencyWeight() {
            return this.hasBlankPixels ? 1.0f : this.lowUpdateWeight;
        }
    }
}

