/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.felnull.otyacraftengine.client.ClientMixinTemp;
import dev.felnull.otyacraftengine.client.renderer.OERenderTypes;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import dev.felnull.otyacraftengine.explatform.client.OEClientExpectPlatform;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public final class OERenderUtils {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static final float MIN_BREADTH = 0.001f;

    public static void poseTrans16(@NotNull PoseStack poseStack, double x, double y, double z) {
        float pix = 0.0625f;
        poseStack.m_85837_((double)pix * x, (double)pix * y, (double)pix * z);
    }

    public static void poseScaleAll(@NotNull PoseStack poseStack, float scale) {
        poseStack.m_85841_(scale, scale, scale);
    }

    public static void poseRotateAll(@NotNull PoseStack poseStack, float x, float y, float z) {
        OERenderUtils.poseRotateX(poseStack, x);
        OERenderUtils.poseRotateY(poseStack, y);
        OERenderUtils.poseRotateZ(poseStack, z);
    }

    public static void poseRotateX(@NotNull PoseStack poseStack, float angle) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(angle));
    }

    public static void poseRotateY(@NotNull PoseStack poseStack, float angle) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
    }

    public static void poseRotateZ(@NotNull PoseStack poseStack, float angle) {
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle));
    }

    public static void poseRotateHorizontalState(@NotNull PoseStack poseStack, @NotNull BlockState state, int roted) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        OERenderUtils.poseRotateDirection(poseStack, direction, roted);
    }

    public static void poseRotateDirection(@NotNull PoseStack poseStack, @NotNull Direction direction, int roted) {
        for (int i = 0; i < roted; ++i) {
            direction = direction.m_122427_();
        }
        if (direction == Direction.WEST) {
            OERenderUtils.poseRotateY(poseStack, 180.0f);
            poseStack.m_252880_(-1.0f, 0.0f, -1.0f);
        } else if (direction == Direction.NORTH) {
            OERenderUtils.poseRotateY(poseStack, 90.0f);
            poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
        } else if (direction == Direction.SOUTH) {
            OERenderUtils.poseRotateY(poseStack, 270.0f);
            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        }
    }

    public static void poseCenterConsumer(@NotNull PoseStack poseStack, float centerX, float centerY, float centerZ, @NotNull Consumer<PoseStack> poseStackConsumer) {
        poseStack.m_252880_(centerX, centerY, centerZ);
        poseStackConsumer.accept(poseStack);
        poseStack.m_252880_(-centerX, -centerY, -centerZ);
    }

    public static void drawTexture(@NotNull ResourceLocation location, @NotNull PoseStack poseStack, float x, float y, float u0, float v0, float ru1, float rv1, float textureWidth, float textureHeight) {
        OERenderUtils.setPreDraw(location);
        OERenderUtils.blitFloat(poseStack, x, y, u0, v0, ru1, rv1, textureWidth, textureHeight);
    }

    public static void drawTexture(@NotNull ResourceLocation location, @NotNull PoseStack poseStack, float x, float y, float ru0, float rv0, float ru1, float rv1) {
        OERenderUtils.drawTexture(location, poseStack, x, y, ru0, rv0, ru1, rv1, 256.0f, 256.0f);
    }

    public static void setPreDraw(@NotNull ResourceLocation location) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setAndDrawAlpha(@NotNull ResourceLocation location, Runnable draw) {
        OERenderUtils.setPreDraw(location);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        draw.run();
        RenderSystem.disableBlend();
    }

    public static void drawTextureAlpha(@NotNull ResourceLocation location, @NotNull PoseStack poseStack, float x, float y, float u0, float v0, float ru1, float rv1, float textureWidth, float textureHeight) {
        OERenderUtils.setAndDrawAlpha(location, () -> OERenderUtils.blitFloat(poseStack, x, y, u0, v0, ru1, rv1, textureWidth, textureHeight));
    }

    public static void drawTextureAlpha(@NotNull ResourceLocation location, @NotNull PoseStack poseStack, float x, float y, float u0, float v0, float ru1, float rv1) {
        OERenderUtils.drawTextureAlpha(location, poseStack, x, y, u0, v0, ru1, rv1, 256.0f, 256.0f);
    }

    public static void blitFloat(@NotNull PoseStack poseStack, float x, float y, float u0, float v0, float rvu1, float rvv1, float textureWidth, float textureHeight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float ry = x + rvu1;
        float rh = y + rvv1;
        float ru0 = u0 / textureWidth;
        float ru1 = (u0 + rvu1) / textureWidth;
        float rv0 = v0 / textureHeight;
        float rv1 = (v0 + rvv1) / textureHeight;
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, x, rh, 0.0f).m_7421_(ru0, rv1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, ry, rh, 0.0f).m_7421_(ru1, rv1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, ry, y, 0.0f).m_7421_(ru1, rv0).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, y, 0.0f).m_7421_(ru0, rv0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void blitFloat(@NotNull PoseStack poseStack, float x, float y, float ru0, float rv0, float u1, float v1) {
        OERenderUtils.blitFloat(poseStack, x, y, ru0, rv0, u1, v1, 256.0f, 256.0f);
    }

    public static void drawFill(@NotNull PoseStack poseStack, float x, float y, float width, float height, int color) {
        OERenderUtils.innerFill(poseStack.m_85850_().m_252922_(), x, y, width, height, color);
    }

    private static void innerFill(Matrix4f matrix4f, float x, float y, float w, float h, int color) {
        float o;
        if (x < w) {
            o = x;
            x = w;
            w = o;
        }
        if (y < h) {
            o = y;
            y = h;
            h = o;
        }
        float f = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float h2 = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float p = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, x, y, 0.0f).m_85950_(g, h2, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, h, 0.0f).m_85950_(g, h2, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, w, h, 0.0f).m_85950_(g, h2, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, w, y, 0.0f).m_85950_(g, h2, p, f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, @NotNull BakedModel bakedModel, int combinedLight, int combinedOverlay) {
        Objects.requireNonNull(bakedModel);
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, @NotNull BakedModel bakedModel, int combinedLight, int combinedOverlay, int color) {
        Objects.requireNonNull(bakedModel);
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }

    @Deprecated
    public static void renderTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        OERenderUtils.poseRotateY(poseStack, yaw);
        OERenderUtils.poseRotateX(poseStack, pitch);
        OERenderUtils.poseRotateZ(poseStack, roll);
        OERenderUtils.renderTextureSprite(location, poseStack, multiBufferSource, width, height, u0, v0, u1, v1, textureWidth, textureHeight, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
    }

    public static void renderTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderSprite(poseStack, multiBufferSource.m_6299_(OERenderTypes.simpleSpriteCutout(location)), width, height, u0, v0, u1, v1, textureWidth, textureHeight, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorfulTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int color, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderColorfulSprite(poseStack, multiBufferSource.m_6299_(OERenderTypes.simpleSpriteCutout(location)), width, height, u0, v0, u1, v1, textureWidth, textureHeight, color, combinedLightIn, combinedOverlayIn);
    }

    public static void renderSprite(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderColorfulSprite(poseStack, vertexConsumer, width, height, u0, v0, u1, v1, textureWidth, textureHeight, -1, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorfulSprite(PoseStack poseStack, VertexConsumer vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int color, int combinedLightIn, int combinedOverlayIn) {
        float wst = u0 / textureWidth;
        float wft = u1 / textureWidth + wst;
        float hst = v0 / textureHeight;
        float hft = v1 / textureHeight + hst;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        OERenderUtils.vertex(vertexConsumer, pose, 0.0f, 0.0f, 0.0f, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, width, 0.0f, 0.0f, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, width, height, 0.0f, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, 0.0f, height, 0.0f, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.m_252986_(pose.m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void posePlayerArm(PoseStack poseStack, HumanoidArm arm, float swingProgress, float equipProgress) {
        boolean bl = arm != HumanoidArm.LEFT;
        float h = bl ? 1.0f : -1.0f;
        float j = Mth.m_14116_((float)swingProgress);
        float k = -0.3f * Mth.m_14031_((float)(j * (float)Math.PI));
        float l = 0.4f * Mth.m_14031_((float)(j * ((float)Math.PI * 2)));
        float m = -0.4f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        poseStack.m_252880_(h * (k + 0.64000005f), l + -0.6f + equipProgress * -0.6f, m + -0.71999997f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(h * 45.0f));
        float n = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        float o = Mth.m_14031_((float)(j * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(h * o * 70.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(h * n * -20.0f));
        poseStack.m_85837_((double)(h * -1.0f), (double)3.6f, 3.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(h * 120.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(h * -135.0f));
        poseStack.m_85837_((double)(h * 5.6f), 0.0, 0.0);
    }

    public static void renderPlayerArm(PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm arm, int light) {
        if (OERenderUtils.mc.f_91074_.m_20145_()) {
            return;
        }
        boolean bl = arm != HumanoidArm.LEFT;
        PlayerRenderer pr = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)OERenderUtils.mc.f_91074_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OERenderUtils.mc.f_91074_.m_108560_());
        if (bl) {
            pr.m_117770_(poseStack, multiBufferSource, light, (AbstractClientPlayer)OERenderUtils.mc.f_91074_);
        } else {
            pr.m_117813_(poseStack, multiBufferSource, light, (AbstractClientPlayer)OERenderUtils.mc.f_91074_);
        }
    }

    public static void poseHandItem(PoseStack poseStack, HumanoidArm arm, float swingProgress, float equipProgress) {
        boolean handFlg = arm == HumanoidArm.RIGHT;
        float s = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        float r = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * ((float)Math.PI * 2)));
        float l = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        int t = handFlg ? 1 : -1;
        poseStack.m_252880_((float)t * s, r, l);
        poseStack.m_85837_((double)((float)t * 0.56f), (double)(-0.52f + equipProgress * -0.6f), (double)-0.72f);
        float g = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        OERenderUtils.poseRotateY(poseStack, (float)t * (45.0f + g * -20.0f));
        float h = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        OERenderUtils.poseRotateZ(poseStack, (float)t * h * -20.0f);
        OERenderUtils.poseRotateX(poseStack, h * -80.0f);
        OERenderUtils.poseRotateY(poseStack, (float)t * -45.0f);
    }

    public static void renderHandItem(PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm arm, ItemStack stack, int light) {
        boolean handFlg = arm == HumanoidArm.RIGHT;
        OERenderUtils.mc.f_91063_.f_109055_.m_269530_((LivingEntity)OERenderUtils.mc.f_91074_, stack, handFlg ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !handFlg, poseStack, multiBufferSource, light);
    }

    public static void drawCenterFont(GuiGraphics guiGraphics, Component text, float x, float y, int color) {
        guiGraphics.m_280614_(OERenderUtils.mc.f_91062_, text, (int)(x - (float)OERenderUtils.mc.f_91062_.m_92852_((FormattedText)text) / 2.0f), (int)y, color, false);
    }

    public static void drawCenterFont(GuiGraphics guiGraphics, String str, float x, float y, int color) {
        guiGraphics.m_280056_(OERenderUtils.mc.f_91062_, str, (int)(x - (float)OERenderUtils.mc.f_91062_.m_92895_(str) / 2.0f), (int)y, color, false);
    }

    public static int fontDrawInBatch(Component text, float x, float y, int color, boolean shadow, Matrix4f lastPose, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        return OERenderUtils.mc.f_91062_.m_272077_(text, x, y, color, shadow, lastPose, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
    }

    public static int fontDrawInBatch(String text, float x, float y, int color, boolean shadow, Matrix4f lastPose, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        return OERenderUtils.mc.f_91062_.m_271703_(text, x, y, color, shadow, lastPose, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
    }

    @Deprecated
    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtils.mc.f_91062_;
        Objects.requireNonNull(OERenderUtils.mc.f_91062_);
        font.m_272077_(text, textX, (float)(-9) + textY, color, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    @Deprecated
    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtils.mc.f_91062_;
        Objects.requireNonNull(OERenderUtils.mc.f_91062_);
        font.m_272077_(text, textX, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    @Deprecated
    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtils.mc.f_91062_;
        float f = (float)(-OERenderUtils.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtils.mc.f_91062_);
        font.m_272077_(text, f, (float)(-9) + textY, color, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    @Deprecated
    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtils.mc.f_91062_;
        float f = (float)(-OERenderUtils.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtils.mc.f_91062_);
        font.m_272077_(text, f, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderFontSprite(Component text, int x, int y, int color, boolean shadow, PoseStack poseStack, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        poseStack.m_85836_();
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
        poseStack.m_85849_();
    }

    public static void renderFontSprite(String text, int x, int y, int color, boolean shadow, PoseStack poseStack, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        poseStack.m_85836_();
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
        poseStack.m_85849_();
    }

    public static void renderCenterFontSprite(Component text, int x, int y, int color, boolean shadow, PoseStack poseStack, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        poseStack.m_85836_();
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        x = (int)((float)x + (float)(-OERenderUtils.mc.f_91062_.m_92852_((FormattedText)text) / 2));
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
        poseStack.m_85849_();
    }

    public static void renderCenterFontSprite(String text, int x, int y, int color, boolean shadow, PoseStack poseStack, MultiBufferSource multiBufferSource, Font.DisplayMode displayMode, int bakedGlyphColor, int packedLightCoords) {
        poseStack.m_85836_();
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        x = (int)((float)x + (float)(-OERenderUtils.mc.f_91062_.m_92895_(text) / 2));
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, displayMode, bakedGlyphColor, packedLightCoords);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthFont(GuiGraphics guiGraphics, Component text, float x, float y, int color, float width) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int size = OERenderUtils.mc.f_91062_.m_92852_((FormattedText)text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtils.poseScaleAll(poseStack, scale);
        }
        guiGraphics.m_280614_(OERenderUtils.mc.f_91062_, text, (int)x, (int)y, color, false);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthFont(GuiGraphics guiGraphics, String text, float x, float y, int color, float width) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int size = OERenderUtils.mc.f_91062_.m_92895_(text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtils.poseScaleAll(poseStack, scale);
        }
        guiGraphics.m_280056_(OERenderUtils.mc.f_91062_, text, (int)x, (int)y, color, false);
        poseStack.m_85849_();
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y) {
        OERenderUtils.drawPlayerFace(poseStack, uuid, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtils.getPlayerSkinTexture(uuid);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y) {
        OERenderUtils.drawPlayerFace(poseStack, name, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtils.getPlayerSkinTexture(name);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, UUID uuid, float size, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderPlayerFaceSprite(poseStack, multiBufferSource.m_6299_(OERenderTypes.simpleSpriteCutout(OETextureUtils.getPlayerSkinTexture(uuid))), size, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, String name, float size, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderPlayerFaceSprite(poseStack, multiBufferSource.m_6299_(OERenderTypes.simpleSpriteCutout(OETextureUtils.getPlayerSkinTexture(name))), size, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, VertexConsumer vertexConsumer, float size, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        OERenderUtils.renderSprite(poseStack, vertexConsumer, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 1.0E-5f);
        OERenderUtils.renderSprite(poseStack, vertexConsumer, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static float getPartialTicks() {
        return OEClientExpectPlatform.getPartialTicks();
    }

    public static void noTransAndRotModelPart(Runnable runnable) {
        ClientMixinTemp.SKIP_TRANSANDROT_MODELPART.set(true);
        runnable.run();
        ClientMixinTemp.SKIP_TRANSANDROT_MODELPART.set(false);
    }

    public static void renderPlayerArmNoTransAndRot(PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm arm, int light) {
        OERenderUtils.noTransAndRotModelPart(() -> OERenderUtils.renderPlayerArm(poseStack, multiBufferSource, arm, light));
    }
}

