/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.entity;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.util.OEUtils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.jetbrains.annotations.NotNull;

public class PlayerInfoManager {
    private static final PlayerInfoManager INSTANCE = new PlayerInfoManager();
    private static final String NAME_BY_UUID_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static final String UUID_BY_NAME_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    private final Map<UUID, Optional<String>> NAME_BY_UUID_CACHE = new HashMap<UUID, Optional<String>>();
    private final Map<String, Optional<UUID>> UUID_BY_NAME_CACHE = new HashMap<String, Optional<UUID>>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("otyacraftengine-player-info-loader").daemon(true).build());

    public static PlayerInfoManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, Optional<Object>> map = this.NAME_BY_UUID_CACHE;
        synchronized (map) {
            this.NAME_BY_UUID_CACHE.clear();
        }
        map = this.UUID_BY_NAME_CACHE;
        synchronized (map) {
            this.UUID_BY_NAME_CACHE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(@NotNull GameProfile profile) {
        Map<Object, Optional<Object>> map = this.NAME_BY_UUID_CACHE;
        synchronized (map) {
            this.NAME_BY_UUID_CACHE.remove(profile.getId());
        }
        map = this.UUID_BY_NAME_CACHE;
        synchronized (map) {
            this.UUID_BY_NAME_CACHE.remove(profile.getName());
        }
    }

    @NotNull
    public Optional<UUID> getUUIDByName(@NotNull String name) {
        return this.getJson(String.format(UUID_BY_NAME_URL, name)).map(jo -> {
            JsonPrimitive jp;
            if (jo.has("id") && jo.get("id").isJsonPrimitive() && (jp = jo.getAsJsonPrimitive("id")).isString()) {
                return FNStringUtil.getUUIDFromNoHyphenStringNonThrow(jp.getAsString());
            }
            return null;
        });
    }

    @NotNull
    public Optional<String> getNameByUUID(@NotNull UUID uuid) {
        return this.getJson(String.format(NAME_BY_UUID_URL, uuid)).map(jo -> {
            JsonPrimitive jp;
            if (jo.has("name") && jo.get("name").isJsonPrimitive() && (jp = jo.getAsJsonPrimitive("name")).isString()) {
                return jp.getAsString();
            }
            return null;
        });
    }

    @NotNull
    private synchronized Optional<JsonObject> getJson(@NotNull String url) {
        try {
            return Optional.ofNullable(OEUtils.readJson(new URL(url), JsonObject.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @NotNull
    public CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.getNameByUUID(uuid), this.executorService);
    }

    @NotNull
    public CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> this.getUUIDByName(name), this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<UUID> getCachedUUIDByName(@NotNull String name) {
        Map<String, Optional<UUID>> map = this.UUID_BY_NAME_CACHE;
        synchronized (map) {
            return this.UUID_BY_NAME_CACHE.computeIfAbsent(name, k -> this.getUUIDByName(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<String> getCachedNameByUUID(@NotNull UUID uuid) {
        Map<UUID, Optional<String>> map = this.NAME_BY_UUID_CACHE;
        synchronized (map) {
            return this.NAME_BY_UUID_CACHE.computeIfAbsent(uuid, k -> this.getNameByUUID(uuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Optional<String>> getCachedNameByUUIDAsync(@NotNull UUID uuid) {
        Map<UUID, Optional<String>> map = this.NAME_BY_UUID_CACHE;
        synchronized (map) {
            if (this.NAME_BY_UUID_CACHE.containsKey(uuid)) {
                return CompletableFuture.completedFuture(this.NAME_BY_UUID_CACHE.get(uuid));
            }
            return CompletableFuture.supplyAsync(() -> this.getCachedNameByUUID(uuid), this.executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Optional<UUID>> getCachedUUIDByNameAsync(@NotNull String name) {
        Map<String, Optional<UUID>> map = this.UUID_BY_NAME_CACHE;
        synchronized (map) {
            if (this.UUID_BY_NAME_CACHE.containsKey(name)) {
                return CompletableFuture.completedFuture(this.UUID_BY_NAME_CACHE.get(name));
            }
            return CompletableFuture.supplyAsync(() -> this.getCachedUUIDByName(name), this.executorService);
        }
    }
}

