/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.shape;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoxelClientShape {
    private final String meta;
    private final String version;
    private final Set<VoxelEdge> renderEdges;
    private final Map<VoxelEntry, VoxelEdge[]> edgeCache = new HashMap<VoxelEntry, VoxelEdge[]>();

    public VoxelClientShape(@Nullable String meta, @Nullable String version, @NotNull Set<VoxelEdge> edges) {
        this.meta = meta;
        this.version = version;
        this.renderEdges = ImmutableSet.copyOf(edges);
    }

    @NotNull
    public Set<VoxelEdge> getRenderEdges() {
        return this.renderEdges;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getMeta() {
        return this.meta;
    }

    @Nullable
    public static VoxelClientShape parse(JsonObject jo) {
        if (!(jo != null && jo.has("type") && jo.get("type").isJsonPrimitive() && "ikisugi_voxel_shape".equals(jo.get("type").getAsString()))) {
            return null;
        }
        String meta = null;
        if (jo.has("meta") && jo.get("meta").isJsonPrimitive()) {
            meta = jo.get("meta").getAsString();
        }
        String version = null;
        if (jo.has("version") && jo.get("version").isJsonPrimitive()) {
            version = jo.get("version").getAsString();
        }
        ImmutableSet.Builder edgeBuilder = new ImmutableSet.Builder();
        if (jo.has("edges") && jo.get("edges").isJsonArray()) {
            JsonArray ja = jo.getAsJsonArray("edges");
            for (JsonElement element : ja) {
                VoxelEdge ed;
                if (!element.isJsonArray() || (ed = VoxelEdge.parse(element.getAsJsonArray())) == null) continue;
                edgeBuilder.add((Object)ed);
            }
        }
        return new VoxelClientShape(meta, version, (Set<VoxelEdge>)edgeBuilder.build());
    }

    public String toString() {
        return "VoxelClientShape{meta='" + this.meta + "', version='" + this.version + "', renderEdges count=" + this.renderEdges.size() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoxelClientShape that = (VoxelClientShape)o;
        return Objects.equals(this.meta, that.meta) && Objects.equals(this.version, that.version) && Objects.equals(this.renderEdges, that.renderEdges);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.version, this.renderEdges);
    }

    public VoxelEdge[] getEdgeCache(VoxelEntry entry) {
        return this.edgeCache.get(entry);
    }

    public void setEdgeCache(VoxelEntry entry, VoxelEdge[] edges) {
        this.edgeCache.put(entry, edges);
    }
}

