/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data;

import dev.architectury.platform.Mod;
import dev.felnull.otyacraftengine.data.provider.AdvancementProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.AdvancementSubProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BasicProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BiomeTagsProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockLootTableProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockStateAndModelProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.DamageTypeTagsProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.FluidTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemModelProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.PoiTypeTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public interface CrossDataGeneratorAccess {
    @NotNull
    public DataGenerator getVanillaGenerator();

    public <T extends DataProvider> T addProvider(@NotNull DataProvider.Factory<T> var1);

    public <T extends DataProvider> T addProvider(@NotNull BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> var1);

    default public <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.GeneratorAccessedFactory<T> factory) {
        return (T)this.addProviderWrapper((PackOutput packOutput) -> factory.create(packOutput, this));
    }

    default public <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.Factory<T> factory) {
        AtomicReference providerWrapper = new AtomicReference();
        this.addProvider(packOutput -> {
            providerWrapper.set(factory.create(packOutput));
            return ((DataProviderWrapper)providerWrapper.get()).getProvider();
        });
        return (T)((DataProviderWrapper)providerWrapper.get());
    }

    default public <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.LookupGeneratorAccessedFactory<T> factory) {
        return (T)this.addProviderWrapper((PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) -> factory.create(packOutput, lookup, this));
    }

    default public <T extends DataProviderWrapper<?>> T addProviderWrapper(@NotNull DataProviderWrapper.LookupFactory<T> factory) {
        AtomicReference providerWrapper = new AtomicReference();
        this.addProvider((PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) -> {
            providerWrapper.set(factory.create((PackOutput)packOutput, (CompletableFuture<HolderLookup.Provider>)lookup));
            return ((DataProviderWrapper)providerWrapper.get()).getProvider();
        });
        return (T)((DataProviderWrapper)providerWrapper.get());
    }

    public Mod getMod();

    public RecipeProvider createRecipeProvider(PackOutput var1, RecipeProviderWrapper var2);

    public TagsProvider<Item> createItemTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, ItemTagProviderWrapper var3, @NotNull BlockTagProviderWrapper var4);

    public TagsProvider<Fluid> createFluidTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, FluidTagProviderWrapper var3);

    public TagsProvider<Block> createBlockTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, BlockTagProviderWrapper var3);

    public TagsProvider<PoiType> createPoiTypeTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, PoiTypeTagProviderWrapper var3);

    public TagsProvider<DamageType> createDamageTypeTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, DamageTypeTagsProviderWrapper var3);

    public TagsProvider<Biome> createBiomeTagProvider(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, BiomeTagsProviderWrapper var3);

    public DataProvider createBasicProvider(BasicProviderWrapper var1);

    public DataProvider createBlockLootTableProvider(PackOutput var1, BlockLootTableProviderWrapper var2);

    public DataProvider createAdvancementProvider(PackOutput var1, AdvancementProviderWrapper var2, List<AdvancementSubProviderWrapper> var3);

    public DataProvider createItemModelProvider(PackOutput var1, ItemModelProviderWrapper var2);

    public DataProvider createBlockStateAndModelProvider(PackOutput var1, BlockStateAndModelProviderWrapper var2);

    public RegistriesDatapackGenerator createRegistriesDatapackGenerator(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, RegistrySetBuilder var3);

    public Collection<Path> getResourceInputFolders();

    public void addResourceInputFolders(Path var1);
}

