/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.model.BlockStateAndModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.model.FileTexture;
import dev.felnull.otyacraftengine.data.model.ItemModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import dev.felnull.otyacraftengine.forge.data.WrappedBlockStateBuilder;
import dev.felnull.otyacraftengine.forge.data.model.BlockMutableFileModelImpl;
import dev.felnull.otyacraftengine.forge.data.model.FileModelImpl;
import dev.felnull.otyacraftengine.forge.data.model.ItemModelProviderAccessImpl;
import dev.felnull.otyacraftengine.forge.data.model.UncheckedTextureModelBuilder;
import dev.felnull.otyacraftengine.forge.mixin.data.BlockStateProviderAccessor;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BlockStateAndModelProviderAccessImpl
implements BlockStateAndModelProviderAccess {
    private final BlockStateProvider blockStateProvider;
    private final ItemModelProviderAccess itemModelProviderAccess;

    public BlockStateAndModelProviderAccessImpl(BlockStateProvider blockStateProvider) {
        this.blockStateProvider = blockStateProvider;
        this.itemModelProviderAccess = new ItemModelProviderAccessImpl(blockStateProvider.itemModels());
    }

    @Override
    public void simpleFlatBlockItemModel(@NotNull Block block) {
        ResourceLocation itemLoc = ModelLocationUtils.m_125571_((Item)block.m_5456_());
        ResourceLocation blockLoc = this.blockStateProvider.blockTexture(block);
        ((ItemModelBuilder)((ItemModelBuilder)this.blockStateProvider.itemModels().getBuilder(itemLoc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", blockLoc);
    }

    @Override
    @NotNull
    public FileModel uncheckedModel(@NotNull ResourceLocation modelLocation) {
        return this.of((ModelFile)new ModelFile.UncheckedModelFile(modelLocation));
    }

    @Override
    public void stairsBlockItemModel(@NotNull StairBlock stairBlock, @NotNull FileModel baseBlockModel) {
        this.blockStateProvider.stairsBlock(stairBlock, baseBlockModel.getLocation());
        this.simpleBlockItemModel((Block)stairBlock, this.existingModel(this.key((Block)stairBlock)));
    }

    @Override
    public void slabBlockItemModel(@NotNull SlabBlock slabBlock, @NotNull FileModel baseBlockModel) {
        ResourceLocation loc = baseBlockModel.getLocation();
        this.blockStateProvider.slabBlock(slabBlock, loc, loc, loc, loc);
        this.simpleBlockItemModel((Block)slabBlock, this.existingModel(this.key((Block)slabBlock)));
    }

    @Override
    public void logBlockItemModel(@NotNull RotatedPillarBlock block) {
        this.blockStateProvider.logBlock(block);
    }

    @Override
    @NotNull
    public BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput() {
        return (loc, jsonSupplier) -> this.blockStateProvider.models().generatedModels.put(loc, new SimpleJsonModelBuilder((ResourceLocation)loc, this.blockStateProvider.models().existingFileHelper, (JsonObject)jsonSupplier.get()));
    }

    @Override
    public void simpleCubeBlockStateModelAndItemModel(@NotNull Block block) {
        ModelFile model = this.blockStateProvider.cubeAll(block);
        this.blockStateProvider.simpleBlock(block, model);
        this.blockStateProvider.simpleBlockItem(block, model);
    }

    private FileModel of(ModelFile modelFile) {
        return new FileModelImpl(modelFile);
    }

    private MutableFileModel of(BlockModelBuilder blockModelBuilder) {
        return new BlockMutableFileModelImpl(blockModelBuilder);
    }

    @Override
    @NotNull
    public FileModel cubeAllBlockModel(@NotNull ResourceLocation blockLocation, @NotNull ResourceLocation textureLocation) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cubeAll(blockLocation.toString(), textureLocation));
    }

    @Override
    @NotNull
    public FileModel cubeAllBlockModel(@NotNull ResourceLocation blockLocation, @NotNull FileTexture fileTexture) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(blockLocation.toString(), "block/cube_all");
        return this.of(this.setTexture(bm, "all", fileTexture));
    }

    @Override
    @NotNull
    public FileModel cubeAllBlockModel(@NotNull Block block, @NotNull ResourceLocation texture) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cubeAll(this.name(block), texture));
    }

    @Override
    @NotNull
    public FileModel cubeAllBlockModel(@NotNull Block block, @NotNull FileTexture fileTexture) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(this.name(block), "block/cube_all");
        return this.of(this.setTexture(bm, "all", fileTexture));
    }

    @Override
    @NotNull
    public FileModel cubeBlockModel(@NotNull ResourceLocation blockLocation, @NotNull ResourceLocation down, @NotNull ResourceLocation up, @NotNull ResourceLocation north, @NotNull ResourceLocation south, @NotNull ResourceLocation east, @NotNull ResourceLocation west) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cube(blockLocation.toString(), down, up, north, south, east, west));
    }

    @Override
    @NotNull
    public FileModel cubeBlockModel(@NotNull ResourceLocation blockLocation, @NotNull FileTexture down, @NotNull FileTexture up, @NotNull FileTexture north, @NotNull FileTexture south, @NotNull FileTexture east, @NotNull FileTexture west) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(blockLocation.toString(), "cube");
        this.setTexture(bm, "down", down);
        this.setTexture(bm, "up", up);
        this.setTexture(bm, "north", north);
        this.setTexture(bm, "south", south);
        this.setTexture(bm, "east", east);
        this.setTexture(bm, "west", west);
        return this.of(bm);
    }

    @Override
    @NotNull
    public FileModel cubeBlockModel(@NotNull Block block, @NotNull ResourceLocation down, @NotNull ResourceLocation up, @NotNull ResourceLocation north, @NotNull ResourceLocation south, @NotNull ResourceLocation east, @NotNull ResourceLocation west) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cube(this.name(block), down, up, north, south, east, west));
    }

    @Override
    @NotNull
    public FileModel cubeBlockModel(@NotNull Block block, @NotNull FileTexture down, @NotNull FileTexture up, @NotNull FileTexture north, @NotNull FileTexture south, @NotNull FileTexture east, @NotNull FileTexture west) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(this.name(block), "cube");
        this.setTexture(bm, "down", down);
        this.setTexture(bm, "up", up);
        this.setTexture(bm, "north", north);
        this.setTexture(bm, "south", south);
        this.setTexture(bm, "east", east);
        this.setTexture(bm, "west", west);
        return this.of(bm);
    }

    @Override
    @NotNull
    public FileModel cubeBottomTopBlockModel(@NotNull ResourceLocation blockLocation, @NotNull ResourceLocation bottom, @NotNull ResourceLocation side, @NotNull ResourceLocation top) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cubeBottomTop(blockLocation.toString(), side, bottom, top));
    }

    @Override
    @NotNull
    public FileModel cubeBottomTopBlockModel(@NotNull ResourceLocation blockLocation, @NotNull FileTexture bottom, @NotNull FileTexture side, @NotNull FileTexture top) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(blockLocation.toString(), "block/cube_bottom_top");
        this.setTexture(bm, "side", side);
        this.setTexture(bm, "bottom", bottom);
        this.setTexture(bm, "top", top);
        return this.of(bm);
    }

    @Override
    @NotNull
    public FileModel cubeBottomTopBlockModel(@NotNull Block block, @NotNull ResourceLocation bottom, @NotNull ResourceLocation side, @NotNull ResourceLocation top) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().cubeBottomTop(this.name(block), side, bottom, top));
    }

    @Override
    @NotNull
    public FileModel cubeBottomTopBlockModel(@NotNull Block block, @NotNull FileTexture bottom, @NotNull FileTexture side, @NotNull FileTexture top) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().withExistingParent(this.name(block), "block/cube_bottom_top");
        this.setTexture(bm, "side", side);
        this.setTexture(bm, "bottom", bottom);
        this.setTexture(bm, "top", top);
        return this.of(bm);
    }

    @Override
    @NotNull
    public MutableFileModel parentedBlockModel(@NotNull Block block, @NotNull ResourceLocation parentLocation) {
        return this.of((BlockModelBuilder)this.blockStateProvider.models().withExistingParent(this.name(block), parentLocation));
    }

    @Override
    @NotNull
    public FileModel existingModel(@NotNull ResourceLocation location) {
        return this.of((ModelFile)this.blockStateProvider.models().getExistingFile(location));
    }

    @Override
    @NotNull
    public FileModel particleOnlyModel(@NotNull Block block, @NotNull ResourceLocation particleLocation) {
        return this.of((BlockModelBuilder)((BlockModelBuilder)this.blockStateProvider.models().getBuilder(this.name(block))).texture("particle", particleLocation));
    }

    @Override
    @NotNull
    public FileModel particleOnlyModel(@NotNull Block block, @NotNull FileTexture particleLocation) {
        BlockModelBuilder bm = (BlockModelBuilder)this.blockStateProvider.models().getBuilder(this.name(block));
        this.setTexture(bm, "particle", particleLocation);
        return this.of(bm);
    }

    @Override
    public void simpleBlockState(@NotNull Block block, @NotNull FileModel model) {
        this.blockStateProvider.simpleBlock(block, FileModelImpl.getModelFile(model));
    }

    @Override
    public void simpleBlockItemModel(@NotNull Block block, @NotNull FileModel model) {
        this.blockStateProvider.simpleBlockItem(block, FileModelImpl.getModelFile(model));
    }

    @Override
    public void horizontalBlockState(@NotNull Block block, @NotNull FileModel model) {
        this.blockStateProvider.horizontalBlock(block, FileModelImpl.getModelFile(model));
    }

    @Override
    public void parentedBlockItemModel(@NotNull Block block, @NotNull ResourceLocation parentLocation) {
        ResourceLocation name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()));
        ((ItemModelBuilder)this.blockStateProvider.itemModels().getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(parentLocation));
    }

    @Override
    public void addBlockStateGenerator(@NotNull BlockStateGenerator blockStateGenerator) {
        Block block = blockStateGenerator.m_6968_();
        if (((BlockStateProviderAccessor)this.blockStateProvider).getRegisteredBlocks().containsKey(block)) {
            throw new IllegalStateException("Duplicate registration");
        }
        ((BlockStateProviderAccessor)this.blockStateProvider).getRegisteredBlocks().put(block, new WrappedBlockStateBuilder(blockStateGenerator));
    }

    @Override
    public ItemModelProviderAccess itemModelProviderAccess() {
        return this.itemModelProviderAccess;
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private BlockModelBuilder setTexture(BlockModelBuilder blockModelBuilder, String key, FileTexture fileTexture) {
        if (fileTexture.isExistingCheck()) {
            blockModelBuilder.texture(key, fileTexture.getLocation());
        } else {
            ((UncheckedTextureModelBuilder)blockModelBuilder).uncheckedTexture(key, fileTexture.getLocation());
        }
        return blockModelBuilder;
    }

    private static class SimpleJsonModelBuilder
    extends BlockModelBuilder {
        private final JsonObject jsonObject;

        protected SimpleJsonModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper, JsonObject jsonObject) {
            super(outputLocation, existingFileHelper);
            this.jsonObject = jsonObject;
        }

        public JsonObject toJson() {
            return this.jsonObject;
        }
    }
}

